/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.ec2;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupDescription {
    private String name;
    private String desc;
    private String owner;
    private List<IpPermission> perms = new ArrayList<IpPermission>();

    public GroupDescription(String name, String desc, String owner) {
        this.name = name;
        this.desc = desc;
        this.owner = owner;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getOwner() {
        return this.owner;
    }

    public IpPermission addPermission(String protocol, int fromPort, int toPort) {
        IpPermission perm = new IpPermission(protocol, fromPort, toPort);
        this.perms.add(perm);
        return perm;
    }

    public List<IpPermission> getPermissions() {
        return this.perms;
    }

    public String toString() {
        return "Group[name=" + this.name + ", Desc=" + this.desc + ", own=" + this.owner + ", perms=" + this.perms + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IpPermission {
        private String protocol;
        private int fromPort;
        private int toPort;
        private List<String> cidrIps = new ArrayList<String>();
        private List<String[]> uid_group_pairs = new ArrayList<String[]>();

        public IpPermission(String protocol, int fromPort, int toPort) {
            this.protocol = protocol;
            this.fromPort = fromPort;
            this.toPort = toPort;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public int getFromPort() {
            return this.fromPort;
        }

        public int getToPort() {
            return this.toPort;
        }

        public void addIpRange(String cidrIp) {
            this.cidrIps.add(cidrIp);
        }

        public List<String> getIpRanges() {
            return this.cidrIps;
        }

        public void addUserGroupPair(String userId, String groupName) {
            this.uid_group_pairs.add(new String[]{userId, groupName});
        }

        public List<String[]> getUidGroupPairs() {
            return this.uid_group_pairs;
        }

        public String toString() {
            ArrayList<String> uid_grp_str = new ArrayList<String>();
            for (String[] pair : this.uid_group_pairs) {
                uid_grp_str.add("(" + pair[0] + "," + pair[1] + ")");
            }
            return "[proto=" + this.protocol + ", portRng=(" + this.fromPort + ".." + this.toPort + "), cidrIps=" + this.cidrIps + ", uidgrp=" + uid_grp_str + "]";
        }
    }
}

