/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.ec2;

import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.ec2.AddressInfo;
import com.xerox.amazonws.ec2.AvailabilityZone;
import com.xerox.amazonws.ec2.BlockDeviceMapping;
import com.xerox.amazonws.ec2.ConsoleOutput;
import com.xerox.amazonws.ec2.DescribeImageAttributeResult;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.GroupDescription;
import com.xerox.amazonws.ec2.ImageAttribute;
import com.xerox.amazonws.ec2.ImageDescription;
import com.xerox.amazonws.ec2.ImageListAttribute;
import com.xerox.amazonws.ec2.ImageListAttributeItem;
import com.xerox.amazonws.ec2.ImageType;
import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.LaunchConfiguration;
import com.xerox.amazonws.ec2.LaunchPermissionAttribute;
import com.xerox.amazonws.ec2.ProductCodesAttribute;
import com.xerox.amazonws.ec2.ProductInstanceInfo;
import com.xerox.amazonws.ec2.ReservationDescription;
import com.xerox.amazonws.ec2.TerminatingInstanceDescription;
import com.xerox.amazonws.typica.jaxb.AllocateAddressResponse;
import com.xerox.amazonws.typica.jaxb.AssociateAddressResponse;
import com.xerox.amazonws.typica.jaxb.AuthorizeSecurityGroupIngressResponse;
import com.xerox.amazonws.typica.jaxb.AvailabilityZoneItemType;
import com.xerox.amazonws.typica.jaxb.AvailabilityZoneSetType;
import com.xerox.amazonws.typica.jaxb.BlockDeviceMappingItemType;
import com.xerox.amazonws.typica.jaxb.BlockDeviceMappingType;
import com.xerox.amazonws.typica.jaxb.ConfirmProductInstanceResponse;
import com.xerox.amazonws.typica.jaxb.CreateKeyPairResponse;
import com.xerox.amazonws.typica.jaxb.CreateSecurityGroupResponse;
import com.xerox.amazonws.typica.jaxb.DeleteKeyPairResponse;
import com.xerox.amazonws.typica.jaxb.DeleteSecurityGroupResponse;
import com.xerox.amazonws.typica.jaxb.DeregisterImageResponse;
import com.xerox.amazonws.typica.jaxb.DescribeAddressesResponse;
import com.xerox.amazonws.typica.jaxb.DescribeAddressesResponseInfoType;
import com.xerox.amazonws.typica.jaxb.DescribeAddressesResponseItemType;
import com.xerox.amazonws.typica.jaxb.DescribeAvailabilityZonesResponse;
import com.xerox.amazonws.typica.jaxb.DescribeImageAttributeResponse;
import com.xerox.amazonws.typica.jaxb.DescribeImagesResponse;
import com.xerox.amazonws.typica.jaxb.DescribeImagesResponseInfoType;
import com.xerox.amazonws.typica.jaxb.DescribeImagesResponseItemType;
import com.xerox.amazonws.typica.jaxb.DescribeInstancesResponse;
import com.xerox.amazonws.typica.jaxb.DescribeKeyPairsResponse;
import com.xerox.amazonws.typica.jaxb.DescribeKeyPairsResponseInfoType;
import com.xerox.amazonws.typica.jaxb.DescribeKeyPairsResponseItemType;
import com.xerox.amazonws.typica.jaxb.DescribeSecurityGroupsResponse;
import com.xerox.amazonws.typica.jaxb.DisassociateAddressResponse;
import com.xerox.amazonws.typica.jaxb.GetConsoleOutputResponse;
import com.xerox.amazonws.typica.jaxb.GroupItemType;
import com.xerox.amazonws.typica.jaxb.GroupSetType;
import com.xerox.amazonws.typica.jaxb.IpPermissionSetType;
import com.xerox.amazonws.typica.jaxb.IpPermissionType;
import com.xerox.amazonws.typica.jaxb.IpRangeItemType;
import com.xerox.amazonws.typica.jaxb.LaunchPermissionItemType;
import com.xerox.amazonws.typica.jaxb.LaunchPermissionListType;
import com.xerox.amazonws.typica.jaxb.ModifyImageAttributeResponse;
import com.xerox.amazonws.typica.jaxb.NullableAttributeValueType;
import com.xerox.amazonws.typica.jaxb.ProductCodeItemType;
import com.xerox.amazonws.typica.jaxb.ProductCodeListType;
import com.xerox.amazonws.typica.jaxb.ProductCodesSetItemType;
import com.xerox.amazonws.typica.jaxb.ProductCodesSetType;
import com.xerox.amazonws.typica.jaxb.RebootInstancesResponse;
import com.xerox.amazonws.typica.jaxb.RegisterImageResponse;
import com.xerox.amazonws.typica.jaxb.ReleaseAddressResponse;
import com.xerox.amazonws.typica.jaxb.ReservationSetType;
import com.xerox.amazonws.typica.jaxb.ResetImageAttributeResponse;
import com.xerox.amazonws.typica.jaxb.RevokeSecurityGroupIngressResponse;
import com.xerox.amazonws.typica.jaxb.RunInstancesResponse;
import com.xerox.amazonws.typica.jaxb.RunningInstancesItemType;
import com.xerox.amazonws.typica.jaxb.RunningInstancesSetType;
import com.xerox.amazonws.typica.jaxb.SecurityGroupItemType;
import com.xerox.amazonws.typica.jaxb.SecurityGroupSetType;
import com.xerox.amazonws.typica.jaxb.TerminateInstancesResponse;
import com.xerox.amazonws.typica.jaxb.TerminateInstancesResponseInfoType;
import com.xerox.amazonws.typica.jaxb.TerminateInstancesResponseItemType;
import com.xerox.amazonws.typica.jaxb.UserIdGroupPairType;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jec2
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(Jec2.class);

    public Jec2(String awsAccessId, String awsSecretKey) {
        this(awsAccessId, awsSecretKey, true);
    }

    public Jec2(String awsAccessId, String awsSecretKey, boolean isSecure) {
        this(awsAccessId, awsSecretKey, isSecure, "ec2.amazonaws.com");
    }

    public Jec2(String awsAccessId, String awsSecretKey, boolean isSecure, String server) {
        this(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
    }

    public Jec2(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("2008-02-01");
        this.headers.put("Version", vals);
    }

    public String registerImage(String imageLocation) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ImageLocation", imageLocation);
        GetMethod method = new GetMethod();
        try {
            RegisterImageResponse response = this.makeRequest((HttpMethodBase)method, "RegisterImage", params, RegisterImageResponse.class);
            String string = response.getImageId();
            return string;
        }
        catch (JAXBException ex) {
            throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public void deregisterImage(String imageId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ImageId", imageId);
        GetMethod method = new GetMethod();
        try {
            try {
                DeregisterImageResponse response = this.makeRequest((HttpMethodBase)method, "DeregisterImage", params, DeregisterImageResponse.class);
                if (!response.isReturn()) {
                    throw new EC2Exception("Could not deregister image : " + imageId + ". No reason given.");
                }
            }
            catch (JAXBException ex) {
                throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (MalformedURLException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public List<ImageDescription> describeImages(String[] imageIds) throws EC2Exception {
        return this.describeImages(Arrays.asList(imageIds));
    }

    public List<ImageDescription> describeImages(List<String> imageIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 0;
        while (i < imageIds.size()) {
            params.put("ImageId." + (i + 1), imageIds.get(i));
            ++i;
        }
        return this.describeImages(params);
    }

    public List<ImageDescription> describeImagesByOwner(List<String> owners) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 0;
        while (i < owners.size()) {
            params.put("Owner." + (i + 1), owners.get(i));
            ++i;
        }
        return this.describeImages(params);
    }

    public List<ImageDescription> describeImagesByExecutability(List<String> users) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 0;
        while (i < users.size()) {
            params.put("ExecutableBy." + (i + 1), users.get(i));
            ++i;
        }
        return this.describeImages(params);
    }

    public List<ImageDescription> describeImagesByImageType(ImageType type) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ImageType", type.getTypeId());
        return this.describeImages(params);
    }

    public List<ImageDescription> describeImages(List<String> imageIds, List<String> owners, List<String> users, ImageType type) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 0;
        while (i < imageIds.size()) {
            params.put("ImageId." + (i + 1), imageIds.get(i));
            ++i;
        }
        i = 0;
        while (i < owners.size()) {
            params.put("Owner." + (i + 1), owners.get(i));
            ++i;
        }
        i = 0;
        while (i < users.size()) {
            params.put("ExecutableBy." + (i + 1), users.get(i));
            ++i;
        }
        if (type != null) {
            params.put("ImageType", type.getTypeId());
        }
        return this.describeImages(params);
    }

    protected List<ImageDescription> describeImages(Map<String, String> params) throws EC2Exception {
        GetMethod method = new GetMethod();
        try {
            DescribeImagesResponse response = this.makeRequest((HttpMethodBase)method, "DescribeImages", params, DescribeImagesResponse.class);
            ArrayList<ImageDescription> result = new ArrayList<ImageDescription>();
            DescribeImagesResponseInfoType set = response.getImagesSet();
            for (DescribeImagesResponseItemType item : set.getItems()) {
                ArrayList<String> codes = new ArrayList<String>();
                ProductCodesSetType code_set = item.getProductCodes();
                if (code_set != null) {
                    for (ProductCodesSetItemType code : code_set.getItems()) {
                        codes.add(code.getProductCode());
                    }
                }
                result.add(new ImageDescription(item.getImageId(), item.getImageLocation(), item.getImageOwnerId(), item.getImageState(), item.isIsPublic(), codes));
            }
            ArrayList<ImageDescription> arrayList = result;
            return arrayList;
        }
        catch (JAXBException ex) {
            throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public ReservationDescription runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String userData, String keyName) throws EC2Exception {
        return this.runInstances(imageId, minCount, maxCount, groupSet, userData, keyName, true, InstanceType.DEFAULT);
    }

    public ReservationDescription runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String userData, String keyName, boolean publicAddr) throws EC2Exception {
        return this.runInstances(imageId, minCount, maxCount, groupSet, userData, keyName, publicAddr, InstanceType.DEFAULT);
    }

    public ReservationDescription runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String userData, String keyName, InstanceType type) throws EC2Exception {
        return this.runInstances(imageId, minCount, maxCount, groupSet, userData, keyName, true, type);
    }

    public ReservationDescription runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String userData, String keyName, boolean publicAddr, InstanceType type) throws EC2Exception {
        return this.runInstances(imageId, minCount, maxCount, groupSet, userData, keyName, publicAddr, type, null, null, null, null);
    }

    public ReservationDescription runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String userData, String keyName, boolean publicAddr, InstanceType type, String availabilityZone, String kernelId, String ramdiskId, List<BlockDeviceMapping> blockDeviceMappings) throws EC2Exception {
        LaunchConfiguration lc = new LaunchConfiguration(imageId);
        lc.setMinCount(minCount);
        lc.setMaxCount(maxCount);
        lc.setSecurityGroup(groupSet);
        if (userData != null) {
            lc.setUserData(userData.getBytes());
        }
        lc.setKeyName(keyName);
        lc.setInstanceType(type);
        lc.setAvailabilityZone(availabilityZone);
        lc.setKernelId(kernelId);
        lc.setRamdiskId(ramdiskId);
        lc.setBlockDevicemappings(blockDeviceMappings);
        return this.runInstances(lc);
    }

    public ReservationDescription runInstances(LaunchConfiguration lc) throws EC2Exception {
        int i;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ImageId", lc.getImageId());
        params.put("MinCount", "" + lc.getMinCount());
        params.put("MaxCount", "" + lc.getMaxCount());
        byte[] userData = lc.getUserData();
        if (userData != null && userData.length > 0) {
            params.put("UserData", new String(Base64.encodeBase64((byte[])userData)));
        }
        params.put("AddressingType", "public");
        String keyName = lc.getKeyName();
        if (keyName != null && !keyName.trim().equals("")) {
            params.put("KeyName", keyName);
        }
        if (lc.getSecurityGroup() != null) {
            i = 0;
            while (i < lc.getSecurityGroup().size()) {
                params.put("SecurityGroup." + (i + 1), lc.getSecurityGroup().get(i));
                ++i;
            }
        }
        params.put("InstanceType", lc.getInstanceType().getTypeId());
        if (lc.getAvailabilityZone() != null && !lc.getAvailabilityZone().trim().equals("")) {
            params.put("Placement.AvailabilityZone", lc.getAvailabilityZone());
        }
        if (lc.getKernelId() != null && !lc.getKernelId().trim().equals("")) {
            params.put("KernelId", lc.getKernelId());
        }
        if (lc.getRamdiskId() != null && !lc.getRamdiskId().trim().equals("")) {
            params.put("RamdiskId", lc.getRamdiskId());
        }
        if (lc.getBlockDevicemappings() != null) {
            i = 0;
            while (i < lc.getBlockDevicemappings().size()) {
                BlockDeviceMapping bdm = lc.getBlockDevicemappings().get(i);
                params.put("BlockDeviceMapping." + (i + 1) + ".VirtualName", bdm.getVirtualName());
                params.put("BlockDeviceMapping." + (i + 1) + ".DeviceName", bdm.getDeviceName());
                ++i;
            }
        }
        GetMethod method = new GetMethod();
        try {
            RunInstancesResponse response = this.makeRequest((HttpMethodBase)method, "RunInstances", params, RunInstancesResponse.class);
            ReservationDescription res = new ReservationDescription(response.getOwnerId(), response.getReservationId());
            GroupSetType grp_set = response.getGroupSet();
            for (GroupItemType rsp_item : grp_set.getItems()) {
                res.addGroup(rsp_item.getGroupId());
            }
            RunningInstancesSetType set = response.getInstancesSet();
            for (RunningInstancesItemType rsp_item : set.getItems()) {
                res.addInstance(rsp_item.getImageId(), rsp_item.getInstanceId(), rsp_item.getPrivateDnsName(), rsp_item.getDnsName(), rsp_item.getInstanceState(), rsp_item.getReason(), rsp_item.getKeyName(), rsp_item.getLaunchTime().toGregorianCalendar(), InstanceType.getTypeFromString(rsp_item.getInstanceType()), rsp_item.getPlacement().getAvailabilityZone(), rsp_item.getKernelId(), rsp_item.getRamdiskId());
            }
            ReservationDescription reservationDescription = res;
            return reservationDescription;
        }
        catch (JAXBException ex) {
            throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public List<TerminatingInstanceDescription> terminateInstances(String[] instanceIds) throws EC2Exception {
        return this.terminateInstances(Arrays.asList(instanceIds));
    }

    public List<TerminatingInstanceDescription> terminateInstances(List<String> instanceIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 0;
        while (i < instanceIds.size()) {
            params.put("InstanceId." + (i + 1), instanceIds.get(i));
            ++i;
        }
        GetMethod method = new GetMethod();
        try {
            TerminateInstancesResponse response = this.makeRequest((HttpMethodBase)method, "TerminateInstances", params, TerminateInstancesResponse.class);
            response.getInstancesSet();
            ArrayList<TerminatingInstanceDescription> res = new ArrayList<TerminatingInstanceDescription>();
            TerminateInstancesResponseInfoType set = response.getInstancesSet();
            for (TerminateInstancesResponseItemType rsp_item : set.getItems()) {
                res.add(new TerminatingInstanceDescription(rsp_item.getInstanceId(), rsp_item.getPreviousState().getName(), rsp_item.getPreviousState().getCode(), rsp_item.getShutdownState().getName(), rsp_item.getShutdownState().getCode()));
            }
            ArrayList<TerminatingInstanceDescription> arrayList = res;
            return arrayList;
        }
        catch (JAXBException ex) {
            throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public List<ReservationDescription> describeInstances(String[] instanceIds) throws EC2Exception {
        return this.describeInstances(Arrays.asList(instanceIds));
    }

    public List<ReservationDescription> describeInstances(List<String> instanceIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 0;
        while (i < instanceIds.size()) {
            params.put("InstanceId." + (i + 1), instanceIds.get(i));
            ++i;
        }
        GetMethod method = new GetMethod();
        try {
            DescribeInstancesResponse response = this.makeRequest((HttpMethodBase)method, "DescribeInstances", params, DescribeInstancesResponse.class);
            ArrayList<ReservationDescription> result = new ArrayList<ReservationDescription>();
            ReservationSetType res_set = response.getReservationSet();
            for (RunInstancesResponse item : res_set.getItems()) {
                ReservationDescription res = new ReservationDescription(item.getOwnerId(), item.getReservationId());
                GroupSetType grp_set = item.getGroupSet();
                for (GroupItemType rsp_item : grp_set.getItems()) {
                    res.addGroup(rsp_item.getGroupId());
                }
                RunningInstancesSetType set = item.getInstancesSet();
                for (RunningInstancesItemType rsp_item : set.getItems()) {
                    res.addInstance(rsp_item.getImageId(), rsp_item.getInstanceId(), rsp_item.getPrivateDnsName(), rsp_item.getDnsName(), rsp_item.getInstanceState(), rsp_item.getReason(), rsp_item.getKeyName(), rsp_item.getLaunchTime().toGregorianCalendar(), InstanceType.getTypeFromString(rsp_item.getInstanceType()), rsp_item.getPlacement().getAvailabilityZone(), rsp_item.getKernelId(), rsp_item.getRamdiskId());
                }
                result.add(res);
            }
            ArrayList<ReservationDescription> arrayList = result;
            return arrayList;
        }
        catch (JAXBException ex) {
            throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public void rebootInstances(String[] instanceIds) throws EC2Exception {
        this.rebootInstances(Arrays.asList(instanceIds));
    }

    public void rebootInstances(List<String> instanceIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 0;
        while (i < instanceIds.size()) {
            params.put("InstanceId." + (i + 1), instanceIds.get(i));
            ++i;
        }
        GetMethod method = new GetMethod();
        try {
            try {
                RebootInstancesResponse response = this.makeRequest((HttpMethodBase)method, "RebootInstances", params, RebootInstancesResponse.class);
                if (!response.isReturn()) {
                    throw new EC2Exception("Could not reboot instances. No reason given.");
                }
            }
            catch (JAXBException ex) {
                throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (MalformedURLException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public ConsoleOutput getConsoleOutput(String instanceId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InstanceId", instanceId);
        GetMethod method = new GetMethod();
        try {
            GetConsoleOutputResponse response = this.makeRequest((HttpMethodBase)method, "GetConsoleOutput", params, GetConsoleOutputResponse.class);
            ConsoleOutput consoleOutput = new ConsoleOutput(response.getInstanceId(), response.getTimestamp().toGregorianCalendar(), new String(Base64.decodeBase64((byte[])response.getOutput().getBytes())));
            return consoleOutput;
        }
        catch (JAXBException ex) {
            throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public void createSecurityGroup(String name, String desc) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", name);
        params.put("GroupDescription", desc);
        GetMethod method = new GetMethod();
        try {
            try {
                CreateSecurityGroupResponse response = this.makeRequest((HttpMethodBase)method, "CreateSecurityGroup", params, CreateSecurityGroupResponse.class);
                if (!response.isReturn()) {
                    throw new EC2Exception("Could not create security group : " + name + ". No reason given.");
                }
            }
            catch (JAXBException ex) {
                throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (MalformedURLException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void deleteSecurityGroup(String name) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", name);
        GetMethod method = new GetMethod();
        try {
            try {
                DeleteSecurityGroupResponse response = this.makeRequest((HttpMethodBase)method, "DeleteSecurityGroup", params, DeleteSecurityGroupResponse.class);
                if (!response.isReturn()) {
                    throw new EC2Exception("Could not delete security group : " + name + ". No reason given.");
                }
            }
            catch (JAXBException ex) {
                throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (MalformedURLException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public List<GroupDescription> describeSecurityGroups(String[] groupNames) throws EC2Exception {
        return this.describeSecurityGroups(Arrays.asList(groupNames));
    }

    public List<GroupDescription> describeSecurityGroups(List<String> groupNames) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 0;
        while (i < groupNames.size()) {
            params.put("GroupName." + (i + 1), groupNames.get(i));
            ++i;
        }
        GetMethod method = new GetMethod();
        try {
            DescribeSecurityGroupsResponse response = this.makeRequest((HttpMethodBase)method, "DescribeSecurityGroups", params, DescribeSecurityGroupsResponse.class);
            ArrayList<GroupDescription> result = new ArrayList<GroupDescription>();
            SecurityGroupSetType rsp_set = response.getSecurityGroupInfo();
            for (SecurityGroupItemType item : rsp_set.getItems()) {
                GroupDescription group = new GroupDescription(item.getGroupName(), item.getGroupDescription(), item.getOwnerId());
                IpPermissionSetType perms = item.getIpPermissions();
                for (IpPermissionType perm : perms.getItems()) {
                    GroupDescription.IpPermission group_perms = group.addPermission(perm.getIpProtocol(), perm.getFromPort(), perm.getToPort());
                    for (UserIdGroupPairType uid_group : perm.getGroups().getItems()) {
                        group_perms.addUserGroupPair(uid_group.getUserId(), uid_group.getGroupName());
                    }
                    for (IpRangeItemType range : perm.getIpRanges().getItems()) {
                        group_perms.addIpRange(range.getCidrIp());
                    }
                }
                result.add(group);
            }
            ArrayList<GroupDescription> arrayList = result;
            return arrayList;
        }
        catch (JAXBException ex) {
            throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public void authorizeSecurityGroupIngress(String groupName, String secGroupName, String secGroupOwnerId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", groupName);
        params.put("SourceSecurityGroupOwnerId", secGroupOwnerId);
        params.put("SourceSecurityGroupName", secGroupName);
        GetMethod method = new GetMethod();
        try {
            try {
                AuthorizeSecurityGroupIngressResponse response = this.makeRequest((HttpMethodBase)method, "AuthorizeSecurityGroupIngress", params, AuthorizeSecurityGroupIngressResponse.class);
                if (!response.isReturn()) {
                    throw new EC2Exception("Could not authorize security ingress : " + groupName + ". No reason given.");
                }
            }
            catch (JAXBException ex) {
                throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (MalformedURLException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void authorizeSecurityGroupIngress(String groupName, String ipProtocol, int fromPort, int toPort, String cidrIp) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", groupName);
        params.put("IpProtocol", ipProtocol);
        params.put("FromPort", "" + fromPort);
        params.put("ToPort", "" + toPort);
        params.put("CidrIp", cidrIp);
        GetMethod method = new GetMethod();
        try {
            try {
                AuthorizeSecurityGroupIngressResponse response = this.makeRequest((HttpMethodBase)method, "AuthorizeSecurityGroupIngress", params, AuthorizeSecurityGroupIngressResponse.class);
                if (!response.isReturn()) {
                    throw new EC2Exception("Could not authorize security ingress : " + groupName + ". No reason given.");
                }
            }
            catch (JAXBException ex) {
                throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (MalformedURLException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void revokeSecurityGroupIngress(String groupName, String secGroupName, String secGroupOwnerId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", groupName);
        params.put("SourceSecurityGroupOwnerId", secGroupOwnerId);
        params.put("SourceSecurityGroupName", secGroupName);
        GetMethod method = new GetMethod();
        try {
            try {
                RevokeSecurityGroupIngressResponse response = this.makeRequest((HttpMethodBase)method, "RevokeSecurityGroupIngress", params, RevokeSecurityGroupIngressResponse.class);
                if (!response.isReturn()) {
                    throw new EC2Exception("Could not revoke security ingress : " + groupName + ". No reason given.");
                }
            }
            catch (JAXBException ex) {
                throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (MalformedURLException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void revokeSecurityGroupIngress(String groupName, String ipProtocol, int fromPort, int toPort, String cidrIp) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", groupName);
        params.put("IpProtocol", ipProtocol);
        params.put("FromPort", "" + fromPort);
        params.put("ToPort", "" + toPort);
        params.put("CidrIp", cidrIp);
        GetMethod method = new GetMethod();
        try {
            try {
                RevokeSecurityGroupIngressResponse response = this.makeRequest((HttpMethodBase)method, "RevokeSecurityGroupIngress", params, RevokeSecurityGroupIngressResponse.class);
                if (!response.isReturn()) {
                    throw new EC2Exception("Could not revoke security ingress : " + groupName + ". No reason given.");
                }
            }
            catch (JAXBException ex) {
                throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (MalformedURLException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public KeyPairInfo createKeyPair(String keyName) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("KeyName", keyName);
        GetMethod method = new GetMethod();
        try {
            CreateKeyPairResponse response = this.makeRequest((HttpMethodBase)method, "CreateKeyPair", params, CreateKeyPairResponse.class);
            KeyPairInfo keyPairInfo = new KeyPairInfo(response.getKeyName(), response.getKeyFingerprint(), response.getKeyMaterial());
            return keyPairInfo;
        }
        catch (JAXBException ex) {
            throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public List<KeyPairInfo> describeKeyPairs(String[] keyIds) throws EC2Exception {
        return this.describeKeyPairs(Arrays.asList(keyIds));
    }

    public List<KeyPairInfo> describeKeyPairs(List<String> keyIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 0;
        while (i < keyIds.size()) {
            params.put("KeyName." + (i + 1), keyIds.get(i));
            ++i;
        }
        GetMethod method = new GetMethod();
        try {
            DescribeKeyPairsResponse response = this.makeRequest((HttpMethodBase)method, "DescribeKeyPairs", params, DescribeKeyPairsResponse.class);
            ArrayList<KeyPairInfo> result = new ArrayList<KeyPairInfo>();
            DescribeKeyPairsResponseInfoType set = response.getKeySet();
            for (DescribeKeyPairsResponseItemType item : set.getItems()) {
                result.add(new KeyPairInfo(item.getKeyName(), item.getKeyFingerprint(), null));
            }
            ArrayList<KeyPairInfo> arrayList = result;
            return arrayList;
        }
        catch (JAXBException ex) {
            throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public void deleteKeyPair(String keyName) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("KeyName", keyName);
        GetMethod method = new GetMethod();
        try {
            try {
                DeleteKeyPairResponse response = this.makeRequest((HttpMethodBase)method, "DeleteKeyPair", params, DeleteKeyPairResponse.class);
                if (!response.isReturn()) {
                    throw new EC2Exception("Could not delete keypair : " + keyName + ". No reason given.");
                }
            }
            catch (JAXBException ex) {
                throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (MalformedURLException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void modifyImageAttribute(String imageId, ImageListAttribute attribute, ImageListAttributeOperationType operationType) throws EC2Exception {
        HashMap<String, String> params;
        block21: {
            block20: {
                params = new HashMap<String, String>();
                params.put("ImageId", imageId);
                if (!attribute.getType().equals((Object)ImageAttribute.ImageAttributeType.launchPermission)) break block20;
                params.put("Attribute", "launchPermission");
                switch (operationType) {
                    case add: {
                        params.put("OperationType", "add");
                        break block21;
                    }
                    case remove: {
                        params.put("OperationType", "remove");
                        break block21;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown attribute operation.");
                    }
                }
            }
            if (attribute.getType().equals((Object)ImageAttribute.ImageAttributeType.productCodes)) {
                params.put("Attribute", "productCodes");
            }
        }
        int gNum = 1;
        int iNum = 1;
        int pNum = 1;
        for (ImageListAttributeItem item : attribute.getImageListAttributeItems()) {
            switch (item.getType()) {
                case group: {
                    params.put("UserGroup." + gNum, item.getValue());
                    ++gNum;
                    break;
                }
                case userId: {
                    params.put("UserId." + iNum, item.getValue());
                    ++iNum;
                    break;
                }
                case productCode: {
                    params.put("ProductCode." + pNum, item.getValue());
                    ++pNum;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown item type.");
                }
            }
        }
        GetMethod method = new GetMethod();
        try {
            try {
                ModifyImageAttributeResponse response = this.makeRequest((HttpMethodBase)method, "ModifyImageAttribute", params, ModifyImageAttributeResponse.class);
                if (!response.isReturn()) {
                    throw new EC2Exception("Could not reset image attribute. No reason given.");
                }
            }
            catch (JAXBException ex) {
                throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (MalformedURLException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void resetImageAttribute(String imageId, ImageAttribute.ImageAttributeType imageAttribute) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ImageId", imageId);
        if (imageAttribute.equals((Object)ImageAttribute.ImageAttributeType.launchPermission)) {
            params.put("Attribute", "launchPermission");
        } else if (imageAttribute.equals((Object)ImageAttribute.ImageAttributeType.productCodes)) {
            throw new IllegalArgumentException("Cannot reset productCodes attribute");
        }
        GetMethod method = new GetMethod();
        try {
            try {
                ResetImageAttributeResponse response = this.makeRequest((HttpMethodBase)method, "ResetImageAttribute", params, ResetImageAttributeResponse.class);
                if (!response.isReturn()) {
                    throw new EC2Exception("Could not reset image attribute. No reason given.");
                }
            }
            catch (JAXBException ex) {
                throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (MalformedURLException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public DescribeImageAttributeResult describeImageAttribute(String imageId, ImageAttribute.ImageAttributeType imageAttribute) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ImageId", imageId);
        if (imageAttribute.equals((Object)ImageAttribute.ImageAttributeType.launchPermission)) {
            params.put("Attribute", "launchPermission");
        } else if (imageAttribute.equals((Object)ImageAttribute.ImageAttributeType.productCodes)) {
            params.put("Attribute", "productCodes");
        }
        GetMethod method = new GetMethod();
        try {
            NullableAttributeValueType val;
            Object item;
            ListIterator<Object> i;
            Object list;
            DescribeImageAttributeResponse response = this.makeRequest((HttpMethodBase)method, "DescribeImageAttribute", params, DescribeImageAttributeResponse.class);
            ImageListAttribute attribute = null;
            if (response.getLaunchPermission() != null) {
                list = response.getLaunchPermission();
                attribute = new LaunchPermissionAttribute();
                i = ((LaunchPermissionListType)list).getItems().listIterator();
                while (i.hasNext()) {
                    item = (LaunchPermissionItemType)i.next();
                    if (((LaunchPermissionItemType)item).getGroup() != null) {
                        attribute.addImageListAttributeItem(ImageListAttribute.ImageListAttributeItemType.group, ((LaunchPermissionItemType)item).getGroup());
                        continue;
                    }
                    if (((LaunchPermissionItemType)item).getUserId() == null) continue;
                    attribute.addImageListAttributeItem(ImageListAttribute.ImageListAttributeItemType.userId, ((LaunchPermissionItemType)item).getUserId());
                }
            } else if (response.getProductCodes() != null) {
                list = response.getProductCodes();
                attribute = new ProductCodesAttribute();
                i = ((ProductCodeListType)list).getItems().listIterator();
                while (i.hasNext()) {
                    item = (ProductCodeItemType)i.next();
                    if (((ProductCodeItemType)item).getProductCode() == null) continue;
                    attribute.addImageListAttributeItem(ImageListAttribute.ImageListAttributeItemType.productCode, ((ProductCodeItemType)item).getProductCode());
                }
            }
            ArrayList<String> codes = new ArrayList<String>();
            ProductCodeListType set = response.getProductCodes();
            if (set != null) {
                for (ProductCodeItemType code : set.getItems()) {
                    codes.add(code.getProductCode());
                }
            }
            String kernel = (val = response.getKernel()) != null ? val.getValue() : "";
            val = response.getRamdisk();
            String ramdisk = val != null ? val.getValue() : "";
            ArrayList<BlockDeviceMapping> bdm = new ArrayList<BlockDeviceMapping>();
            BlockDeviceMappingType bdmSet = response.getBlockDeviceMapping();
            if (bdmSet != null) {
                for (BlockDeviceMappingItemType mapping : bdmSet.getItems()) {
                    bdm.add(new BlockDeviceMapping(mapping.getVirtualName(), mapping.getDeviceName()));
                }
            }
            DescribeImageAttributeResult describeImageAttributeResult = new DescribeImageAttributeResult(response.getImageId(), attribute, codes, kernel, ramdisk, bdm);
            return describeImageAttributeResult;
        }
        catch (JAXBException ex) {
            throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public ProductInstanceInfo confirmProductInstance(String instanceId, String productCode) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InstanceId", instanceId);
        params.put("ProductCode", productCode);
        GetMethod method = new GetMethod();
        try {
            ConfirmProductInstanceResponse response = this.makeRequest((HttpMethodBase)method, "ConfirmProductInstance", params, ConfirmProductInstanceResponse.class);
            if (response.isReturn()) {
                ProductInstanceInfo productInstanceInfo = new ProductInstanceInfo(instanceId, productCode, response.getOwnerId());
                return productInstanceInfo;
            }
            return null;
        }
        catch (JAXBException ex) {
            throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public List<AvailabilityZone> describeAvailabilityZones(List<String> zones) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (zones != null && zones.size() > 0) {
            int i = 0;
            while (i < zones.size()) {
                params.put("ZoneName." + (i + 1), zones.get(i));
                ++i;
            }
        }
        GetMethod method = new GetMethod();
        try {
            DescribeAvailabilityZonesResponse response = this.makeRequest((HttpMethodBase)method, "DescribeAvailabilityZones", params, DescribeAvailabilityZonesResponse.class);
            ArrayList<AvailabilityZone> ret = new ArrayList<AvailabilityZone>();
            AvailabilityZoneSetType set = response.getAvailabilityZoneInfo();
            for (AvailabilityZoneItemType item : set.getItems()) {
                ret.add(new AvailabilityZone(item.getZoneName(), item.getZoneState()));
            }
            ArrayList<AvailabilityZone> arrayList = ret;
            return arrayList;
        }
        catch (JAXBException ex) {
            throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public List<AddressInfo> describeAddresses(List<String> addresses) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (addresses != null && addresses.size() > 0) {
            int i = 0;
            while (i < addresses.size()) {
                params.put("PublicIp." + (i + 1), addresses.get(i));
                ++i;
            }
        }
        GetMethod method = new GetMethod();
        try {
            DescribeAddressesResponse response = this.makeRequest((HttpMethodBase)method, "DescribeAddresses", params, DescribeAddressesResponse.class);
            ArrayList<AddressInfo> ret = new ArrayList<AddressInfo>();
            DescribeAddressesResponseInfoType set = response.getAddressesSet();
            for (DescribeAddressesResponseItemType item : set.getItems()) {
                ret.add(new AddressInfo(item.getPublicIp(), item.getInstanceId()));
            }
            ArrayList<AddressInfo> arrayList = ret;
            return arrayList;
        }
        catch (JAXBException ex) {
            throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public String allocateAddress() throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        GetMethod method = new GetMethod();
        try {
            AllocateAddressResponse response = this.makeRequest((HttpMethodBase)method, "AllocateAddress", params, AllocateAddressResponse.class);
            String string = response.getPublicIp();
            return string;
        }
        catch (JAXBException ex) {
            throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public void associateAddress(String instanceId, String publicIp) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InstanceId", instanceId);
        params.put("PublicIp", publicIp);
        GetMethod method = new GetMethod();
        try {
            try {
                AssociateAddressResponse response = this.makeRequest((HttpMethodBase)method, "AssociateAddress", params, AssociateAddressResponse.class);
                if (!response.isReturn()) {
                    throw new EC2Exception("Could not associate address with instance (no reason given).");
                }
            }
            catch (JAXBException ex) {
                throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (MalformedURLException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void disassociateAddress(String publicIp) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PublicIp", publicIp);
        GetMethod method = new GetMethod();
        try {
            try {
                DisassociateAddressResponse response = this.makeRequest((HttpMethodBase)method, "DisassociateAddress", params, DisassociateAddressResponse.class);
                if (!response.isReturn()) {
                    throw new EC2Exception("Could not disassociate address with instance (no reason given).");
                }
            }
            catch (JAXBException ex) {
                throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (MalformedURLException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void releaseAddress(String publicIp) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PublicIp", publicIp);
        GetMethod method = new GetMethod();
        try {
            try {
                ReleaseAddressResponse response = this.makeRequest((HttpMethodBase)method, "ReleaseAddress", params, ReleaseAddressResponse.class);
                if (!response.isReturn()) {
                    throw new EC2Exception("Could not release address (no reason given).");
                }
            }
            catch (JAXBException ex) {
                throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (MalformedURLException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new EC2Exception(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageListAttributeOperationType {
        add,
        remove;

    }
}

