/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sdb;

import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.sdb.ItemAttribute;
import com.xerox.amazonws.sdb.SDBException;
import com.xerox.amazonws.sdb.SimpleDB;
import com.xerox.amazonws.typica.sdb.jaxb.Attribute;
import com.xerox.amazonws.typica.sdb.jaxb.DeleteAttributesResponse;
import com.xerox.amazonws.typica.sdb.jaxb.GetAttributesResponse;
import com.xerox.amazonws.typica.sdb.jaxb.PutAttributesResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Item
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(Item.class);
    private String domainName;
    private String identifier;

    protected Item(String identifier, String domainName, String awsAccessId, String awsSecretKey, boolean isSecure, String server) throws SDBException {
        super(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
        this.domainName = domainName;
        this.identifier = identifier;
        SimpleDB.setVersionHeader(this);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<ItemAttribute> getAttributes() throws SDBException {
        return this.getAttributes(null);
    }

    public List<ItemAttribute> getAttributes(String attributeName) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", this.identifier);
        if (attributeName != null) {
            params.put("AttributeName", attributeName);
        }
        GetMethod method = new GetMethod();
        try {
            GetAttributesResponse response = this.makeRequest((HttpMethodBase)method, "GetAttributes", params, GetAttributesResponse.class);
            ArrayList<ItemAttribute> ret = new ArrayList<ItemAttribute>();
            List<Attribute> attrs = response.getGetAttributesResult().getAttributes();
            for (Attribute attr : attrs) {
                ret.add(new ItemAttribute(attr.getName(), attr.getValue(), false));
            }
            ArrayList<ItemAttribute> arrayList = ret;
            return arrayList;
        }
        catch (JAXBException ex) {
            throw new SDBException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new SDBException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SDBException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public void putAttributes(List<ItemAttribute> attributes) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", this.identifier);
        int i = 1;
        for (ItemAttribute attr : attributes) {
            String val = attr.getValue();
            if (val == null) continue;
            params.put("Attribute." + i + ".Name", attr.getName());
            params.put("Attribute." + i + ".Value", val);
            if (attr.isReplace()) {
                params.put("Attribute." + i + ".Replace", "true");
            }
            ++i;
        }
        GetMethod method = new GetMethod();
        try {
            try {
                this.makeRequest((HttpMethodBase)method, "PutAttributes", params, PutAttributesResponse.class);
            }
            catch (JAXBException ex) {
                throw new SDBException("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (HttpException ex) {
                throw new SDBException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new SDBException(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void deleteAttributes(List<ItemAttribute> attributes) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", this.identifier);
        if (attributes != null) {
            int i = 1;
            for (ItemAttribute attr : attributes) {
                params.put("Attribute." + i + ".Name", attr.getName());
                String value = attr.getValue();
                if (value != null) {
                    params.put("Attribute." + i + ".Value", value);
                }
                ++i;
            }
        }
        GetMethod method = new GetMethod();
        try {
            try {
                this.makeRequest((HttpMethodBase)method, "DeleteAttributes", params, DeleteAttributesResponse.class);
            }
            catch (JAXBException ex) {
                throw new SDBException("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (HttpException ex) {
                throw new SDBException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new SDBException(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    static List<Item> createList(String[] itemNames, String domainName, String awsAccessId, String awsSecretKey, boolean isSecure, String server, int signatureVersion, HttpClient hc) throws SDBException {
        ArrayList<Item> ret = new ArrayList<Item>();
        int i = 0;
        while (i < itemNames.length) {
            Item item = new Item(itemNames[i], domainName, awsAccessId, awsSecretKey, isSecure, server);
            item.setSignatureVersion(signatureVersion);
            item.setHttpClient(hc);
            ret.add(item);
            ++i;
        }
        return ret;
    }
}

