/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sqs;

import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.sqs.CanonicalUser;
import com.xerox.amazonws.sqs.Grant;
import com.xerox.amazonws.sqs.Grantee;
import com.xerox.amazonws.sqs.Group;
import com.xerox.amazonws.sqs.Message;
import com.xerox.amazonws.sqs.QueueAttribute;
import com.xerox.amazonws.sqs.QueueService;
import com.xerox.amazonws.sqs.SQSException;
import com.xerox.amazonws.typica.jaxb.AddGrantResponse;
import com.xerox.amazonws.typica.jaxb.AttributedValue;
import com.xerox.amazonws.typica.jaxb.ChangeMessageVisibilityResponse;
import com.xerox.amazonws.typica.jaxb.DeleteMessageResponse;
import com.xerox.amazonws.typica.jaxb.DeleteQueueResponse;
import com.xerox.amazonws.typica.jaxb.GetQueueAttributesResponse;
import com.xerox.amazonws.typica.jaxb.ListGrantsResponse;
import com.xerox.amazonws.typica.jaxb.PeekMessageResponse;
import com.xerox.amazonws.typica.jaxb.ReceiveMessageResponse;
import com.xerox.amazonws.typica.jaxb.RemoveGrantResponse;
import com.xerox.amazonws.typica.jaxb.SendMessageResponse;
import com.xerox.amazonws.typica.jaxb.SetQueueAttributesResponse;
import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageQueue
extends AWSQueryConnection {
    public static final int MAX_MESSAGES = 600;
    public static final int MAX_MESSAGE_BODIES_SIZE = 4096;
    protected String queueId;
    private boolean enableEncoding = true;

    protected MessageQueue(String queueUrl, String awsAccessId, String awsSecretKey, boolean isSecure, String server) throws SQSException {
        super(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
        this.queueId = queueUrl.startsWith("http") ? queueUrl.substring(queueUrl.indexOf("//") + 2) : queueUrl;
        this.queueId = this.queueId.substring(this.queueId.indexOf("/") + 1);
        QueueService.setVersionHeader(this);
    }

    @Override
    public URL getUrl() {
        try {
            return new URL(super.getUrl().toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public boolean isEncoding() {
        return this.enableEncoding;
    }

    public void setEncoding(boolean enable) {
        this.enableEncoding = enable;
    }

    public String sendMessage(String msg) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        String encodedMsg = this.enableEncoding ? new String(Base64.encodeBase64((byte[])msg.getBytes())) : msg;
        PostMethod method = new PostMethod();
        try {
            method.setRequestEntity((RequestEntity)new StringRequestEntity(encodedMsg, "text/plain", null));
            SendMessageResponse response = this.makeRequest((HttpMethodBase)method, "SendMessage", params, SendMessageResponse.class);
            String string = response.getMessageId();
            return string;
        }
        catch (JAXBException ex) {
            throw new SQSException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SQSException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public Message receiveMessage() throws SQSException {
        Message[] amessage = this.receiveMessages(BigInteger.valueOf(1L), null);
        if (amessage.length > 0) {
            return amessage[0];
        }
        return null;
    }

    public Message receiveMessage(int visibilityTimeout) throws SQSException {
        Message[] amessage = this.receiveMessages(BigInteger.valueOf(1L), BigInteger.valueOf(visibilityTimeout));
        if (amessage.length > 0) {
            return amessage[0];
        }
        return null;
    }

    public Message[] receiveMessages(int numMessages) throws SQSException {
        return this.receiveMessages(BigInteger.valueOf(numMessages), null);
    }

    public Message[] receiveMessages(int numMessages, int visibilityTimeout) throws SQSException {
        return this.receiveMessages(BigInteger.valueOf(numMessages), BigInteger.valueOf(visibilityTimeout));
    }

    protected Message[] receiveMessages(BigInteger numMessages, BigInteger visibilityTimeout) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (numMessages != null) {
            params.put("NumberOfMessages", numMessages.toString());
        }
        if (visibilityTimeout != null) {
            params.put("VisibilityTimeout", visibilityTimeout.toString());
        }
        GetMethod method = new GetMethod();
        try {
            ReceiveMessageResponse response = this.makeRequest((HttpMethodBase)method, "ReceiveMessage", params, ReceiveMessageResponse.class);
            if (response.getMessages() == null) {
                Message[] messageArray = new Message[]{};
                return messageArray;
            }
            ArrayList<Message> msgs = new ArrayList<Message>();
            for (com.xerox.amazonws.typica.jaxb.Message msg : response.getMessages()) {
                String decodedMsg = this.enableEncoding ? new String(Base64.decodeBase64((byte[])msg.getMessageBody().getBytes())) : msg.getMessageBody();
                msgs.add(new Message(msg.getMessageId(), decodedMsg));
            }
            Message[] messageArray = msgs.toArray(new Message[msgs.size()]);
            return messageArray;
        }
        catch (JAXBException ex) {
            throw new SQSException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SQSException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public Message peekMessage(String msgId) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("MessageId", msgId);
        GetMethod method = new GetMethod();
        try {
            PeekMessageResponse response = this.makeRequest((HttpMethodBase)method, "PeekMessage", params, PeekMessageResponse.class);
            com.xerox.amazonws.typica.jaxb.Message msg = response.getMessage();
            if (msg == null) {
                return null;
            }
            String decodedMsg = this.enableEncoding ? new String(Base64.decodeBase64((byte[])msg.getMessageBody().getBytes())) : msg.getMessageBody();
            Message message = new Message(msg.getMessageId(), decodedMsg);
            return message;
        }
        catch (JAXBException ex) {
            throw new SQSException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SQSException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public void deleteMessage(Message msg) throws SQSException {
        this.deleteMessage(msg.getMessageId());
    }

    public void deleteMessage(String msgId) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("MessageId", msgId);
        GetMethod method = new GetMethod();
        try {
            try {
                this.makeRequest((HttpMethodBase)method, "DeleteMessage", params, DeleteMessageResponse.class);
            }
            catch (JAXBException ex) {
                throw new SQSException("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (HttpException ex) {
                throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new SQSException(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void deleteQueue() throws SQSException {
        this.deleteQueue(false);
    }

    public void deleteQueue(boolean force) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (force) {
            params.put("ForceDeletion", "true");
        }
        GetMethod method = new GetMethod();
        try {
            try {
                this.makeRequest((HttpMethodBase)method, "DeleteQueue", params, DeleteQueueResponse.class);
            }
            catch (JAXBException ex) {
                throw new SQSException("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (HttpException ex) {
                throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new SQSException(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void setVisibilityTimeout(Message msg, int timeout) throws SQSException {
        this.setVisibilityTimeout(msg.getMessageId(), timeout);
    }

    public void setVisibilityTimeout(String msgId, int timeout) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("MessageId", msgId);
        params.put("VisibilityTimeout", "" + timeout);
        GetMethod method = new GetMethod();
        try {
            try {
                this.makeRequest((HttpMethodBase)method, "ChangeMessageVisibility", params, ChangeMessageVisibilityResponse.class);
            }
            catch (JAXBException ex) {
                throw new SQSException("Problem setting the visibility timeout.", (Exception)((Object)ex));
            }
            catch (HttpException ex) {
                throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new SQSException(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void setVisibilityTimeout(String[] msgIds, int timeout) throws SQSException {
        String[] stringArray = msgIds;
        int n = msgIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.setVisibilityTimeout(id, timeout);
            ++n2;
        }
    }

    public int getVisibilityTimeout() throws SQSException {
        return Integer.parseInt(this.getQueueAttributes(QueueAttribute.VISIBILITY_TIMEOUT).values().iterator().next());
    }

    public int getApproximateNumberOfMessages() throws SQSException {
        return Integer.parseInt(this.getQueueAttributes(QueueAttribute.APPROXIMATE_NUMBER_OF_MESSAGES).values().iterator().next());
    }

    public Map<String, String> getQueueAttributes(QueueAttribute qAttr) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Attribute", qAttr.queryAttribute());
        GetMethod method = new GetMethod();
        try {
            GetQueueAttributesResponse response = this.makeRequest((HttpMethodBase)method, "GetQueueAttributes", params, GetQueueAttributesResponse.class);
            HashMap<String, String> ret = new HashMap<String, String>();
            List<AttributedValue> attrs = response.getAttributedValues();
            for (AttributedValue attr : attrs) {
                ret.put(attr.getAttribute(), attr.getValue());
            }
            HashMap<String, String> hashMap = ret;
            return hashMap;
        }
        catch (JAXBException ex) {
            throw new SQSException("Problem getting the visilibity timeout.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SQSException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public void setVisibilityTimeout(int timeout) throws SQSException {
        this.setQueueAttribute("VisibilityTimeout", "" + timeout);
    }

    public void setQueueAttribute(String attribute, String value) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Attribute", attribute);
        params.put("Value", value);
        GetMethod method = new GetMethod();
        try {
            try {
                this.makeRequest((HttpMethodBase)method, "SetQueueAttributes", params, SetQueueAttributesResponse.class);
            }
            catch (JAXBException ex) {
                throw new SQSException("Problem setting the visibility timeout.", (Exception)((Object)ex));
            }
            catch (HttpException ex) {
                throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new SQSException(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void addGrantByEmailAddress(String eMailAddress, String permission) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (permission != null && !permission.trim().equals("")) {
            params.put("Permission", permission);
        }
        params.put("Grantee.EmailAddress", eMailAddress);
        this.addGrant(params);
    }

    public void addGrantByCustomerId(String id, String displayName, String permission) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (permission != null && !permission.trim().equals("")) {
            params.put("Permission", permission);
        }
        params.put("Grantee.ID", id);
        this.addGrant(params);
    }

    private void addGrant(Map<String, String> params) throws SQSException {
        GetMethod method = new GetMethod();
        try {
            try {
                this.makeRequest((HttpMethodBase)method, "AddGrant", params, AddGrantResponse.class);
            }
            catch (JAXBException ex) {
                throw new SQSException("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (HttpException ex) {
                throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new SQSException(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void removeGrantByEmailAddress(String eMailAddress, String permission) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (permission != null && !permission.trim().equals("")) {
            params.put("Permission", permission);
        }
        params.put("Grantee.EmailAddress", eMailAddress);
        this.removeGrant(params);
    }

    public void removeGrantByCustomerId(String id, String permission) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (permission != null && !permission.trim().equals("")) {
            params.put("Permission", permission);
        }
        params.put("Grantee.ID", id);
        this.removeGrant(params);
    }

    private void removeGrant(Map<String, String> params) throws SQSException {
        GetMethod method = new GetMethod();
        try {
            try {
                this.makeRequest((HttpMethodBase)method, "RemoveGrant", params, RemoveGrantResponse.class);
            }
            catch (JAXBException ex) {
                throw new SQSException("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (HttpException ex) {
                throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new SQSException(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public Grant[] listGrants(Grantee grantee, String permission) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (permission != null && !permission.trim().equals("")) {
            params.put("Permission", permission);
        }
        if (grantee instanceof CanonicalUser) {
            params.put("Grantee.ID", ((CanonicalUser)grantee).getID());
        }
        GetMethod method = new GetMethod();
        try {
            ListGrantsResponse response = this.makeRequest((HttpMethodBase)method, "ListGrants", params, ListGrantsResponse.class);
            Grant[] grants = new Grant[response.getGrantLists().size()];
            int i = 0;
            for (com.xerox.amazonws.typica.jaxb.Grant g : response.getGrantLists()) {
                Grantee g2 = null;
                if (g.getGrantee() instanceof com.xerox.amazonws.typica.jaxb.Group) {
                    com.xerox.amazonws.typica.jaxb.Group grp = (com.xerox.amazonws.typica.jaxb.Group)g.getGrantee();
                    g2 = new Group(new URI(grp.getURI()));
                } else if (g.getGrantee() instanceof com.xerox.amazonws.typica.jaxb.CanonicalUser) {
                    com.xerox.amazonws.typica.jaxb.CanonicalUser u = (com.xerox.amazonws.typica.jaxb.CanonicalUser)g.getGrantee();
                    g2 = new CanonicalUser(u.getID(), u.getDisplayName());
                }
                grants[i] = new Grant(g2, g.getPermission());
                ++i;
            }
            Grant[] grantArray = grants;
            return grantArray;
        }
        catch (JAXBException ex) {
            throw new SQSException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SQSException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    protected URL makeURL(String resource) throws MalformedURLException {
        return super.makeURL(String.valueOf(this.queueId) + resource);
    }

    public static List<MessageQueue> createList(String[] queueUrls, String awsAccesseyId, String awsSecretKey, boolean isSecure, String server, HttpClient hc) throws SQSException {
        ArrayList<MessageQueue> ret = new ArrayList<MessageQueue>();
        int i = 0;
        while (i < queueUrls.length) {
            MessageQueue mq = new MessageQueue(queueUrls[i], awsAccesseyId, awsSecretKey, isSecure, server);
            mq.setHttpClient(hc);
            ret.add(mq);
            ++i;
        }
        return ret;
    }
}

