/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sqs2;

import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.sqs2.Message;
import com.xerox.amazonws.sqs2.QueueAttribute;
import com.xerox.amazonws.sqs2.QueueService;
import com.xerox.amazonws.sqs2.SQSException;
import com.xerox.amazonws.typica.sqs2.jaxb.Attribute;
import com.xerox.amazonws.typica.sqs2.jaxb.DeleteMessageResponse;
import com.xerox.amazonws.typica.sqs2.jaxb.DeleteQueueResponse;
import com.xerox.amazonws.typica.sqs2.jaxb.GetQueueAttributesResponse;
import com.xerox.amazonws.typica.sqs2.jaxb.ReceiveMessageResponse;
import com.xerox.amazonws.typica.sqs2.jaxb.SendMessageResponse;
import com.xerox.amazonws.typica.sqs2.jaxb.SetQueueAttributesResponse;
import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageQueue
extends AWSQueryConnection {
    public static final int MAX_MESSAGES = 600;
    public static final int MAX_MESSAGE_BODIES_SIZE = 4096;
    protected String queueId;
    private boolean enableEncoding = true;

    protected MessageQueue(String queueUrl, String awsAccessId, String awsSecretKey, boolean isSecure, String server) throws SQSException {
        super(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
        this.queueId = queueUrl.startsWith("http") ? queueUrl.substring(queueUrl.indexOf("//") + 2) : queueUrl;
        this.queueId = this.queueId.substring(this.queueId.indexOf("/") + 1);
        QueueService.setVersionHeader(this);
    }

    @Override
    public URL getUrl() {
        try {
            return new URL(super.getUrl().toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public boolean isEncoding() {
        return this.enableEncoding;
    }

    public void setEncoding(boolean enable) {
        this.enableEncoding = enable;
    }

    public String sendMessage(String msg) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        String encodedMsg = this.enableEncoding ? new String(Base64.encodeBase64((byte[])msg.getBytes())) : msg;
        params.put("MessageBody", encodedMsg);
        PostMethod method = new PostMethod();
        try {
            SendMessageResponse response = this.makeRequest((HttpMethodBase)method, "SendMessage", params, SendMessageResponse.class);
            String string = response.getSendMessageResult().getMessageId();
            return string;
        }
        catch (JAXBException ex) {
            throw new SQSException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SQSException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public Message receiveMessage() throws SQSException {
        Message[] amessage = this.receiveMessages(BigInteger.valueOf(1L), null);
        if (amessage.length > 0) {
            return amessage[0];
        }
        return null;
    }

    public Message receiveMessage(int visibilityTimeout) throws SQSException {
        Message[] amessage = this.receiveMessages(BigInteger.valueOf(1L), BigInteger.valueOf(visibilityTimeout));
        if (amessage.length > 0) {
            return amessage[0];
        }
        return null;
    }

    public Message[] receiveMessages(int numMessages) throws SQSException {
        return this.receiveMessages(BigInteger.valueOf(numMessages), null);
    }

    public Message[] receiveMessages(int numMessages, int visibilityTimeout) throws SQSException {
        return this.receiveMessages(BigInteger.valueOf(numMessages), BigInteger.valueOf(visibilityTimeout));
    }

    protected Message[] receiveMessages(BigInteger numMessages, BigInteger visibilityTimeout) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (numMessages != null) {
            params.put("MaxNumberOfMessages", numMessages.toString());
        }
        if (visibilityTimeout != null) {
            params.put("VisibilityTimeout", visibilityTimeout.toString());
        }
        GetMethod method = new GetMethod();
        try {
            ReceiveMessageResponse response = this.makeRequest((HttpMethodBase)method, "ReceiveMessage", params, ReceiveMessageResponse.class);
            if (response.getReceiveMessageResult().getMessages() == null) {
                Message[] messageArray = new Message[]{};
                return messageArray;
            }
            ArrayList<Message> msgs = new ArrayList<Message>();
            for (com.xerox.amazonws.typica.sqs2.jaxb.Message msg : response.getReceiveMessageResult().getMessages()) {
                String decodedMsg = this.enableEncoding ? new String(Base64.decodeBase64((byte[])msg.getBody().getBytes())) : msg.getBody();
                msgs.add(new Message(msg.getMessageId(), msg.getReceiptHandle(), decodedMsg, msg.getMD5OfBody()));
            }
            Message[] messageArray = msgs.toArray(new Message[msgs.size()]);
            return messageArray;
        }
        catch (JAXBException ex) {
            throw new SQSException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SQSException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public void deleteMessage(Message msg) throws SQSException {
        this.deleteMessage(msg.getReceiptHandle());
    }

    public void deleteMessage(String receiptHandle) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ReceiptHandle", receiptHandle);
        GetMethod method = new GetMethod();
        try {
            try {
                this.makeRequest((HttpMethodBase)method, "DeleteMessage", params, DeleteMessageResponse.class);
            }
            catch (JAXBException ex) {
                throw new SQSException("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (HttpException ex) {
                throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new SQSException(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public void deleteQueue() throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        GetMethod method = new GetMethod();
        try {
            try {
                this.makeRequest((HttpMethodBase)method, "DeleteQueue", params, DeleteQueueResponse.class);
            }
            catch (JAXBException ex) {
                throw new SQSException("Problem parsing returned message.", (Exception)((Object)ex));
            }
            catch (HttpException ex) {
                throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new SQSException(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public int getVisibilityTimeout() throws SQSException {
        return Integer.parseInt(this.getQueueAttributes(QueueAttribute.VISIBILITY_TIMEOUT).values().iterator().next());
    }

    public int getApproximateNumberOfMessages() throws SQSException {
        return Integer.parseInt(this.getQueueAttributes(QueueAttribute.APPROXIMATE_NUMBER_OF_MESSAGES).values().iterator().next());
    }

    public Map<String, String> getQueueAttributes(QueueAttribute qAttr) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("AttributeName", qAttr.queryAttribute());
        GetMethod method = new GetMethod();
        try {
            GetQueueAttributesResponse response = this.makeRequest((HttpMethodBase)method, "GetQueueAttributes", params, GetQueueAttributesResponse.class);
            HashMap<String, String> ret = new HashMap<String, String>();
            List<Attribute> attrs = response.getGetQueueAttributesResult().getAttributes();
            for (Attribute attr : attrs) {
                ret.put(attr.getName(), attr.getValue());
            }
            HashMap<String, String> hashMap = ret;
            return hashMap;
        }
        catch (JAXBException ex) {
            throw new SQSException("Problem getting the visilibity timeout.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SQSException(ex.getMessage(), ex);
        }
        finally {
            method.releaseConnection();
        }
    }

    public void setVisibilityTimeout(int timeout) throws SQSException {
        this.setQueueAttribute("VisibilityTimeout", "" + timeout);
    }

    public void setQueueAttribute(String attribute, String value) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Attribute.Name", attribute);
        params.put("Attribute.Value", value);
        GetMethod method = new GetMethod();
        try {
            try {
                this.makeRequest((HttpMethodBase)method, "SetQueueAttributes", params, SetQueueAttributesResponse.class);
            }
            catch (JAXBException ex) {
                throw new SQSException("Problem setting the visibility timeout.", (Exception)((Object)ex));
            }
            catch (HttpException ex) {
                throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new SQSException(ex.getMessage(), ex);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    protected URL makeURL(String resource) throws MalformedURLException {
        return super.makeURL(String.valueOf(this.queueId) + resource);
    }

    public static List<MessageQueue> createList(String[] queueUrls, String awsAccessId, String awsSecretKey, boolean isSecure, String server, HttpClient hc) throws SQSException {
        ArrayList<MessageQueue> ret = new ArrayList<MessageQueue>();
        int i = 0;
        while (i < queueUrls.length) {
            MessageQueue mq = new MessageQueue(queueUrls[i], awsAccessId, awsSecretKey, isSecure, server);
            mq.setHttpClient(hc);
            ret.add(mq);
            ++i;
        }
        return ret;
    }
}

