/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.actions;

import eu.geclipse.aws.ec2.EC2Instance;
import eu.geclipse.aws.ec2.ui.actions.AbstractAWSProjectAction;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.ui.actions.MountAction;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class CreateConnectionInstance
extends AbstractAWSProjectAction {
    private ArrayList<EC2Instance> instanceList = new ArrayList();

    public void run(IAction action) {
        if (action.isEnabled()) {
            Job job = new Job("Mount a Grid connection to the instance"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (CreateConnectionInstance.this.instanceList.size() == 0) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        for (EC2Instance instance : CreateConnectionInstance.this.instanceList) {
                            String hostname = instance.getHostName();
                            instance.getProject();
                            IPath path = instance.getProject().getPath().append("Connections").append(hostname);
                            try {
                                URI uri = new URI("sftp", "root", hostname, 22, "/", null, null);
                                MountAction.createLocalMount((URI)uri, (IPath)path, (IProgressMonitor)monitor);
                                System.out.println("URI: " + uri);
                            }
                            catch (URISyntaxException e) {
                                Activator.log(e);
                            }
                            catch (CoreException e) {
                                Activator.log((Exception)((Object)e));
                            }
                        }
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            job.setPriority(20);
            job.setUser(true);
            job.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable = false;
        this.instanceList.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection.toList()) {
                if (!(element instanceof EC2Instance)) continue;
                EC2Instance ec2Instance = (EC2Instance)element;
                this.instanceList.add(ec2Instance);
            }
        }
        if (this.instanceList.size() > 0) {
            enable = true;
        }
        action.setEnabled(enable);
    }
}

