/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.actions;

import eu.geclipse.aws.ec2.EC2ProblemException;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.EC2SecurityGroup;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpDeleteSecurityGroup;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.op.OperationSet;
import eu.geclipse.aws.ec2.service.EC2Service;
import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.actions.AbstractSecurityGroupAction;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DeleteSecurityGroup
extends AbstractSecurityGroupAction {
    public void run(IAction action) {
        if (action.isEnabled()) {
            List<EC2SecurityGroup> securityGroupList = this.getSecurityGroupList();
            StringBuffer strBuf = new StringBuffer();
            String dash = "- ";
            String newLine = "\n";
            for (EC2SecurityGroup securityGroup : securityGroupList) {
                strBuf.append(String.valueOf(dash) + securityGroup.getName() + newLine);
            }
            Shell shell = this.getWorkbenchPart().getSite().getShell();
            boolean confirmation = MessageDialog.openConfirm((Shell)shell, (String)Messages.getString("DeleteSecurityGroup.dialog_title_delete_security_group"), (String)(String.valueOf(Messages.getString("DeleteSecurityGroup.dialog_description_delete_security_group")) + newLine + newLine + strBuf.toString()));
            if (confirmation) {
                this.deleteSecurityGroup();
            }
        }
    }

    private void deleteSecurityGroup() {
        Job job = new Job(Messages.getString("DeleteSecurityGroup.job_title")){

            protected IStatus run(IProgressMonitor monitor) {
                List<EC2SecurityGroup> securityGroupList = DeleteSecurityGroup.this.getSecurityGroupList();
                monitor.beginTask(Messages.getString("DeleteSecurityGroup.task_title_delete_security_group"), securityGroupList.size());
                EC2Service ec2Service = securityGroupList.get(0).getEC2Service();
                AWSVirtualOrganization awsVo = (AWSVirtualOrganization)ec2Service.getParent();
                String awsAccessId = null;
                try {
                    awsAccessId = awsVo.getProperties().getAwsAccessId();
                }
                catch (ProblemException problemEx) {
                    Activator.log("Could not read aws vo properties", (Exception)((Object)problemEx));
                }
                OperationSet operationSet = new OperationSet();
                IEC2 ec2 = EC2Registry.getRegistry().getEC2(awsAccessId);
                for (EC2SecurityGroup securityGroup : securityGroupList) {
                    EC2OpDeleteSecurityGroup opDeleteSecurityGroup = new EC2OpDeleteSecurityGroup(ec2, securityGroup.getName());
                    operationSet.addOp((IOperation)opDeleteSecurityGroup);
                }
                new OperationExecuter().execOpGroup(operationSet);
                for (IOperation op : operationSet.getOps()) {
                    if (op.getException() == null) continue;
                    Exception cause = op.getException();
                    final EC2ProblemException exception = new EC2ProblemException("eu.geclipse.aws.ec2.problem.net.ec2", cause.getCause().getLocalizedMessage(), (Throwable)cause, "eu.geclipse.aws.ec2.ui");
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    display.asyncExec(new Runnable(){

                        public void run() {
                            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            ProblemDialog.openProblem((Shell)workbenchWindow.getShell(), (String)Messages.getString("DeleteSecurityGroup.problem_title"), (String)Messages.getString("DeleteSecurityGroup.problem_description"), (Throwable)exception);
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setUser(true);
        job.schedule();
    }

    protected int getEnablementCount() {
        return AbstractSecurityGroupAction.ENABLE_FOR_MANY;
    }
}

