/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.properties;

import com.xerox.amazonws.ec2.AddressInfo;
import eu.geclipse.aws.ec2.EC2ElasticIPAddress;
import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.properties.SimpleProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IProperty;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElasticIPPropertySource
extends AbstractPropertySource<Object> {
    private EC2ElasticIPAddress ec2ElasticIPAddress;
    private List<IProperty<Object>> propertiesList;

    public ElasticIPPropertySource(EC2ElasticIPAddress sourceObject) {
        super((Object)sourceObject);
        this.ec2ElasticIPAddress = sourceObject;
    }

    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return ((Object)((Object)this)).getClass();
    }

    protected List<IProperty<Object>> getStaticProperties() {
        if (this.propertiesList == null) {
            this.propertiesList = this.getProperties();
        }
        return this.propertiesList;
    }

    private List<IProperty<Object>> getProperties() {
        ArrayList<IProperty<Object>> propertyList = new ArrayList<IProperty<Object>>();
        AddressInfo addressInfo = this.ec2ElasticIPAddress.getAddressInfo();
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("ElasticIPPropertySource.property_ipAddress"), addressInfo.getPublicIp()));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("ElasticIPPropertySource.property_instanceId"), addressInfo.getInstanceId()));
        return propertyList;
    }
}

