/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.wizards;

import com.xerox.amazonws.ec2.ImageListAttribute;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.LaunchPermissionAttribute;
import eu.geclipse.aws.ec2.EC2AMIImage;
import eu.geclipse.aws.ec2.EC2ProblemException;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpModifyImageAttribute;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.ec2.ui.wizards.AddAttributeWizardPage;
import eu.geclipse.aws.ec2.ui.wizards.Messages;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AddAttributeWizard
extends Wizard {
    private AddAttributeWizardPage wizardPage;
    private AWSVirtualOrganization awsVo;
    private EC2AMIImage ec2AmiImage;

    public AddAttributeWizard(AWSVirtualOrganization awsVo, EC2AMIImage image) {
        this.awsVo = awsVo;
        this.ec2AmiImage = image;
    }

    public void addPages() {
        this.wizardPage = new AddAttributeWizardPage();
        this.addPage((IWizardPage)this.wizardPage);
        this.setNeedsProgressMonitor(true);
    }

    public String getWindowTitle() {
        return Messages.getString("AddAttributeWizard.wizard_title");
    }

    public boolean performFinish() {
        if (this.wizardPage.isPageComplete()) {
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            IEC2 ec2;
                            monitor.beginTask(Messages.getString("AddAttributeWizard.task_adding_permission"), 2);
                            EC2Registry registry = EC2Registry.getRegistry();
                            try {
                                ec2 = registry.getEC2(AddAttributeWizard.this.awsVo);
                            }
                            catch (ProblemException problemEx) {
                                throw new InvocationTargetException(problemEx);
                            }
                            monitor.worked(1);
                            LaunchPermissionAttribute attribute = new LaunchPermissionAttribute();
                            attribute.addImageListAttributeItem(ImageListAttribute.ImageListAttributeItemType.userId, AddAttributeWizard.this.wizardPage.getAWSAccountId());
                            EC2OpModifyImageAttribute op = new EC2OpModifyImageAttribute(ec2, AddAttributeWizard.this.ec2AmiImage.getImageId(), (ImageListAttribute)attribute, Jec2.ImageListAttributeOperationType.add);
                            new OperationExecuter().execOp((IOperation)op);
                            if (op.getException() != null) {
                                throw new InvocationTargetException(op.getException());
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (Exception ex) {
                Activator.log("An problem occured while adding permissions", ex);
                final EC2ProblemException exception = new EC2ProblemException("eu.geclipse.aws.ec2.problem.net.ec2", ex.getCause().getLocalizedMessage(), (Throwable)ex, "eu.geclipse.aws.ec2.ui");
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        ProblemDialog.openProblem((Shell)workbenchWindow.getShell(), (String)Messages.getString("AddAttributeWizard.problem_granting_access_permission_title"), (String)Messages.getString("AddAttributeWizard.problem_granting_access_permission_description"), (Throwable)exception);
                    }
                });
                return false;
            }
            return true;
        }
        return false;
    }
}

