/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.wizards;

import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.ec2.ui.wizards.Messages;
import eu.geclipse.aws.util.AWSUtil;
import eu.geclipse.ui.widgets.StoredCombo;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AddAttributeWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "eu.geclipse.aws.ec2.ui.wizards.addAttributeWizardPage";
    private StoredCombo storedComboAWSAccountId;

    protected AddAttributeWizardPage() {
        super(WIZARD_PAGE_ID, Messages.getString("AddAttributeWizardPage.wizard_page_title"), null);
        this.setDescription(Messages.getString("AddAttributeWizardPage.wizard_page_description"));
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/service_wiz.gif");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComp.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(mainComp, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(Messages.getString("AddAttributeWizardPage.label_aws_account_id"));
        this.storedComboAWSAccountId = new StoredCombo(mainComp, 18436);
        this.storedComboAWSAccountId.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.storedComboAWSAccountId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddAttributeWizardPage.this.validateInput();
            }
        });
        this.setControl((Control)mainComp);
    }

    protected void validateInput() {
        String error = null;
        String transformedAccountNumber = AWSUtil.transformAWSAccountNumber((String)this.storedComboAWSAccountId.getText());
        if (transformedAccountNumber == null) {
            error = Messages.getString("AddAttributeWizardPage.error_valid_aws_account_id_required");
        }
        if (error == null) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(error);
            this.setPageComplete(false);
        }
    }

    public String getAWSAccountId() {
        return AWSUtil.transformAWSAccountNumber((String)this.storedComboAWSAccountId.getText());
    }
}

