/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.wizards;

import eu.geclipse.aws.ec2.EC2Instance;
import eu.geclipse.aws.ec2.EC2ProblemException;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpAssociateAddress;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.ec2.ui.wizards.Messages;
import eu.geclipse.aws.ec2.ui.wizards.SelectElasticIPWizardPage;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AssociateElasticIPWizard
extends Wizard {
    private EC2Instance ec2Instance;
    private AWSVirtualOrganization awsVo;
    private SelectElasticIPWizardPage selectElasticIPWizardPage;

    public AssociateElasticIPWizard(AWSVirtualOrganization awsVo, EC2Instance instance) {
        this.awsVo = awsVo;
        this.ec2Instance = instance;
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.selectElasticIPWizardPage = new SelectElasticIPWizardPage(this.awsVo, this.ec2Instance);
        this.addPage((IWizardPage)this.selectElasticIPWizardPage);
    }

    public String getWindowTitle() {
        return Messages.getString("AssociateElasticIPWizard.wizard_title");
    }

    public boolean performFinish() {
        if (this.selectElasticIPWizardPage.isPageComplete()) {
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            IEC2 ec2;
                            monitor.beginTask(MessageFormat.format(Messages.getString("AssociateElasticIPWizard.monitor_title"), AssociateElasticIPWizard.this.ec2Instance.getInstanceId(), AssociateElasticIPWizard.this.selectElasticIPWizardPage.getSelectedElasticIP()), 2);
                            EC2Registry registry = EC2Registry.getRegistry();
                            try {
                                ec2 = registry.getEC2(AssociateElasticIPWizard.this.awsVo);
                            }
                            catch (ProblemException problemEx) {
                                throw new InvocationTargetException(problemEx);
                            }
                            monitor.worked(1);
                            EC2OpAssociateAddress op = new EC2OpAssociateAddress(ec2, AssociateElasticIPWizard.this.selectElasticIPWizardPage.getSelectedElasticIP(), AssociateElasticIPWizard.this.ec2Instance.getInstanceId());
                            new OperationExecuter().execOp((IOperation)op);
                            if (op.getException() != null) {
                                throw new InvocationTargetException(op.getException());
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (Exception ex) {
                Activator.log("An problem occured while associating the Elastic IP", ex);
                final EC2ProblemException exception = new EC2ProblemException("eu.geclipse.aws.ec2.problem.net.ec2", ex.getCause().getLocalizedMessage(), (Throwable)ex, "eu.geclipse.aws.ec2.ui");
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        ProblemDialog.openProblem((Shell)workbenchWindow.getShell(), (String)Messages.getString("AssociateElasticIPWizard.problem_title"), (String)Messages.getString("AssociateElasticIPWizard.problem_description"), (Throwable)exception);
                    }
                });
                return false;
            }
            return true;
        }
        return false;
    }
}

