/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.wizards;

import com.xerox.amazonws.ec2.GroupDescription;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.ec2.ui.wizards.Messages;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CIDRPermissionWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "eu.geclipse.aws.ec2.ui.wizard.cidrPermission";
    private static final String[] protocols = new String[]{"tcp", "udp", "icmp"};
    private Pattern patternCidr = Pattern.compile("[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}/[0-9]{1,2}");
    private Text textCidr;
    private Combo comboProtocol;
    private Text textFromPort;
    private Text textToPort;

    public CIDRPermissionWizardPage(GroupDescription securityGroup) {
        super(WIZARD_PAGE_ID, String.valueOf(Messages.getString("CIDRPermissionWizardPage.page_title")) + securityGroup.getName(), null);
        this.setDescription(String.valueOf(Messages.getString("CIDRPermissionWizardPage.page_description")) + securityGroup.getName());
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/security_wiz.gif");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        GridData gData = new GridData(4, 4, true, true);
        mainComp.setLayoutData((Object)gData);
        GridLayout gridLayout = new GridLayout(4, false);
        mainComp.setLayout((Layout)gridLayout);
        Label labelCidr = new Label(mainComp, 0);
        labelCidr.setText(Messages.getString("CIDRPermissionWizardPage.label_cidr"));
        this.textCidr = new Text(mainComp, 2048);
        this.textCidr.setText("0.0.0.0/0");
        this.textCidr.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CIDRPermissionWizardPage.this.validateForm();
            }
        });
        gData = new GridData(4, 0x1000000, true, false);
        gData.horizontalSpan = 3;
        this.textCidr.setLayoutData((Object)gData);
        Label labelProtocol = new Label(mainComp, 0);
        labelProtocol.setText(Messages.getString("CIDRPermissionWizardPage.label_protcol"));
        this.comboProtocol = new Combo(mainComp, 2056);
        String[] stringArray = protocols;
        int n = protocols.length;
        int n2 = 0;
        while (n2 < n) {
            String protocol = stringArray[n2];
            this.comboProtocol.add(protocol);
            ++n2;
        }
        this.comboProtocol.select(0);
        gData = new GridData(4, 0x1000000, true, false);
        gData.horizontalSpan = 3;
        this.comboProtocol.setLayoutData((Object)gData);
        Label labelFromPort = new Label(mainComp, 0);
        labelFromPort.setText(Messages.getString("CIDRPermissionWizardPage.label_from_port"));
        this.textFromPort = new Text(mainComp, 2048);
        this.textFromPort.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textFromPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CIDRPermissionWizardPage.this.validateForm();
            }
        });
        Label labelToPort = new Label(mainComp, 0);
        labelToPort.setText(Messages.getString("CIDRPermissionWizardPage.label_to_port"));
        this.textToPort = new Text(mainComp, 2048);
        this.textToPort.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textToPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CIDRPermissionWizardPage.this.validateForm();
            }
        });
        this.setControl((Control)parent);
    }

    private void validateForm() {
        String error = null;
        Matcher m = this.patternCidr.matcher(this.textCidr.getText().trim());
        if (!m.matches()) {
            error = Messages.getString("CIDRPermissionWizardPage.error_not_valid_cidr");
        }
        if (error == null) {
            String fromPort = this.textFromPort.getText();
            try {
                Integer.parseInt(fromPort);
            }
            catch (NumberFormatException numberFormatException) {
                error = Messages.getString("CIDRPermissionWizardPage.error_from_port_not_valid");
            }
        }
        if (error == null) {
            String toPort = this.textToPort.getText();
            try {
                Integer.parseInt(toPort);
            }
            catch (NumberFormatException numberFormatException) {
                error = Messages.getString("CIDRPermissionWizardPage.error_to_port_not_valid");
            }
        }
        if (error == null) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(error);
            this.setPageComplete(false);
        }
    }

    public String getCidr() {
        return this.textCidr.getText().trim();
    }

    public String getProtocol() {
        return protocols[this.comboProtocol.getSelectionIndex()];
    }

    public int getFromPort() {
        return Integer.parseInt(this.textFromPort.getText().trim());
    }

    public int getToPort() {
        return Integer.parseInt(this.textToPort.getText().trim());
    }
}

