/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.wizards;

import com.xerox.amazonws.ec2.GroupDescription;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.EC2SecurityGroup;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpDescribeSecurityGroups;
import eu.geclipse.aws.ec2.op.EC2OpRevokeSecurityGroup;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.service.EC2Service;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.ec2.ui.wizards.CIDRPermissionWizard;
import eu.geclipse.aws.ec2.ui.wizards.GroupPermissionWizard;
import eu.geclipse.aws.ec2.ui.wizards.Messages;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.reporting.ProblemException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SecurityGroupWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "eu.geclipse.aws.ec2.ui.wizard.securityGroup";
    private EC2SecurityGroup securityGroup;
    private Table permTable;

    public SecurityGroupWizardPage(EC2SecurityGroup securityGroup) {
        super(WIZARD_PAGE_ID, String.valueOf(Messages.getString("SecurityGroupWizardPage.page_title")) + securityGroup.getName(), null);
        this.setDescription(Messages.getString("SecurityGroupWizardPage.page_description"));
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/security_wiz.gif");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
        this.securityGroup = securityGroup;
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        GridData gData = new GridData(4, 4, true, true);
        mainComp.setLayoutData((Object)gData);
        GridLayout gridLayout = new GridLayout(2, false);
        mainComp.setLayout((Layout)gridLayout);
        this.permTable = new Table(mainComp, 68356);
        this.permTable.setHeaderVisible(true);
        this.permTable.setLinesVisible(true);
        gData = new GridData(4, 4, true, true);
        this.permTable.setLayoutData((Object)gData);
        TableColumn tableColumnProtocol = new TableColumn(this.permTable, 16384);
        tableColumnProtocol.setText(Messages.getString("SecurityGroupWizardPage.tab_label_protcol"));
        tableColumnProtocol.setWidth(80);
        TableColumn tableColumnFrom = new TableColumn(this.permTable, 16384);
        tableColumnFrom.setText(Messages.getString("SecurityGroupWizardPage.tab_label_from"));
        tableColumnFrom.setWidth(60);
        TableColumn tableColumnTo = new TableColumn(this.permTable, 16384);
        tableColumnTo.setText(Messages.getString("SecurityGroupWizardPage.tab_label_to"));
        tableColumnTo.setWidth(60);
        TableColumn tableColumnSource = new TableColumn(this.permTable, 16384);
        tableColumnSource.setText(Messages.getString("SecurityGroupWizardPage.tab_label_source"));
        tableColumnSource.setWidth(130);
        Composite buttonComp = new Composite(mainComp, 0);
        gData = new GridData(4, 4, false, true);
        buttonComp.setLayoutData((Object)gData);
        gridLayout = new GridLayout(1, true);
        buttonComp.setLayout((Layout)gridLayout);
        Button addCidrButton = new Button(buttonComp, 0);
        addCidrButton.setText(Messages.getString("SecurityGroupWizardPage.button_add_cidr"));
        addCidrButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        addCidrButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GroupDescription groupDescription = SecurityGroupWizardPage.this.securityGroup.getGroupDescription();
                EC2Service ec2Service = SecurityGroupWizardPage.this.securityGroup.getEC2Service();
                AWSVirtualOrganization awsVo = (AWSVirtualOrganization)ec2Service.getParent();
                String awsAccessId = null;
                try {
                    awsAccessId = awsVo.getProperties().getAwsAccessId();
                }
                catch (ProblemException problemEx) {
                    Activator.log("Could not read aws vo properties", (Exception)((Object)problemEx));
                }
                CIDRPermissionWizard cidrWizard = new CIDRPermissionWizard(groupDescription, awsAccessId);
                WizardDialog wizardDialog = new WizardDialog(SecurityGroupWizardPage.this.getShell(), (IWizard)cidrWizard);
                int wizardStatus = wizardDialog.open();
                if (wizardStatus == 0) {
                    SecurityGroupWizardPage.this.refreshPermissionsTable();
                }
            }
        });
        Button addGroupButton = new Button(buttonComp, 0);
        addGroupButton.setText(Messages.getString("SecurityGroupWizardPage.button_add_group"));
        addGroupButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        addGroupButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GroupDescription groupDescription = SecurityGroupWizardPage.this.securityGroup.getGroupDescription();
                EC2Service ec2Service = SecurityGroupWizardPage.this.securityGroup.getEC2Service();
                AWSVirtualOrganization awsVo = (AWSVirtualOrganization)ec2Service.getParent();
                String awsAccessId = null;
                try {
                    awsAccessId = awsVo.getProperties().getAwsAccessId();
                }
                catch (ProblemException problemEx) {
                    Activator.log("Could not read aws vo properties", (Exception)((Object)problemEx));
                }
                GroupPermissionWizard groupPermWizard = new GroupPermissionWizard(groupDescription, awsAccessId);
                WizardDialog wizardDialog = new WizardDialog(SecurityGroupWizardPage.this.getShell(), (IWizard)groupPermWizard);
                int wizardStatus = wizardDialog.open();
                if (wizardStatus == 0) {
                    SecurityGroupWizardPage.this.refreshPermissionsTable();
                }
            }
        });
        Button deleteButton = new Button(buttonComp, 0);
        deleteButton.setText(Messages.getString("SecurityGroupWizardPage.button_delete"));
        deleteButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SecurityGroupWizardPage.this.deleteSelectedPermission();
            }
        });
        gData = new GridData(4, 0x1000000, true, false);
        gData.verticalIndent = 10;
        deleteButton.setLayoutData((Object)gData);
        Link refreshLink = new Link(mainComp, 0);
        refreshLink.setText(Messages.getString("SecurityGroupWizardPage.link_refresh_permissions"));
        refreshLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SecurityGroupWizardPage.this.refreshPermissionsTable();
            }
        });
        gData = new GridData(16384, 0x1000000, true, false);
        refreshLink.setLayoutData((Object)gData);
        this.refreshPermissionsTable();
        this.setControl((Control)mainComp);
    }

    protected void deleteSelectedPermission() {
        TableItem[] tableSelection = this.permTable.getSelection();
        if (tableSelection.length > 0) {
            final GroupDescription.IpPermission ipPermission = (GroupDescription.IpPermission)tableSelection[0].getData();
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        String groupName = SecurityGroupWizardPage.this.securityGroup.getGroupDescription().getName();
                        monitor.beginTask(String.valueOf(Messages.getString("SecurityGroupWizardPage.task_remove_permissions")) + groupName, 2);
                        try {
                            String awsAccessId = SecurityGroupWizardPage.this.getAwsAccessId(SecurityGroupWizardPage.this.securityGroup);
                            IEC2 ec2 = EC2Registry.getRegistry().getEC2(awsAccessId);
                            if (ipPermission.getUidGroupPairs().size() > 0) {
                                List uidGroupPairs = ipPermission.getUidGroupPairs();
                                String[] uid = (String[])uidGroupPairs.get(0);
                                EC2OpRevokeSecurityGroup opRevoke = new EC2OpRevokeSecurityGroup(ec2, SecurityGroupWizardPage.this.securityGroup.getGroupDescription().getName(), uid[1], uid[0]);
                                new OperationExecuter().execOp((IOperation)opRevoke);
                            } else {
                                EC2OpRevokeSecurityGroup opRevoke = new EC2OpRevokeSecurityGroup(ec2, SecurityGroupWizardPage.this.securityGroup.getGroupDescription().getName(), (String)ipPermission.getIpRanges().get(0), ipPermission.getProtocol(), ipPermission.getFromPort(), ipPermission.getToPort());
                                new OperationExecuter().execOp((IOperation)opRevoke);
                            }
                            monitor.worked(1);
                            SecurityGroupWizardPage.this.refreshPermissionsTable();
                            monitor.worked(2);
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException invTargetEx) {
                Activator.log("An problem occured while revoking security group access", invTargetEx);
            }
            catch (InterruptedException interruptedEx) {
                Activator.log("The thread was interrupted while revoking security group access", interruptedEx);
            }
        }
    }

    private String getAwsAccessId(EC2SecurityGroup securityGroup) {
        EC2Service ec2Service = securityGroup.getEC2Service();
        AWSVirtualOrganization awsVo = (AWSVirtualOrganization)ec2Service.getParent();
        String awsAccessId = null;
        try {
            awsAccessId = awsVo.getProperties().getAwsAccessId();
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not obtain aws vo properties", (Exception)((Object)problemEx));
        }
        return awsAccessId;
    }

    protected void refreshPermissionsTable() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    GroupDescription groupDescription = SecurityGroupWizardPage.this.securityGroup.getGroupDescription();
                    monitor.beginTask(String.valueOf(Messages.getString("SecurityGroupWizardPage.task_fetch_group_permissions")) + groupDescription.getName(), 2);
                    try {
                        String awsAccessId = null;
                        awsAccessId = SecurityGroupWizardPage.this.getAwsAccessId(SecurityGroupWizardPage.this.securityGroup);
                        IEC2 ec2 = null;
                        ec2 = EC2Registry.getRegistry().getEC2(awsAccessId);
                        ArrayList<String> securityGroups = new ArrayList<String>();
                        securityGroups.add(groupDescription.getName());
                        EC2OpDescribeSecurityGroups opDescribeSecurityGroups = new EC2OpDescribeSecurityGroups(ec2, securityGroups);
                        new OperationExecuter().execOp((IOperation)opDescribeSecurityGroups);
                        monitor.worked(1);
                        List secGrpList = opDescribeSecurityGroups.getResult();
                        GroupDescription updatedGroupDescription = (GroupDescription)secGrpList.get(0);
                        IGridContainer parent = SecurityGroupWizardPage.this.securityGroup.getParent();
                        EC2Service ec2Service = SecurityGroupWizardPage.this.securityGroup.getEC2Service();
                        SecurityGroupWizardPage.this.securityGroup = new EC2SecurityGroup(parent, ec2Service, updatedGroupDescription);
                        SecurityGroupWizardPage.this.updatePermTable();
                        monitor.worked(2);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException invTargetEx) {
            Activator.log("An problem occured while reading security group access", invTargetEx);
        }
        catch (InterruptedException interruptedEx) {
            Activator.log("The thread was interrupted while reading security group access", interruptedEx);
        }
    }

    private void updatePermTable() {
        this.permTable.removeAll();
        if (this.securityGroup.getGroupDescription() != null) {
            List permissions = this.securityGroup.getGroupDescription().getPermissions();
            for (GroupDescription.IpPermission ipPerm : permissions) {
                TableItem tableItem = new TableItem(this.permTable, 0);
                tableItem.setData((Object)ipPerm);
                String source = "";
                List ipRanges = ipPerm.getIpRanges();
                Iterator iterator = ipRanges.iterator();
                while (iterator.hasNext()) {
                    source = String.valueOf(source) + (String)iterator.next();
                    if (!iterator.hasNext()) continue;
                    source = String.valueOf(source) + ", ";
                }
                List uidGroupPairs = ipPerm.getUidGroupPairs();
                Iterator iterator2 = uidGroupPairs.iterator();
                while (iterator2.hasNext()) {
                    String[] uidGroupPair = (String[])iterator2.next();
                    source = String.valueOf(source) + uidGroupPair[0] + ":" + uidGroupPair[1];
                    if (!iterator2.hasNext()) continue;
                    source = String.valueOf(source) + ", ";
                }
                String[] ColumnValues = new String[]{ipPerm.getProtocol(), String.valueOf(ipPerm.getFromPort()), String.valueOf(ipPerm.getToPort()), source};
                tableItem.setText(ColumnValues);
            }
        }
    }
}

