/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2;

import eu.geclipse.aws.ec2.internal.Activator;
import eu.geclipse.aws.ec2.service.EC2Service;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridResource;
import eu.geclipse.core.model.impl.AbstractGridElement;
import eu.geclipse.core.reporting.ProblemException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public abstract class AbstractEC2GridResource
extends AbstractGridElement
implements IGridResource {
    private IGridContainer parent;
    private EC2Service ec2Service;

    public AbstractEC2GridResource(IGridContainer parent, EC2Service ec2Service) {
        this.parent = parent;
        this.ec2Service = ec2Service;
    }

    public EC2Service getEC2Service() {
        return this.ec2Service;
    }

    public String getHostName() {
        try {
            String ec2Url = this.ec2Service.getProperties().getEc2Url();
            URL url = new URL(ec2Url);
            return url.getHost();
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not obtain properties from ec2Service", (Exception)((Object)problemEx));
        }
        catch (MalformedURLException malformedURLEx) {
            Activator.log("Could not convert URL from ec2Service", malformedURLEx);
        }
        return null;
    }

    public URI getURI() {
        String ec2Url = null;
        try {
            ec2Url = this.ec2Service.getProperties().getEc2Url();
            return new URI(ec2Url);
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not obtain properties from awsVo", (Exception)((Object)problemEx));
        }
        catch (URISyntaxException uriSyntaxEx) {
            Activator.log("Could not construct URI from awsVo: " + ec2Url, uriSyntaxEx);
        }
        return null;
    }

    public IFileStore getFileStore() {
        return null;
    }

    public IGridContainer getParent() {
        return this.parent;
    }

    public IPath getPath() {
        return null;
    }

    public IResource getResource() {
        return null;
    }

    public boolean isLocal() {
        return false;
    }
}

