/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2;

import com.xerox.amazonws.ec2.AddressInfo;
import com.xerox.amazonws.ec2.AvailabilityZone;
import com.xerox.amazonws.ec2.DescribeImageAttributeResult;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.GroupDescription;
import com.xerox.amazonws.ec2.ImageAttribute;
import com.xerox.amazonws.ec2.ImageDescription;
import com.xerox.amazonws.ec2.ImageListAttribute;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.LaunchConfiguration;
import com.xerox.amazonws.ec2.ReservationDescription;
import com.xerox.amazonws.ec2.TerminatingInstanceDescription;
import eu.geclipse.aws.auth.AWSAuthTokenDescription;
import eu.geclipse.aws.ec2.EC2ServiceException;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.internal.Activator;
import eu.geclipse.aws.ec2.internal.Messages;
import eu.geclipse.aws.ec2.op.AMILaunchConfiguration;
import eu.geclipse.aws.ec2.service.EC2Service;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.auth.AbstractAuthTokenProvider;
import eu.geclipse.core.auth.AuthTokenRequest;
import eu.geclipse.core.auth.IAuthenticationToken;
import eu.geclipse.core.auth.IAuthenticationTokenDescription;
import eu.geclipse.core.reporting.ProblemException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.osgi.framework.Bundle;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2
implements IEC2,
IProxyChangeListener {
    private static final String HTTPS_PROTOCOL = "https";
    private Jec2 jec2;
    private String ec2Url;
    private ServiceTracker tracker;
    private String awsAccessId;
    private AWSVirtualOrganization awsVo;

    EC2(String awsAccessId) {
        this.awsAccessId = awsAccessId;
        Bundle bundle = Activator.getDefault().getBundle();
        this.tracker = new ServiceTracker(bundle.getBundleContext(), IProxyService.class.getName(), null);
        this.tracker.open();
        this.getProxyService().addProxyChangeListener((IProxyChangeListener)this);
        this.updateProxySettings();
    }

    public EC2(AWSVirtualOrganization awsVo) throws ProblemException {
        this(awsVo.getProperties().getAwsAccessId());
        this.awsVo = awsVo;
        this.awsAccessId = awsVo.getProperties().getAwsAccessId();
    }

    @Override
    public boolean initEc2(String ec2Url, String awsAccessId, String awsSecretId) throws EC2ServiceException {
        int port;
        URL url;
        if (ec2Url == null || awsAccessId == null || awsSecretId == null) {
            this.ec2Url = null;
            this.jec2 = null;
            throw new EC2ServiceException("Missing required initialization parameter");
        }
        this.ec2Url = ec2Url;
        try {
            url = new URL(ec2Url);
        }
        catch (MalformedURLException e) {
            throw new EC2ServiceException("Could not validate ec2 url", e);
        }
        String host = url.getHost();
        boolean secure = false;
        if (url.getProtocol().equals(HTTPS_PROTOCOL)) {
            secure = true;
        }
        if ((port = url.getPort()) == -1) {
            port = secure ? 443 : 80;
        }
        this.jec2 = new Jec2(awsAccessId, awsSecretId, secure, host, port);
        this.updateProxySettings();
        return true;
    }

    private IProxyService getProxyService() {
        return (IProxyService)this.tracker.getService();
    }

    public void proxyInfoChanged(IProxyChangeEvent event) {
        this.updateProxySettings();
    }

    private void updateProxySettings() {
        if (this.jec2 == null) {
            return;
        }
        IProxyService proxyService = (IProxyService)this.tracker.getService();
        boolean enabled = proxyService.isProxiesEnabled();
        if (enabled) {
            IProxyData proxyData = proxyService.getProxyData("HTTP");
            String host = proxyData.getHost();
            int port = proxyData.getPort();
            String userName = proxyData.getUserId();
            String userPassword = proxyData.getPassword();
            this.jec2.setProxyValues(host, port, userName, userPassword);
        } else {
            this.jec2.setProxyValues(null, 0, null, null, null);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.jec2 != null;
    }

    @Override
    public boolean ensureAuthentication() throws EC2ServiceException {
        IAuthenticationToken authToken;
        AWSAuthTokenDescription authTokenDescription = new AWSAuthTokenDescription(this.awsAccessId);
        authTokenDescription.setAwsVo(this.awsVo);
        AuthTokenRequest request = new AuthTokenRequest((IAuthenticationTokenDescription)authTokenDescription, Messages.getString("EC2.dialog_auth_confirmation_title"), Messages.getString("EC2.dialog_auth_confirmation_description"));
        try {
            authToken = AbstractAuthTokenProvider.staticRequestToken((AuthTokenRequest)request);
        }
        catch (ProblemException pExc) {
            throw new EC2ServiceException("No valid authentication token could be created (might be user canceled).", pExc);
        }
        if (authToken == null) {
            throw new EC2ServiceException("No valid authentication token could be created (might be user canceled).");
        }
        AWSAuthTokenDescription awsDesc = (AWSAuthTokenDescription)authToken.getDescription();
        String ec2Url = null;
        try {
            List ec2ServiceList = awsDesc.getAwsVo().getChildren((IProgressMonitor)new NullProgressMonitor(), EC2Service.class);
            EC2Service ec2Service = null;
            if (ec2ServiceList != null) {
                ec2Service = (EC2Service)((Object)ec2ServiceList.get(0));
            }
            if (ec2Service != null) {
                ec2Url = ec2Service.getProperties().getEc2Url();
            }
        }
        catch (ProblemException problemEx) {
            throw new EC2ServiceException("Could not get ec2url from awsVo via ec2Service", problemEx);
        }
        return this.initEc2(ec2Url, awsDesc.getAwsAccessId(), awsDesc.getAwsSecretId());
    }

    private <T> List<T> nullCheck(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    @Override
    public List<ImageDescription> describeImagesByOwner(List<String> ownerList) throws EC2ServiceException {
        this.ensureAuthentication();
        ownerList = this.nullCheck(ownerList);
        try {
            return this.jec2.describeImagesByOwner(ownerList);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("describeImagesByOwner", ec2Ex);
        }
    }

    @Override
    public List<ImageDescription> describeImagesByExec(List<String> execList) throws EC2ServiceException {
        this.ensureAuthentication();
        execList = this.nullCheck(execList);
        try {
            return this.jec2.describeImagesByExecutability(execList);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("describeImagesByExecutability", ec2Ex);
        }
    }

    @Override
    public ReservationDescription runInstances(AMILaunchConfiguration launchConfig) throws EC2ServiceException {
        this.ensureAuthentication();
        LaunchConfiguration lc = new LaunchConfiguration(launchConfig.getAmiId());
        lc.setMinCount(launchConfig.getMinCount());
        lc.setMaxCount(launchConfig.getMaxCount());
        lc.setSecurityGroup(launchConfig.getSecurityGroup());
        lc.setUserData(launchConfig.getUserData());
        lc.setKeyName(launchConfig.getKeyName());
        lc.setInstanceType(launchConfig.getInstanceType());
        lc.setAvailabilityZone(launchConfig.getZone());
        lc.setRamdiskId(launchConfig.getRamdiskId());
        lc.setKernelId(launchConfig.getKernelId());
        lc.setBlockDevicemappings(launchConfig.getBlockDeviceMappings());
        try {
            return this.jec2.runInstances(lc);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("runInstances", ec2Ex);
        }
    }

    @Override
    public List<GroupDescription> describeSecurityGroups(List<String> securityGroups) throws EC2ServiceException {
        this.ensureAuthentication();
        securityGroups = this.nullCheck(securityGroups);
        try {
            return this.jec2.describeSecurityGroups(securityGroups);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("describeSecurityGroups", ec2Ex);
        }
    }

    @Override
    public List<AvailabilityZone> describeAvailabilityZones(List<String> zones) throws EC2ServiceException {
        this.ensureAuthentication();
        zones = this.nullCheck(zones);
        try {
            return this.jec2.describeAvailabilityZones(zones);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("describeAvailabilityZones", ec2Ex);
        }
    }

    @Override
    public List<KeyPairInfo> describeKeypairs(List<String> keypairs) throws EC2ServiceException {
        this.ensureAuthentication();
        keypairs = this.nullCheck(keypairs);
        try {
            return this.jec2.describeKeyPairs(keypairs);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("describeKeyPairs", ec2Ex);
        }
    }

    @Override
    public List<ReservationDescription> describeInstances(List<String> instanceList) throws EC2ServiceException {
        this.ensureAuthentication();
        instanceList = this.nullCheck(instanceList);
        try {
            return this.jec2.describeInstances(instanceList);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("describeInstances", ec2Ex);
        }
    }

    @Override
    public List<TerminatingInstanceDescription> terminateInstances(List<String> instanceList) throws EC2ServiceException {
        this.ensureAuthentication();
        instanceList = this.nullCheck(instanceList);
        try {
            return this.jec2.terminateInstances(instanceList);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("terminateInstances", ec2Ex);
        }
    }

    @Override
    public void authorizeSecurityGroup(String groupName, String cidrIp, String ipProtocol, int fromPort, int toPort) throws EC2ServiceException {
        this.ensureAuthentication();
        try {
            this.jec2.authorizeSecurityGroupIngress(groupName, ipProtocol, fromPort, toPort, cidrIp);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("authorizeSecurityGroupIngress", ec2Ex);
        }
    }

    @Override
    public void authorizeSecurityGroup(String groupName, String secGroupName, String secGroupOwnerId) throws EC2ServiceException {
        this.ensureAuthentication();
        try {
            this.jec2.authorizeSecurityGroupIngress(groupName, secGroupName, secGroupOwnerId);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("authorizeSecurityGroupIngress", ec2Ex);
        }
    }

    @Override
    public void revokeSecurityGroup(String groupName, String cidrIp, String ipProtocol, int fromPort, int toPort) throws EC2ServiceException {
        this.ensureAuthentication();
        try {
            this.jec2.revokeSecurityGroupIngress(groupName, ipProtocol, fromPort, toPort, cidrIp);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("revokeSecurityGroupIngress", ec2Ex);
        }
    }

    @Override
    public void revokeSecurityGroup(String groupName, String secGroupName, String secGroupOwnerId) throws EC2ServiceException {
        this.ensureAuthentication();
        try {
            this.jec2.revokeSecurityGroupIngress(groupName, secGroupName, secGroupOwnerId);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("revokeSecurityGroupIngress", ec2Ex);
        }
    }

    @Override
    public void deleteSecurityGroup(String securityGroup) throws EC2ServiceException {
        this.ensureAuthentication();
        try {
            this.jec2.deleteSecurityGroup(securityGroup);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("deleteSecurityGroup", ec2Ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof EC2) {
            EC2 ec2 = (EC2)obj;
            if (ec2.awsAccessId.equals(this.awsAccessId)) {
                return true;
            }
        }
        return false;
    }

    private EC2ServiceException getEC2ServiceException(String origine, EC2Exception ec2Ex) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Could not '");
        stringBuilder.append(origine);
        stringBuilder.append("' for ");
        stringBuilder.append(this.awsAccessId);
        stringBuilder.append(" @ ");
        stringBuilder.append(this.ec2Url);
        Activator.log(stringBuilder.toString(), (Exception)((Object)ec2Ex));
        return new EC2ServiceException(stringBuilder.toString(), ec2Ex);
    }

    @Override
    public void createSecurityGroup(String securityGroupName, String securityGroupDescription) throws EC2ServiceException {
        this.ensureAuthentication();
        try {
            this.jec2.createSecurityGroup(securityGroupName, securityGroupDescription);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("createSecurityGroup", ec2Ex);
        }
    }

    @Override
    public KeyPairInfo createKeypair(String keypairName) throws EC2ServiceException {
        this.ensureAuthentication();
        try {
            return this.jec2.createKeyPair(keypairName);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("createKeypair", ec2Ex);
        }
    }

    @Override
    public String allocateAddress() throws EC2ServiceException {
        this.ensureAuthentication();
        try {
            return this.jec2.allocateAddress();
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("allocateAddress", ec2Ex);
        }
    }

    @Override
    public List<AddressInfo> describeAddresses(List<String> addresses) throws EC2ServiceException {
        this.ensureAuthentication();
        try {
            return this.jec2.describeAddresses(addresses);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("describeAddresses", ec2Ex);
        }
    }

    @Override
    public void associateAddress(String instanceId, String elasticIP) throws EC2ServiceException {
        this.ensureAuthentication();
        try {
            this.jec2.associateAddress(instanceId, elasticIP);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("associateAddress", ec2Ex);
        }
    }

    @Override
    public void disassociateAddress(String elasticIP) throws EC2ServiceException {
        this.ensureAuthentication();
        try {
            this.jec2.disassociateAddress(elasticIP);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("disassociateAddress", ec2Ex);
        }
    }

    @Override
    public void releaseAddress(String elasticIP) throws EC2ServiceException {
        this.ensureAuthentication();
        try {
            this.jec2.releaseAddress(elasticIP);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("releaseAddress", ec2Ex);
        }
    }

    @Override
    public void rebootInstances(List<String> instances) throws EC2ServiceException {
        this.ensureAuthentication();
        try {
            this.jec2.rebootInstances(instances);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("rebootInstances", ec2Ex);
        }
    }

    @Override
    public String registerImage(String bucketPath) throws EC2ServiceException {
        this.ensureAuthentication();
        try {
            return this.jec2.registerImage(bucketPath);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("registerImage", ec2Ex);
        }
    }

    @Override
    public DescribeImageAttributeResult describeImageAttributes(String imageId, ImageAttribute.ImageAttributeType imageAttribute) throws EC2ServiceException {
        this.ensureAuthentication();
        try {
            return this.jec2.describeImageAttribute(imageId, imageAttribute);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("describeImageAttribute", ec2Ex);
        }
    }

    @Override
    public void modifyImageAttribute(String imageId, ImageListAttribute attribute, Jec2.ImageListAttributeOperationType operationType) throws EC2ServiceException {
        this.ensureAuthentication();
        try {
            this.jec2.modifyImageAttribute(imageId, attribute, operationType);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("modifyImageAttribute", ec2Ex);
        }
    }

    @Override
    public void deleteKeypair(String keypair) throws EC2ServiceException {
        this.ensureAuthentication();
        try {
            this.jec2.deleteKeyPair(keypair);
        }
        catch (EC2Exception ec2Ex) {
            throw this.getEC2ServiceException("deleteKeypair", ec2Ex);
        }
    }
}

