/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.launch;

import com.xerox.amazonws.ec2.InstanceType;
import eu.geclipse.aws.ec2.EC2ProblemException;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.internal.Activator;
import eu.geclipse.aws.ec2.internal.Messages;
import eu.geclipse.aws.ec2.op.AMILaunchConfiguration;
import eu.geclipse.aws.ec2.op.EC2OpRunInstances;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridResourceCategory;
import eu.geclipse.core.model.IVoManager;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.core.reporting.ProblemException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;

public class EC2LaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public static final String LAUNCH_CONFIGURATION_TYPE = "eu.geclipse.aws.ec2.launch.ec2LaunchConfigurationType";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String identifier = configuration.getType().getIdentifier();
        if (identifier.equals(LAUNCH_CONFIGURATION_TYPE)) {
            AMILaunchConfiguration launchConfig = this.getLaunchConfiguration(configuration);
            monitor.beginTask(String.valueOf(Messages.getString("EC2LaunchConfigurationDelegate.monitor_description_start_ami")) + " " + launchConfig.getAmiId(), -1);
            String emptyString = new String();
            String awsAccessId = configuration.getAttribute("awsAccessId", emptyString);
            IEC2 ec2 = EC2Registry.getRegistry().getEC2(awsAccessId);
            try {
                try {
                    EC2OpRunInstances opRunInstances = new EC2OpRunInstances(ec2, launchConfig);
                    new OperationExecuter().execOp(opRunInstances);
                    if (opRunInstances.getException() != null) {
                        throw opRunInstances.getException();
                    }
                    this.refreshComputingCategory(awsAccessId);
                }
                catch (Exception ex) {
                    Throwable cause = ex.getCause();
                    EC2ProblemException exception = new EC2ProblemException("eu.geclipse.aws.ec2.problem.net.ec2", cause.getLocalizedMessage(), cause, "eu.geclipse.aws.ec2");
                    Activator.log((Exception)((Object)exception));
                    throw exception;
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private void refreshComputingCategory(String awsAccessId) throws ProblemException {
        IGridElement[] children;
        IVoManager voManager = GridModel.getVoManager();
        IGridElement[] iGridElementArray = children = voManager.getChildren((IProgressMonitor)new NullProgressMonitor());
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            AWSVirtualOrganization awsVo;
            String currentAwsAccessId;
            IGridElement gridElement = iGridElementArray[n2];
            if (gridElement instanceof AWSVirtualOrganization && (currentAwsAccessId = (awsVo = (AWSVirtualOrganization)gridElement).getProperties().getAwsAccessId()).equals(awsAccessId)) {
                IGridResourceCategory category = GridResourceCategoryFactory.getCategory((String)"eu.geclipse.core.model.category.computing");
                awsVo.refreshResources(category, (IProgressMonitor)new NullProgressMonitor());
            }
            ++n2;
        }
    }

    public AMILaunchConfiguration getLaunchConfiguration(ILaunchConfiguration configuration) throws CoreException {
        String emptyString = "";
        String amiId = configuration.getAttribute("amiId", emptyString);
        if (amiId.equals(emptyString)) {
            return null;
        }
        AMILaunchConfiguration launchConfig = new AMILaunchConfiguration();
        launchConfig.setAmiId(amiId);
        String minCountString = configuration.getAttribute("minCount", emptyString);
        launchConfig.setMinCount(Integer.valueOf(minCountString));
        String maxCountString = configuration.getAttribute("maxCount", emptyString);
        launchConfig.setMaxCount(Integer.valueOf(maxCountString));
        launchConfig.setKeyName(configuration.getAttribute("keyName", emptyString));
        List securityGroupsList = configuration.getAttribute("securityGroup", new ArrayList());
        ArrayList<String> securityGroupsStringList = new ArrayList<String>(securityGroupsList.size());
        for (Object object : securityGroupsList) {
            securityGroupsStringList.add(object.toString());
        }
        launchConfig.setSecurityGroup(securityGroupsStringList);
        launchConfig.setZone(configuration.getAttribute("zone", emptyString));
        String instanceTypeString = configuration.getAttribute("instanceType", emptyString);
        InstanceType instanceType = InstanceType.getTypeFromString((String)instanceTypeString);
        launchConfig.setInstanceType(instanceType);
        String userDataString = configuration.getAttribute("userData", emptyString);
        String userDataFileString = configuration.getAttribute("userDataFilePath", emptyString);
        byte[] userData = null;
        if (!userDataString.equals(emptyString)) {
            userData = userDataString.getBytes();
        } else if (!userDataFileString.equals(emptyString)) {
            try {
                File userDataFile = new File(userDataFileString);
                FileInputStream fis = new FileInputStream(userDataFile);
                userData = new byte[(int)userDataFile.length()];
                fis.read(userData);
                fis.close();
            }
            catch (FileNotFoundException fnfEx) {
                Activator.log("User Data File was not found", fnfEx);
            }
            catch (IOException ioEx) {
                Activator.log("Could not read user data file", ioEx);
            }
        }
        launchConfig.setUserData(userData);
        return launchConfig;
    }
}

