/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.op;

import com.xerox.amazonws.ec2.AddressInfo;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.IOperation;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2OpDescribeAddresses
implements IOperation {
    private IEC2 ec2Service;
    private List<AddressInfo> result;
    private Exception exception;
    private List<String> addressList;

    public EC2OpDescribeAddresses(IEC2 ec2) {
        this.ec2Service = ec2;
    }

    public EC2OpDescribeAddresses(IEC2 ec2, String address) {
        this.ec2Service = ec2;
        this.addressList = new ArrayList<String>();
        this.addressList.add(address);
    }

    public EC2OpDescribeAddresses(IEC2 ec2, List<String> addresses) {
        this.ec2Service = ec2;
        this.addressList = addresses;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public List<AddressInfo> getResult() {
        return this.result;
    }

    @Override
    public void run() {
        this.result = null;
        this.exception = null;
        try {
            this.result = this.ec2Service.describeAddresses(this.addressList);
        }
        catch (Exception ex) {
            this.exception = ex;
        }
    }
}

