/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.service;

import com.xerox.amazonws.ec2.AddressInfo;
import com.xerox.amazonws.ec2.GroupDescription;
import com.xerox.amazonws.ec2.ImageDescription;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.ReservationDescription;
import eu.geclipse.aws.ec2.EC2AMIImage;
import eu.geclipse.aws.ec2.EC2ElasticIPAddress;
import eu.geclipse.aws.ec2.EC2Instance;
import eu.geclipse.aws.ec2.EC2Keypair;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.EC2SecurityGroup;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.internal.Activator;
import eu.geclipse.aws.ec2.internal.Messages;
import eu.geclipse.aws.ec2.op.AbstractEC2OpDescribeImages;
import eu.geclipse.aws.ec2.op.EC2OpDescribeAddresses;
import eu.geclipse.aws.ec2.op.EC2OpDescribeImagesByExec;
import eu.geclipse.aws.ec2.op.EC2OpDescribeImagesByOwner;
import eu.geclipse.aws.ec2.op.EC2OpDescribeInstances;
import eu.geclipse.aws.ec2.op.EC2OpDescribeKeypairs;
import eu.geclipse.aws.ec2.op.EC2OpDescribeSecurityGroups;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.service.EC2Service;
import eu.geclipse.aws.ec2.service.EC2ServiceProperties;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridResource;
import eu.geclipse.core.model.IGridResourceCategory;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.AbstractGridInfoService;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.core.reporting.ProblemException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2InfoService
extends AbstractGridInfoService
implements IGridInfoService {
    private static final String AMI_OWNER_ALL = "all";
    private static final String AMI_OWNER_SELF = "self";
    public static String STORAGE_NAME = ".ec2InfoService";
    private AWSVirtualOrganization awsVo;
    private EC2Service ec2Service;

    public EC2InfoService(AWSVirtualOrganization awsVo, EC2Service ec2Service) {
        this.awsVo = awsVo;
        this.ec2Service = ec2Service;
    }

    public IGridResource[] fetchResources(IGridContainer parent, IVirtualOrganization vo, IGridResourceCategory category, boolean exclusive, Class<? extends IGridResource> typeFilter, IProgressMonitor monitor) {
        IGridResource[] result = null;
        if (category.equals(GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.computing")) || category.equals(GridResourceCategoryFactory.getCategory((String)"eu.geclipse.core.model.category.computing"))) {
            result = this.fetchInstances(parent, vo, monitor);
        } else if (category.equals(GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.ec2.images.allImages"))) {
            String[] owner = new String[]{AMI_OWNER_ALL, AMI_OWNER_SELF};
            result = this.fetchImages(parent, vo, monitor, new EC2OpDescribeImagesByExec(this.getEc2(), owner));
        } else if (category.equals(GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.ec2.images.myOwned"))) {
            String[] owner = new String[]{AMI_OWNER_SELF};
            result = this.fetchImages(parent, vo, monitor, new EC2OpDescribeImagesByOwner(this.getEc2(), owner));
        } else if (category.equals(GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.ec2.images.myAccessible"))) {
            String[] owner = new String[]{AMI_OWNER_SELF};
            result = this.fetchImages(parent, vo, monitor, new EC2OpDescribeImagesByExec(this.getEc2(), owner));
        } else if (category.equals(GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.ec2.securityGroups"))) {
            result = this.fetchSecurityGroups(parent, vo, monitor);
        } else if (category.equals(GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.ec2.keypairs"))) {
            result = this.fetchKeypairs(parent, vo, monitor);
        } else if (category.equals(GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.ec2.elasticIP"))) {
            result = this.fetchElasticIPs(parent, vo, monitor);
        }
        if (result == null) {
            result = new IGridResource[]{};
        }
        return result;
    }

    private EC2SecurityGroup[] fetchSecurityGroups(IGridContainer parent, IVirtualOrganization vo, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.getString("EC2InfoService.monitor_task_description"), 2);
        EC2OpDescribeSecurityGroups opDescSecurityGroups = new EC2OpDescribeSecurityGroups(this.getEc2());
        new OperationExecuter().execOp(opDescSecurityGroups);
        monitor.worked(1);
        if (opDescSecurityGroups.getException() == null) {
            ArrayList<EC2SecurityGroup> resultSecurityGroups = new ArrayList<EC2SecurityGroup>(opDescSecurityGroups.getResult().size());
            Iterator iterator = opDescSecurityGroups.getResult().iterator();
            while (iterator.hasNext()) {
                GroupDescription groupDesc = (GroupDescription)iterator.next();
                resultSecurityGroups.add(new EC2SecurityGroup(parent, this.ec2Service, groupDesc));
            }
            monitor.worked(2);
            monitor.done();
            return resultSecurityGroups.toArray(new EC2SecurityGroup[resultSecurityGroups.size()]);
        }
        return null;
    }

    private EC2Keypair[] fetchKeypairs(IGridContainer parent, IVirtualOrganization vo, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.getString("EC2InfoService.monitor_task_description"), 2);
        EC2OpDescribeKeypairs opDescKeypairs = new EC2OpDescribeKeypairs(this.getEc2());
        new OperationExecuter().execOp(opDescKeypairs);
        monitor.worked(1);
        if (opDescKeypairs.getException() == null) {
            ArrayList<EC2Keypair> resultKeypairs = new ArrayList<EC2Keypair>(opDescKeypairs.getResult().size());
            Iterator iterator = opDescKeypairs.getResult().iterator();
            while (iterator.hasNext()) {
                KeyPairInfo keyPairInfo = (KeyPairInfo)iterator.next();
                resultKeypairs.add(new EC2Keypair(parent, this.ec2Service, keyPairInfo));
            }
            monitor.worked(2);
            monitor.done();
            return resultKeypairs.toArray(new EC2Keypair[resultKeypairs.size()]);
        }
        return null;
    }

    private EC2ElasticIPAddress[] fetchElasticIPs(IGridContainer parent, IVirtualOrganization vo, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.getString("EC2InfoService.monitor_task_description"), 2);
        EC2OpDescribeAddresses opDescAddresses = new EC2OpDescribeAddresses(this.getEc2());
        new OperationExecuter().execOp(opDescAddresses);
        monitor.worked(1);
        if (opDescAddresses.getException() == null) {
            ArrayList<EC2ElasticIPAddress> resultAddresses = new ArrayList<EC2ElasticIPAddress>(opDescAddresses.getResult().size());
            Iterator iterator = opDescAddresses.getResult().iterator();
            while (iterator.hasNext()) {
                AddressInfo addressInfo = (AddressInfo)iterator.next();
                resultAddresses.add(new EC2ElasticIPAddress(parent, this.ec2Service, addressInfo));
            }
            monitor.worked(2);
            monitor.done();
            return resultAddresses.toArray(new EC2ElasticIPAddress[resultAddresses.size()]);
        }
        return null;
    }

    private IEC2 getEc2() {
        IEC2 ec2 = null;
        try {
            EC2Registry ec2Registry = EC2Registry.getRegistry();
            ec2 = ec2Registry.getEC2(this.awsVo);
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not obtain EC2 instance", (Exception)((Object)problemEx));
        }
        return ec2;
    }

    public IGridResource[] fetchInstances(IGridContainer parent, IVirtualOrganization vo, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.getString("EC2InfoService.monitor_task_description"), 2);
        EC2OpDescribeInstances opDescInstances = new EC2OpDescribeInstances(this.getEc2());
        new OperationExecuter().execOp(opDescInstances);
        monitor.worked(1);
        if (opDescInstances.getException() == null) {
            ArrayList<EC2Instance> resultComputingElements = new ArrayList<EC2Instance>(opDescInstances.getResult().size());
            Iterator iterator = opDescInstances.getResult().iterator();
            while (iterator.hasNext()) {
                ReservationDescription reservationDesc = (ReservationDescription)iterator.next();
                for (ReservationDescription.Instance instance : reservationDesc.getInstances()) {
                    resultComputingElements.add(new EC2Instance(parent, this.ec2Service, instance));
                }
            }
            monitor.worked(2);
            monitor.done();
            return resultComputingElements.toArray(new IGridResource[resultComputingElements.size()]);
        }
        return null;
    }

    public IGridResource[] fetchImages(IGridContainer parent, IVirtualOrganization vo, IProgressMonitor monitor, AbstractEC2OpDescribeImages operation) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.getString("EC2InfoService.monitor_task_description"), 2);
        new OperationExecuter().execOp(operation);
        monitor.worked(1);
        if (operation.getException() == null) {
            ArrayList<EC2AMIImage> resultGridService = new ArrayList<EC2AMIImage>(operation.getResult().size());
            Iterator iterator = operation.getResult().iterator();
            while (iterator.hasNext()) {
                ImageDescription imageDescription = (ImageDescription)iterator.next();
                resultGridService.add(new EC2AMIImage(parent, this.ec2Service, imageDescription));
            }
            monitor.worked(2);
            monitor.done();
            return resultGridService.toArray(new IGridResource[resultGridService.size()]);
        }
        return null;
    }

    public String getHostName() {
        try {
            EC2ServiceProperties properties = this.ec2Service.getProperties();
            if (properties != null) {
                return properties.getEc2Url();
            }
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not load properties from ec2Service", (Exception)((Object)problemEx));
        }
        return null;
    }

    public URI getURI() {
        String hostName = this.getHostName();
        try {
            if (hostName != null) {
                return new URI(hostName);
            }
        }
        catch (URISyntaxException uriEx) {
            Activator.log("Could not creat URI from " + hostName, uriEx);
        }
        return null;
    }

    public IFileStore getFileStore() {
        return this.getParent().getFileStore().getChild(STORAGE_NAME);
    }

    public String getName() {
        return STORAGE_NAME;
    }

    public IGridContainer getParent() {
        return this.ec2Service;
    }

    public IPath getPath() {
        return this.getParent().getPath().append(STORAGE_NAME);
    }

    public IResource getResource() {
        return null;
    }

    public boolean isLocal() {
        return false;
    }
}

