/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.s3.internal;

import eu.geclipse.aws.s3.internal.S3ServiceRegistry;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.jets3t.service.Jets3tProperties;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends Plugin
implements IProxyChangeListener {
    public static final String PLUGIN_ID = "eu.geclipse.aws.s3";
    private static final String HTTP_RETRY_COUNT_KEY = "httpclient.retry-max";
    private static final String HTTP_PROXY_AUTO_DETECT_KEY = "httpclient.proxy-autodetect";
    private static final String HTTP_PROXY_HOST_KEY = "httpclient.proxy-host";
    private static final String HTTP_PROXY_PORT_KEY = "httpclient.proxy-port";
    private static final String JETS3T_PROPERTIES = "jets3t.properties";
    private static Activator plugin;
    private ServiceTracker tracker;

    public Activator() {
        Jets3tProperties props = this.getJets3tProperties();
        props.setProperty(HTTP_RETRY_COUNT_KEY, "2");
        props.setProperty(HTTP_PROXY_AUTO_DETECT_KEY, "false");
    }

    public Jets3tProperties getJets3tProperties() {
        return Jets3tProperties.getInstance((String)JETS3T_PROPERTIES);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.tracker = new ServiceTracker(this.getBundle().getBundleContext(), IProxyService.class.getName(), null);
        this.tracker.open();
        this.getProxyService().addProxyChangeListener((IProxyChangeListener)this);
        this.updateProxySettings();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void logStatus(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }

    public static void log(Exception e) {
        Activator.log(e.getLocalizedMessage(), e);
    }

    public static void log(String description, Exception e) {
        if (description == null) {
            description = e.getClass().getName();
        }
        Status status = new Status(4, PLUGIN_ID, 0, description, (Throwable)e);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    public IProxyService getProxyService() {
        return (IProxyService)this.tracker.getService();
    }

    public void proxyInfoChanged(IProxyChangeEvent event) {
        this.updateProxySettings();
    }

    private void updateProxySettings() {
        IProxyService proxyService = this.getProxyService();
        boolean enabled = proxyService.isProxiesEnabled();
        Jets3tProperties jets3tProperties = this.getJets3tProperties();
        if (enabled) {
            IProxyData proxyData = proxyService.getProxyData("HTTP");
            String host = proxyData.getHost();
            String port = String.valueOf(proxyData.getPort());
            jets3tProperties.setProperty(HTTP_PROXY_HOST_KEY, host);
            jets3tProperties.setProperty(HTTP_PROXY_PORT_KEY, port);
        } else {
            jets3tProperties.clearProperty(HTTP_PROXY_HOST_KEY);
            jets3tProperties.clearProperty(HTTP_PROXY_PORT_KEY);
        }
        S3ServiceRegistry.getRegistry().clear();
    }
}

