/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.s3.internal.fileSystem;

import eu.geclipse.aws.s3.internal.fileSystem.S3FileStore;
import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileSystem;

public class S3FileSystem
extends FileSystem
implements IFileSystem {
    public boolean canDelete() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public IFileStore getStore(URI uri) {
        S3FileStore result;
        String bucketName = uri.getPath();
        String awsAccessId = uri.getAuthority();
        if (bucketName != null && bucketName.startsWith("/")) {
            bucketName = bucketName.substring(1);
        }
        if (bucketName == null || bucketName.length() == 0) {
            result = new S3FileStore(awsAccessId);
        } else {
            S3FileStore parent = new S3FileStore(awsAccessId);
            result = (S3FileStore)parent.getChild(bucketName);
        }
        return result;
    }
}

