/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.s3.service;

import eu.geclipse.aws.s3.S3BucketStorage;
import eu.geclipse.aws.s3.internal.Activator;
import eu.geclipse.aws.s3.internal.S3ServiceRegistry;
import eu.geclipse.aws.s3.service.Messages;
import eu.geclipse.aws.s3.service.S3AWSService;
import eu.geclipse.aws.s3.service.S3ServiceProperties;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridResource;
import eu.geclipse.core.model.IGridResourceCategory;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.AbstractGridInfoService;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.core.reporting.ProblemException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.model.S3Bucket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3InfoService
extends AbstractGridInfoService {
    public static String STORAGE_NAME = ".s3InfoService";
    private S3AWSService s3Service;

    public S3InfoService(S3AWSService s3Service) {
        this.s3Service = s3Service;
    }

    public IGridResource[] fetchResources(IGridContainer parent, IVirtualOrganization vo, IGridResourceCategory category, boolean exclusive, Class<? extends IGridResource> typeFilter, IProgressMonitor monitor) {
        IGridResource[] result = null;
        if (category.equals(GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.storage.s3"))) {
            result = this.fetchBuckets(parent, vo, monitor);
        }
        if (result == null) {
            result = new IGridResource[]{};
        }
        return result;
    }

    public IGridResource[] fetchBuckets(IGridContainer parent, IVirtualOrganization vo, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.getString("S3InfoService.monitor_fetch_storage_title"), 3);
        S3ServiceRegistry s3ServiceRegistry = S3ServiceRegistry.getRegistry();
        IGridResource[] s3BucketStorages = null;
        monitor.worked(1);
        try {
            try {
                AWSVirtualOrganization awsVo = (AWSVirtualOrganization)vo;
                S3Service service = s3ServiceRegistry.getService(awsVo.getProperties().getAwsAccessId());
                if (service != null) {
                    S3Bucket[] buckets = service.listAllBuckets();
                    monitor.worked(2);
                    if (buckets != null) {
                        s3BucketStorages = new S3BucketStorage[buckets.length];
                        int i = 0;
                        while (i < buckets.length) {
                            s3BucketStorages[i] = new S3BucketStorage(parent, this.s3Service, buckets[i]);
                            ++i;
                        }
                    }
                    monitor.worked(3);
                }
            }
            catch (ProblemException probEx) {
                Activator.log("Could not obtain S3Service", (Exception)((Object)probEx));
                monitor.done();
            }
            catch (S3ServiceException s3ServEx) {
                Activator.log("Could not fetch list of buckets from S3Service", (Exception)((Object)s3ServEx));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return s3BucketStorages;
    }

    public String getHostName() {
        try {
            S3ServiceProperties properties = this.s3Service.getProperties();
            if (properties != null) {
                return properties.getS3Url();
            }
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not load properties from s3AWSService", (Exception)((Object)problemEx));
        }
        return null;
    }

    public URI getURI() {
        String hostName = this.getHostName();
        try {
            if (hostName != null) {
                return new URI(hostName);
            }
        }
        catch (URISyntaxException uriEx) {
            Activator.log("Could not creat URI from " + hostName, uriEx);
        }
        return null;
    }

    public IFileStore getFileStore() {
        return this.getParent().getFileStore().getChild(STORAGE_NAME);
    }

    public String getName() {
        return STORAGE_NAME;
    }

    public IGridContainer getParent() {
        return this.s3Service;
    }

    public IPath getPath() {
        return this.getParent().getPath().append(STORAGE_NAME);
    }

    public IResource getResource() {
        return null;
    }

    public boolean isLocal() {
        return false;
    }
}

