/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.s3.service;

import eu.geclipse.aws.s3.service.S3AWSService;
import eu.geclipse.aws.s3.service.S3AWSServiceCreator;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IStorableElement;
import eu.geclipse.core.model.impl.AbstractGridElement;
import eu.geclipse.core.reporting.ProblemException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class S3ServiceProperties
extends AbstractGridElement
implements IStorableElement {
    public static final String STORAGE_NAME = ".s3_service_properties";
    private S3AWSService s3Service;
    private String s3Url;
    private String serviceName;

    public S3ServiceProperties(S3AWSService s3Service) {
        this.s3Service = s3Service;
    }

    public S3ServiceProperties(S3AWSService s3Service, S3AWSServiceCreator serviceCreator) {
        this.s3Service = s3Service;
        this.s3Url = serviceCreator.getServiceURL();
        this.serviceName = serviceCreator.getServiceName();
    }

    public void load() throws ProblemException {
        BufferedReader bufferedReader = null;
        try {
            try {
                String url;
                IFileStore fileStore = this.getFileStore();
                InputStream iStream = fileStore.openInputStream(0, null);
                InputStreamReader iReader = new InputStreamReader(iStream);
                bufferedReader = new BufferedReader(iReader);
                String serviceName = bufferedReader.readLine();
                if (serviceName != null && serviceName.trim().length() != 0) {
                    this.serviceName = serviceName;
                }
                if ((url = bufferedReader.readLine()) != null && url.trim().length() != 0) {
                    this.s3Url = url;
                }
            }
            catch (IOException ioExc) {
                throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)ioExc, "eu.geclipse.aws.s3");
            }
            catch (CoreException cExc) {
                throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)cExc, "eu.geclipse.aws.s3");
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ioExc) {
                    throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)ioExc, "eu.geclipse.aws.s3");
                }
            }
        }
    }

    public void save() throws ProblemException {
        IFileStore fileStore = this.getFileStore();
        BufferedWriter bWriter = null;
        try {
            try {
                OutputStream oStream = fileStore.openOutputStream(0, null);
                OutputStreamWriter osWriter = new OutputStreamWriter(oStream);
                bWriter = new BufferedWriter(osWriter);
                if (this.serviceName != null) {
                    bWriter.write(this.serviceName);
                }
                bWriter.write(10);
                if (this.s3Url != null) {
                    bWriter.write(this.s3Url);
                }
                bWriter.write(10);
            }
            catch (IOException ioExc) {
                throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)ioExc, "eu.geclipse.aws.s3");
            }
            catch (CoreException cExc) {
                throw new ProblemException("eu.geclipse.core.problem.model.elementSaveFailed", (Throwable)cExc, "eu.geclipse.aws.s3");
            }
        }
        finally {
            try {
                if (bWriter != null) {
                    bWriter.close();
                }
            }
            catch (IOException ioExc) {
                throw new ProblemException("eu.geclipse.core.problem.model.elementSaveFailed", (Throwable)ioExc, "eu.geclipse.aws.s3");
            }
        }
    }

    public IFileStore getFileStore() {
        return this.getParent().getFileStore().getChild(this.getName());
    }

    public String getName() {
        return STORAGE_NAME;
    }

    public IGridContainer getParent() {
        return this.s3Service;
    }

    public IPath getPath() {
        return this.getParent().getPath().append(this.getName());
    }

    public IResource getResource() {
        return null;
    }

    public boolean isLocal() {
        return true;
    }

    public String getS3Url() {
        return this.s3Url;
    }

    public void setS3Url(String s3Url) {
        this.s3Url = s3Url;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

