/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ui.internal;

import eu.geclipse.aws.auth.AWSAuthTokenDescription;
import eu.geclipse.aws.ui.internal.Activator;
import eu.geclipse.core.auth.AuthenticationException;
import eu.geclipse.core.auth.AuthenticationTokenManager;
import eu.geclipse.core.auth.IAuthenticationToken;
import eu.geclipse.core.auth.IAuthenticationTokenDescription;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class AWSKeyStoreCreationOperation
implements IRunnableWithProgress {
    private AWSAuthTokenDescription description;

    public AWSKeyStoreCreationOperation(AWSAuthTokenDescription description) {
        this.description = description;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        AuthenticationTokenManager manager = AuthenticationTokenManager.getManager();
        IAuthenticationToken token = null;
        try {
            token = manager.createToken((IAuthenticationTokenDescription)this.description);
            if (token != null) {
                token.validate(monitor);
            }
        }
        catch (AuthenticationException authEx) {
            if (token != null) {
                try {
                    manager.destroyToken(token);
                }
                catch (AuthenticationException authExDestroy) {
                    Activator.log("Problems destroying invalid token", (Exception)((Object)authExDestroy));
                }
            }
            throw new InvocationTargetException(authEx);
        }
    }
}

