/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ui.wizards;

import eu.geclipse.aws.auth.AWSAuthTokenDescription;
import eu.geclipse.aws.ui.Messages;
import eu.geclipse.aws.ui.internal.AWSKeyStoreCreationOperation;
import eu.geclipse.aws.ui.wizards.AWSAuthTokenWizardPage;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.wizards.VoSelectionWizardPage;
import eu.geclipse.ui.wizards.wizardselection.IInitializableWizard;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;

public class AWSAuthTokenWizard
extends Wizard
implements IInitializableWizard {
    private AWSAuthTokenDescription authTokenDesc;
    private AWSAuthTokenWizardPage authTokenWizardPage;
    private VoSelectionWizardPage voSelectionPage;
    private boolean canFinish;

    public AWSAuthTokenWizard() {
        this.setCanFinish(false);
    }

    public void addPages() {
        if (this.authTokenDesc != null) {
            if (this.authTokenDesc.getAwsVo() == null) {
                this.voSelectionPage = new VoSelectionWizardPage(false, AWSVirtualOrganization.class);
                this.addPage((IWizardPage)this.voSelectionPage);
            }
            this.authTokenWizardPage = new AWSAuthTokenWizardPage(this, this.authTokenDesc);
            this.addPage((IWizardPage)this.authTokenWizardPage);
        } else {
            this.voSelectionPage = new VoSelectionWizardPage(false, AWSVirtualOrganization.class);
            this.authTokenWizardPage = new AWSAuthTokenWizardPage(this, null);
            this.addPage((IWizardPage)this.voSelectionPage);
            this.addPage((IWizardPage)this.authTokenWizardPage);
        }
        this.setNeedsProgressMonitor(true);
    }

    public String getWindowTitle() {
        return Messages.getString("AWSAuthTokenWizard.wizard_title");
    }

    public boolean performFinish() {
        WizardPage currentPage = (WizardPage)this.getContainer().getCurrentPage();
        if (currentPage == this.authTokenWizardPage && !this.authTokenWizardPage.isValid()) {
            this.authTokenWizardPage.registerFormListener();
            return false;
        }
        AWSAuthTokenDescription tokenDesc = this.authTokenWizardPage.getTokenDescription();
        AWSKeyStoreCreationOperation op = new AWSKeyStoreCreationOperation(tokenDesc);
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException itExc) {
            Throwable cause = itExc.getCause();
            ProblemDialog.openProblem((Shell)this.getShell(), (String)Messages.getString("AWSAuthTokenWizard.problem_dialog_title"), (String)Messages.getString("AWSAuthTokenWizard.problem_dialog_description"), (Throwable)cause);
            currentPage.setErrorMessage(cause.getLocalizedMessage());
        }
        catch (InterruptedException intExc) {
            currentPage.setErrorMessage(intExc.getLocalizedMessage());
        }
        String errorMessage = currentPage.getErrorMessage();
        return errorMessage == null || errorMessage.length() == 0;
    }

    public boolean init(Object data) {
        if (data instanceof AWSAuthTokenDescription) {
            this.authTokenDesc = (AWSAuthTokenDescription)data;
        }
        return true;
    }

    public boolean canFinish() {
        return this.canFinish;
    }

    public void setCanFinish(boolean canFinish) {
        this.canFinish = canFinish;
    }
}

