/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.auth;

import eu.geclipse.aws.auth.AWSAuthTokenDescription;
import eu.geclipse.aws.internal.Messages;
import eu.geclipse.core.auth.AbstractAuthenticationToken;
import eu.geclipse.core.auth.AuthenticationException;
import eu.geclipse.core.auth.IAuthenticationTokenDescription;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class AWSAuthToken
extends AbstractAuthenticationToken {
    private static int awsAuthTokenCounter;
    private boolean isValid;
    private boolean isActive = true;
    private String tokenId = this.generateId();

    public AWSAuthToken(IAuthenticationTokenDescription description) {
        super(description);
    }

    public String getID() {
        return this.tokenId;
    }

    private String generateId() {
        AWSAuthTokenDescription description = (AWSAuthTokenDescription)this.getDescription();
        String name = description.getTokenTypeName();
        String awsAccessId = null;
        if (description.getAwsAccessId() != null) {
            awsAccessId = description.getAwsAccessId();
        }
        Integer counter = ++awsAuthTokenCounter;
        StringBuilder strBuilder = new StringBuilder(name);
        strBuilder.append(" # " + counter);
        if (awsAccessId != null) {
            strBuilder.append(" @ " + awsAccessId);
        }
        return strBuilder.toString();
    }

    public long getTimeLeft() {
        return -1L;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setActive(boolean active, IProgressMonitor monitor) throws AuthenticationException {
        this.validate();
        if (!this.isValid()) {
            throw new AuthenticationException("eu.geclipse.core.problem.auth.tokenNotYetValid", "eu.geclipse.aws");
        }
        IAuthenticationTokenDescription aDesc = this.getDescription();
        if (!(aDesc instanceof AWSAuthTokenDescription)) {
            throw new AuthenticationException("eu.geclipse.core.problem.auth.invalidTokenDescription", "eu.geclipse.aws");
        }
        this.isActive = active;
    }

    public void setActive(boolean active) throws AuthenticationException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.setActive(active, (IProgressMonitor)monitor);
    }

    public void validate(IProgressMonitor monitor) throws AuthenticationException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.getString("AWSAuthToken.validation_progress_title"), 2);
        monitor.worked(1);
        this.isValid = true;
        monitor.done();
    }

    public void validate() throws AuthenticationException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.validate((IProgressMonitor)monitor);
    }
}

