/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.vo;

import eu.geclipse.aws.AWSInfoService;
import eu.geclipse.aws.IAWSService;
import eu.geclipse.aws.IAWSServiceCreator;
import eu.geclipse.aws.internal.Activator;
import eu.geclipse.aws.internal.Messages;
import eu.geclipse.aws.vo.AWSVoCreator;
import eu.geclipse.aws.vo.AWSVoProperties;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridResourceCategory;
import eu.geclipse.core.model.IStorableElement;
import eu.geclipse.core.model.impl.AbstractVirtualOrganization;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.core.reporting.ProblemException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSVirtualOrganization
extends AbstractVirtualOrganization {
    private static final String AWS_VO_WIZARD_ID = "eu.geclipse.aws.ui.wizard.awsVoWizard";
    private static final String VO_TYPE_NAME = Messages.getString("AWSVirtualOrganization.vo_type_name");
    private String voName;
    public static IGridResourceCategory[] STANDARD_RESOURCE_CATEGORIES = new IGridResourceCategory[]{GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.computing"), GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.service"), GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.storage")};

    public AWSVirtualOrganization() {
    }

    public AWSVirtualOrganization(IFileStore fileStore) {
        if (fileStore != null) {
            this.voName = fileStore.getName();
            try {
                this.load();
                this.addElement((IGridElement)new AWSInfoService(this));
            }
            catch (ProblemException e) {
                Activator.log("Could not load the awsVo details from the filestore", (Exception)((Object)e));
            }
        } else {
            Activator.log("Could not populate AWSVirtualOrganization with data from fileStore since given filestore was 'null'");
        }
    }

    protected AWSVirtualOrganization(AWSVoCreator voCreator) {
        try {
            this.apply(voCreator);
            this.addElement((IGridElement)new AWSInfoService(this));
        }
        catch (ProblemException e) {
            Activator.log("Could not populate awsVo with data from provided AWSVo creator", (Exception)((Object)e));
        }
    }

    void apply(AWSVoCreator voCreator) throws ProblemException {
        this.voName = voCreator.getVoName();
        AWSVoProperties voProperties = new AWSVoProperties(this, voCreator);
        this.addElement((IGridElement)voProperties);
        List<IAWSServiceCreator> serviceCreators = AWSVoCreator.getAWSServiceCreators();
        for (IAWSServiceCreator serviceCreator : serviceCreators) {
            this.create(serviceCreator);
        }
    }

    public void load() throws ProblemException {
        this.deleteAll();
        IFileStore fileStore = this.getFileStore();
        List configurationElements = GridModel.getCreatorRegistry().getConfigurations(null, IAWSService.class);
        try {
            IFileStore[] childStores;
            IFileStore[] iFileStoreArray = childStores = fileStore.childStores(0, null);
            int n = childStores.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                AWSVoProperties gridElement = null;
                String childName = child.getName();
                if (childName.equals(".aws_vo_properties")) {
                    AWSVoProperties properties = new AWSVoProperties(this);
                    properties.load();
                    gridElement = properties;
                } else {
                    for (IConfigurationElement configElement : configurationElements) {
                        IGridElementCreator serviceCreator;
                        String creatorId = configElement.getAttribute("id");
                        if (!childName.equals(creatorId) || !((gridElement = (serviceCreator = (IGridElementCreator)configElement.createExecutableExtension("class")).create((IGridContainer)this)) instanceof IStorableElement)) continue;
                        ((IStorableElement)gridElement).load();
                    }
                }
                if (gridElement != null) {
                    this.addElement((IGridElement)gridElement);
                }
                ++n2;
            }
        }
        catch (CoreException cExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)cExc, "eu.geclipse.aws");
        }
    }

    public IGridResourceCategory[] getSupportedCategories() {
        ArrayList categoriesList = new ArrayList();
        try {
            List<IAWSService> awsServices = this.getChildren((IProgressMonitor)new NullProgressMonitor(), IAWSService.class);
            for (IAWSService service : awsServices) {
                IGridResourceCategory[] supportedResources = service.getSupportedResources();
                if (supportedResources == null) continue;
                Collections.addAll(categoriesList, supportedResources);
            }
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not fetch the AWSServices from the AWS VO", (Exception)((Object)problemEx));
        }
        Collections.addAll(categoriesList, STANDARD_RESOURCE_CATEGORIES);
        return categoriesList.toArray(new IGridResourceCategory[categoriesList.size()]);
    }

    protected IGridElement loadChild(String childName) {
        return null;
    }

    public boolean canContain(IGridElement element) {
        return super.canContain(element) || element instanceof AWSVoProperties;
    }

    public String getTypeName() {
        return VO_TYPE_NAME;
    }

    public String getWizardId() {
        return AWS_VO_WIZARD_ID;
    }

    public boolean isLazy() {
        return false;
    }

    public String getName() {
        return this.voName;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof AWSVirtualOrganization) {
            result = this.equals((AWSVirtualOrganization)((Object)obj));
        }
        return result;
    }

    private boolean equals(AWSVirtualOrganization vo) {
        return this.getName().equals(vo.getName());
    }

    public AWSVoProperties getProperties() throws ProblemException {
        IGridElement[] children;
        AWSVoProperties properties = null;
        IGridElement[] iGridElementArray = children = this.getChildren(null);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement child = iGridElementArray[n2];
            if (child instanceof AWSVoProperties) {
                properties = (AWSVoProperties)child;
                break;
            }
            ++n2;
        }
        return properties;
    }

    public <T extends IGridElement> List<T> getChildren(IProgressMonitor monitor, Class<T> elementType) throws ProblemException {
        IGridElement[] children = this.getChildren(monitor);
        ArrayList<IGridElement> childrenList = new ArrayList<IGridElement>();
        if (elementType != null) {
            IGridElement[] iGridElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement gridElement = iGridElementArray[n2];
                if (elementType.isInstance(gridElement)) {
                    childrenList.add(gridElement);
                }
                ++n2;
            }
        }
        return childrenList;
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

