/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.dialogs;

import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.widgets.StoredCombo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AllowedVOsDialog
extends Dialog {
    private static final String VONAME_STRINGS = "voname_string";
    protected String newVO = null;
    protected boolean editMode = false;
    protected Composite panel = null;
    protected Label lblVOName = null;
    protected StoredCombo txtVOName = null;
    private String title = null;

    public AllowedVOsDialog(Shell parentShell, String title) {
        super(parentShell);
        this.title = title;
        this.setShellStyle(68848);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setMinimumSize(300, 130);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control btnBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return btnBar;
    }

    private void enableOKButton(boolean value) {
        this.getButton(0).setEnabled(value);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)gd);
        this.panel = new Composite(container, 0);
        GridLayout layout = new GridLayout(3, false);
        this.panel.setLayout((Layout)layout);
        gd = new GridData(768);
        this.panel.setLayoutData((Object)gd);
        gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        GridData gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        this.lblVOName = new Label(this.panel, 0);
        this.lblVOName.setText(Messages.getString("AllowedVODialog_VOName"));
        Activator activator = Activator.getDefault();
        IPreferenceStore preferenceStore = activator.getPreferenceStore();
        this.txtVOName = new StoredCombo(this.panel, 4);
        this.txtVOName.setPreferences(preferenceStore, VONAME_STRINGS);
        this.txtVOName.setLayoutData((Object)gData);
        if (this.editMode) {
            this.txtVOName.setText(this.newVO);
        }
        this.txtVOName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AllowedVOsDialog.this.newVO = AllowedVOsDialog.this.txtVOName.getText();
                AllowedVOsDialog.this.validateFields();
            }
        });
        Dialog.applyDialogFont((Control)container);
        this.addVONames();
        return parent;
    }

    protected void validateFields() {
        if (this.txtVOName.getText().trim().length() > 0) {
            this.enableOKButton(true);
        } else {
            this.enableOKButton(false);
        }
    }

    public void setInput(String dialogInput) {
        this.newVO = dialogInput;
        this.editMode = true;
    }

    private String getDialogSettingsSectionName() {
        return "org.eclipse.debug.ui.ALLOWED_VOS_DIALOG";
    }

    public String getValue() {
        return this.newVO.trim();
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public int open() {
        AllowedVOsDialog.applyDialogFont((Control)this.panel);
        return super.open();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    private void addVONames() {
        IGridElement[] gridElements = null;
        try {
            gridElements = GridModel.getVoManager().getChildren(null);
        }
        catch (ProblemException problemException) {}
        if (gridElements != null) {
            IGridElement[] iGridElementArray = gridElements;
            int n = gridElements.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement element = iGridElementArray[n2];
                String name = element.getName();
                if (name != null && this.txtVOName.indexOf(name) == -1) {
                    this.txtVOName.add(name);
                }
                ++n2;
            }
        }
    }
}

