/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.editors;

import eu.geclipse.batch.model.qdl.QueueType;
import eu.geclipse.batch.model.qdl.util.QdlAdapterFactory;
import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.internal.pages.AdvancedQueueConfigPage;
import eu.geclipse.batch.ui.internal.pages.SimpleQueueConfigPage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class QueueEditor
extends FormEditor
implements IEditingDomainProvider {
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected AdapterFactoryEditingDomain editingDomain;
    protected boolean updateProblemIndication = true;
    protected ComposedAdapterFactory adapterFactory;
    protected QueueType queue = null;
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedRes;
                    protected Collection<Resource> removedRes;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).QueueEditor.this.editingDomain.getResourceSet();
                        this.changedRes = new ArrayList<Resource>();
                        this.removedRes = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta deltaIn) {
                        Resource resource;
                        if (deltaIn.getFlags() != 131072 && deltaIn.getResource().getType() == 1 && (deltaIn.getKind() & 6) != 0 && (resource = this.resourceSet.getResource(URI.createURI((String)deltaIn.getFullPath().toString()), false)) != null) {
                            if ((deltaIn.getKind() & 2) != 0) {
                                this.removedRes.add(resource);
                            } else if (!(this).QueueEditor.this.savedResources.remove(resource)) {
                                this.changedRes.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedRes;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedRes;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    QueueEditor.this.removedResources.addAll(visitor.getRemovedResources());
                    if (!QueueEditor.this.isDirty()) {
                        QueueEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                QueueEditor.this.getSite().getPage().closeEditor((IEditorPart)QueueEditor.this, false);
                            }
                        });
                    }
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    QueueEditor.this.changedResources.addAll(visitor.getChangedResources());
                    if (QueueEditor.this.getSite().getPage().getActiveEditor() == QueueEditor.this) {
                        QueueEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                QueueEditor.this.handleActivate();
                            }
                        });
                    }
                }
            }
            catch (CoreException exception) {
                Activator.logException((Exception)((Object)exception));
            }
        }
    };
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = QueueEditor.this.analyzeResourceProblems((Resource)notification.getNotifier(), null);
                        if (diagnostic.getSeverity() != 0) {
                            QueueEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            QueueEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!QueueEditor.this.updateProblemIndication) return;
                        QueueEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                QueueEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource targetIn) {
            this.basicUnsetTarget((Notifier)targetIn);
        }
    };
    private StructuredTextEditor editor = null;
    private int sourcePageIndex;
    private boolean refreshedModel = false;
    private boolean isDirtyFlag = false;
    private SimpleQueueConfigPage simpleQueueConfigPage = new SimpleQueueConfigPage(this);
    private AdvancedQueueConfigPage advancedQueueConfigPage = new AdvancedQueueConfigPage(this);

    public QueueEditor() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new QdlAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                Composite container2 = QueueEditor.this.getContainer();
                container2.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        QueueEditor.this.firePropertyChange(257);
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected void cleanDirtyState() {
        this.simpleQueueConfigPage.setDirty(false);
        this.advancedQueueConfigPage.setDirty(false);
    }

    public void setDirty(boolean dirtyFlag) {
        if (this.isDirtyFlag != dirtyFlag) {
            this.isDirtyFlag = dirtyFlag;
            this.editorDirtyStateChanged();
        }
    }

    protected void addPages() {
        this.getQdlModel();
        try {
            this.addPage((IFormPage)this.simpleQueueConfigPage);
            this.addPage((IFormPage)this.advancedQueueConfigPage);
            this.addResourceEditorPage();
            this.pushContentToPages();
        }
        catch (PartInitException e) {
            Activator.logException((Exception)((Object)e));
        }
    }

    private void pushContentToPages() {
        this.simpleQueueConfigPage.setPageContent(this.queue, this.isModelRefreshed());
        this.advancedQueueConfigPage.setPageContent(this.queue, this.isModelRefreshed());
    }

    protected void refreshEditor() {
        this.refreshedModel = true;
        this.pushContentToPages();
        this.refreshedModel = false;
    }

    protected void doTextEditorSave() {
        this.editor.doSave(null);
    }

    public void doSave(IProgressMonitor monitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitorIn) {
                boolean first = true;
                for (Resource resource : QueueEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !QueueEditor.this.isPersisted(resource) || QueueEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        QueueEditor.this.savedResources.add(resource);
                        resource.save(Collections.EMPTY_MAP);
                    }
                    catch (Exception exception) {
                        QueueEditor.this.resourceToDiagnosticMap.put(resource, QueueEditor.this.analyzeResourceProblems(resource, exception));
                        QueueEditor.this.doTextEditorSave();
                        QueueEditor.this.cleanDirtyState();
                        QueueEditor.this.refreshEditor();
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.doTextEditorSave();
            this.cleanDirtyState();
            this.refreshEditor();
        }
        catch (Exception exception) {
            Activator.logException(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    public void dispose() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.adapterFactory.dispose();
        super.dispose();
        if (this.queue != null) {
            this.queue.eResource().unload();
            this.queue = null;
        }
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public boolean isModelRefreshed() {
        return this.refreshedModel;
    }

    private void addResourceEditorPage() throws PartInitException {
        this.sourcePageIndex = this.addPage((IEditorPart)this.getSourceEditor(), this.getEditorInput());
        this.setPageText(this.sourcePageIndex, this.getEditorInput().getName());
        this.getSourceEditor().setInput(this.getEditorInput());
    }

    private StructuredTextEditor getSourceEditor() {
        if (this.editor == null) {
            this.editor = new StructuredTextEditor();
            this.editor.setEditorPart((IEditorPart)this);
        }
        return this.editor;
    }

    protected IEditorSite createSite(IEditorPart page) {
        Object site = null;
        site = page == this.editor ? new MultiPageEditorSite((MultiPageEditorPart)this, page){

            public String getId() {
                return "org.eclipse.core.runtime.xml.source";
            }
        } : super.createSite(page);
        return site;
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
                this.dispose();
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
            this.getQdlModel();
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"QueueEditor.FileConflict.label", (String)"Queue.WARN.FileConflict");
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
    }

    public void getQdlModel() {
        IFileEditorInput modelFile = (IFileEditorInput)this.getEditorInput();
        URI resourceURI = URI.createPlatformResourceURI((String)modelFile.getFile().getFullPath().toString(), (boolean)false);
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
        this.getResourceRoot(resource);
        if (!this.changedResources.isEmpty()) {
            this.refreshEditor();
        }
    }

    private void getResourceRoot(Resource resource) {
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject testElement = (EObject)iterator.next();
            if (!(testElement instanceof QueueType)) continue;
            this.queue = (QueueType)testElement;
        }
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        Object basicDiagnostic = null;
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            basicDiagnostic = new BasicDiagnostic(4, "eu.geclipse.batch.ui", 0, Messages.getString("QueueEditor.CreateModelErrorMessage"), new Object[]{exception == null ? resource : exception});
            ((BasicDiagnostic)basicDiagnostic).merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
        } else {
            basicDiagnostic = exception != null ? new BasicDiagnostic(4, "eu.geclipse.batch.ui", 0, Messages.getString("QueueEditor.CreateModelErrorMessage"), new Object[]{exception}) : Diagnostic.OK_INSTANCE;
        }
        return basicDiagnostic;
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "eu.geclipse.batch.ui", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                }
                catch (PartInitException exception) {
                    Activator.logException((Exception)((Object)exception));
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        Activator.logException((Exception)((Object)exception));
                    }
                }
            }
        }
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException e) {
            Activator.logException(e);
        }
        return result;
    }
}

