/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal;

import eu.geclipse.batch.IBatchService;
import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.internal.model.ComputingElement;
import eu.geclipse.batch.ui.internal.parts.BatchTreeEditPart;
import eu.geclipse.batch.ui.internal.parts.ComputingElementEditPart;
import eu.geclipse.batch.ui.wizards.AddQueueWizard;
import java.util.Iterator;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchPart;

public class ComputingElementAction
extends SelectionAction {
    public static final String PROPERTY_COMPUTINGELEMENT_ACTION_NEWQUEUE = "ComputingElementAction.NewQueue";
    private IBatchService batchWrapper;

    public ComputingElementAction(IWorkbenchPart part, IBatchService batchWrapper) {
        super(part);
        this.batchWrapper = batchWrapper;
        this.setId(PROPERTY_COMPUTINGELEMENT_ACTION_NEWQUEUE);
        this.setToolTipText(Messages.getString("ComputingElementAction.Msg.NewQueueTips"));
        this.setImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor("newQueue"));
        this.setText(Messages.getString("ComputingElementAction.Msg.NewQueueText"));
    }

    public void run() {
        Iterator iterator = this.getSelectedObjects().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            AddQueueWizard wizard = new AddQueueWizard(this.batchWrapper);
            wizard.init(this.getWorkbenchPart().getSite().getWorkbenchWindow().getWorkbench(), (IStructuredSelection)this.getSelection());
            WizardDialog dialog = new WizardDialog(this.getWorkbenchPart().getSite().getShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
        }
    }

    protected boolean calculateEnabled() {
        boolean result;
        boolean bl = result = !this.getSelectedObjects().isEmpty();
        if (result) {
            if (1 > this.getSelectedObjects().size()) {
                result = false;
            } else {
                for (Object o : this.getSelectedObjects()) {
                    if (o instanceof BatchTreeEditPart) {
                        BatchTreeEditPart treeEditPart = (BatchTreeEditPart)o;
                        Object oModel = treeEditPart.getModel();
                        if (oModel instanceof ComputingElement) continue;
                        result = false;
                        break;
                    }
                    if (o instanceof ComputingElementEditPart) continue;
                    result = false;
                    break;
                }
            }
        }
        return result;
    }
}

