/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal;

import eu.geclipse.batch.IBatchService;
import eu.geclipse.batch.IQueueInfo;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.internal.model.Queue;
import eu.geclipse.batch.ui.internal.parts.BatchTreeEditPart;
import eu.geclipse.batch.ui.internal.parts.QueueEditPart;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class QueueDeleteAction
extends SelectionAction {
    public static final String PROPERTY_QUEUE_ACTION_DELETE = "QueueAction.DeleteQueue";
    private IBatchService batchWrapper;

    public QueueDeleteAction(IWorkbenchPart part, IBatchService batchWrapper) {
        super(part);
        this.batchWrapper = batchWrapper;
        this.setId(PROPERTY_QUEUE_ACTION_DELETE);
        this.setToolTipText(Messages.getString("QueueDeleteAction.Msg.DeleteTips"));
        this.setText(Messages.getString("QueueDeleteAction.Msg.Delete"));
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public void run() {
        boolean confirm;
        boolean bl = confirm = !MessageDialog.openConfirm((Shell)this.getWorkbenchPart().getSite().getShell(), (String)Messages.getString("QueueDeleteAction.confirm_delete_title"), (String)Messages.getString("QueueDeleteAction.confirm_delete_message"));
        if (!confirm) {
            for (Object o : this.getSelectedObjects()) {
                Queue q;
                if (o instanceof BatchTreeEditPart) {
                    BatchTreeEditPart treeEditPart = (BatchTreeEditPart)o;
                    q = (Queue)treeEditPart.getModel();
                } else {
                    if (!(o instanceof QueueEditPart)) break;
                    QueueEditPart qEdit = (QueueEditPart)o;
                    q = (Queue)qEdit.getModel();
                }
                try {
                    this.batchWrapper.delQueue(q.getQueneName());
                }
                catch (ProblemException excp) {
                    ProblemDialog.openProblem((Shell)this.getWorkbenchPart().getSite().getShell(), (String)Messages.getString("QueueDeleteAction.error_manipulate_title"), (String)Messages.getString("QueueDeleteAction.error_manipulate_message"), (Throwable)excp);
                }
            }
        }
    }

    protected boolean calculateEnabled() {
        boolean result;
        Queue q = null;
        boolean bl = result = !this.getSelectedObjects().isEmpty();
        if (result) {
            for (Object o : this.getSelectedObjects()) {
                if (o instanceof BatchTreeEditPart) {
                    BatchTreeEditPart treeEditPart = (BatchTreeEditPart)o;
                    Object oModel = treeEditPart.getModel();
                    if (!(oModel instanceof Queue)) {
                        result = false;
                        break;
                    }
                    q = (Queue)oModel;
                } else if (o instanceof QueueEditPart) {
                    QueueEditPart qEdit = (QueueEditPart)o;
                    q = (Queue)qEdit.getModel();
                } else {
                    result = false;
                    break;
                }
                if (q.getState() == IQueueInfo.QueueState.D && q.getRunState() == IQueueInfo.QueueRunState.S && q.isQueueEmpty()) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

