/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal;

import eu.geclipse.batch.IWorkerNodeInfo;
import eu.geclipse.batch.ui.IWorkerNodeFigure;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.SimpleRaisedBorder;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;

public final class WorkerNodeFigure
extends Figure
implements IWorkerNodeFigure {
    private static final Dimension SIZE = new Dimension(100, 40);
    private TitleBarBorder border;
    private Label labState;

    public WorkerNodeFigure() {
        this.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.border = new TitleBarBorder();
        this.border.setBackgroundColor(ColorConstants.menuBackground);
        this.border.setTextColor(ColorConstants.menuForeground);
        CompoundBorder iBorder = new CompoundBorder((Border)new SimpleRaisedBorder(), (Border)new LineBorder(ColorConstants.white));
        this.setBorder((Border)new CompoundBorder((Border)iBorder, (Border)this.border));
        this.setOpaque(true);
        this.setBackgroundColor(ColorConstants.green);
        this.setForegroundColor(ColorConstants.black);
        this.labState = new Label();
        this.add((IFigure)this.labState);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return SIZE;
    }

    public void setFQDN(String name) {
        int idx = name.indexOf(46);
        if (-1 != idx) {
            this.border.setLabel(name.substring(0, idx));
        } else {
            this.border.setLabel(name);
        }
    }

    public void setState(IWorkerNodeInfo.WorkerNodeState state, int numJobs) {
        this.labState.setText(state.toString());
        switch (state) {
            case free: {
                if (numJobs > 0) {
                    this.setBackgroundColor(ColorConstants.darkGreen);
                    break;
                }
                this.setBackgroundColor(ColorConstants.green);
                break;
            }
            case job_exclusive: 
            case busy: {
                this.setBackgroundColor(ColorConstants.yellow);
                break;
            }
            case down: 
            case offline: 
            case unknown: {
                this.setBackgroundColor(ColorConstants.red);
            }
        }
    }
}

