/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.model;

import eu.geclipse.batch.IWorkerNodeInfo;
import eu.geclipse.batch.ui.editors.BatchEditor;
import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.BatchJobManager;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.internal.model.BatchResource;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkerNode
extends BatchResource {
    public static final String PROPERTY_FQDN = "WorkerNode.fqdn";
    public static final String PROPERTY_KERNELVERSION = "WorkerNode.kernelversion";
    public static final String PROPERTY_STATE = "WorkerNode.state";
    public static final String PROPERTY_NUMPROCESSORS = "WorkerNode.numprocessors";
    public static final String PROPERTY_TOTALMEM = "WorkerNode.totalmem";
    public static final String PROPERTY_TOTAL_WN_JOBS = "WorkerNode.totalWNJobs";
    private static final long serialVersionUID = 1L;
    private static IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"WorkerNode.fqdn", Messages.getString("WorkerNodeFigure.fqdn")), new PropertyDescriptor((Object)"WorkerNode.state", Messages.getString("WorkerNodeFigure.State")), new PropertyDescriptor((Object)"WorkerNode.kernelversion", Messages.getString("WorkerNodeFigure.KernelVersion")), new PropertyDescriptor((Object)"WorkerNode.numprocessors", Messages.getString("WorkerNodeFigure.NumProcessors")), new PropertyDescriptor((Object)"WorkerNode.totalmem", Messages.getString("WorkerNodeFigure.TotalMem")), new PropertyDescriptor((Object)"WorkerNode.totalWNJobs", Messages.getString("WorkerNodeFigure.TotalWNJobs"))};
    private final Image workerNodeIcon = Activator.getDefault().getImageRegistry().get("workerNodeIcon");
    private BatchEditor editor;
    private String fqdn;
    private String kernelVersion;
    private IWorkerNodeInfo.WorkerNodeState state;
    private int numProcessors;
    private String totalMem;
    private List<String> jobIds;

    static {
        int i = 0;
        while (i < descriptors.length) {
            ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    int intValue = -1;
                    String str = null;
                    try {
                        intValue = Integer.parseInt((String)value);
                        str = intValue >= 0 ? null : Messages.getString("WorkerNode.Error.LTZero");
                    }
                    catch (NumberFormatException numberFormatException) {
                        str = Messages.getString("WorkerNode.Error.NotANumber");
                    }
                    return str;
                }
            });
            ++i;
        }
    }

    public WorkerNode(BatchJobManager jobManager, BatchEditor editor) {
        super(jobManager);
        this.editor = editor;
        this.jobIds = new ArrayList<String>();
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        Object str = null;
        if (PROPERTY_FQDN.equals(propertyId)) {
            str = this.fqdn;
        } else if (PROPERTY_STATE.equals(propertyId)) {
            str = this.state.toString();
        } else if (PROPERTY_KERNELVERSION.equals(propertyId)) {
            str = this.kernelVersion;
        } else if (PROPERTY_NUMPROCESSORS.equals(propertyId)) {
            str = Integer.toString(this.numProcessors);
        } else if (PROPERTY_TOTALMEM.equals(propertyId)) {
            str = this.totalMem;
        } else if (PROPERTY_TOTAL_WN_JOBS.equals(propertyId)) {
            str = Integer.toString(this.jobIds.size());
        }
        if (str == null) {
            str = super.getPropertyValue(propertyId);
        }
        return str;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcsDelegate.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcsDelegate.removePropertyChangeListener(listener);
    }

    public void setFQDN(String newName) {
        String oldName = this.fqdn;
        this.fqdn = newName;
        this.pcsDelegate.firePropertyChange(PROPERTY_FQDN, oldName, newName);
    }

    public void setKernelVersion(String newVersion) {
        this.kernelVersion = newVersion;
    }

    public void setState(IWorkerNodeInfo.WorkerNodeState newState) {
        IWorkerNodeInfo.WorkerNodeState oldState = this.state;
        this.state = newState;
        this.pcsDelegate.firePropertyChange(PROPERTY_STATE, oldState, newState);
    }

    public void setNumProcessors(int newNumProcessors) {
        this.numProcessors = newNumProcessors;
    }

    public void setTotalMem(String newTotalMem) {
        this.totalMem = newTotalMem;
    }

    public void setJobIds(List<String> jobs) {
        int numOld = this.jobIds.size();
        int numNew = 0;
        if (jobs == null) {
            this.jobIds.clear();
            numNew = 0;
        } else {
            this.jobIds = jobs;
            numNew = jobs.size();
        }
        if (numOld == 0 && numNew > 0 || numOld > 0 && numNew == 0) {
            this.pcsDelegate.firePropertyChange(PROPERTY_TOTAL_WN_JOBS, numOld, numNew);
        }
    }

    public List<String> getJobIds() {
        return this.jobIds;
    }

    public String getFQDN() {
        return this.fqdn;
    }

    public String getKernelVersion() {
        return this.kernelVersion;
    }

    public IWorkerNodeInfo.WorkerNodeState getState() {
        return this.state;
    }

    public int getNumProcessors() {
        return this.numProcessors;
    }

    public String getTotalMem() {
        return this.totalMem;
    }

    @Override
    public Image getIcon() {
        return this.workerNodeIcon;
    }

    public void updateState(IWorkerNodeInfo wni) {
        if (wni.getKernelVersion().compareTo(this.kernelVersion) != 0) {
            this.setKernelVersion(wni.getKernelVersion());
        }
        if (wni.getState() != this.state) {
            this.setState(wni.getState());
        }
        if (wni.getNp() != this.numProcessors) {
            this.setNumProcessors(wni.getNp());
        }
        if (wni.getTotalMem().compareTo(this.totalMem) != 0) {
            this.setTotalMem(wni.getTotalMem());
        }
        this.setJobIds(wni.getJobs());
    }

    @Override
    public String getOutlineString() {
        return String.valueOf(Messages.getString("WorkerNode.WN")) + this.fqdn;
    }

    public int compareTo(Object o) {
        int value;
        if (this.editor.sortedN == 2) {
            String tempName = ((WorkerNode)o).getState().toString();
            value = this.getState().toString().compareTo(tempName);
        } else {
            String tempName = ((WorkerNode)o).getFQDN();
            value = this.getFQDN().compareTo(tempName);
        }
        return value;
    }
}

