/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.parts;

import eu.geclipse.batch.ui.IBoxFigure;
import eu.geclipse.batch.ui.internal.BoxFigure;
import eu.geclipse.batch.ui.internal.model.BatchResource;
import eu.geclipse.batch.ui.internal.model.Box;
import eu.geclipse.batch.ui.internal.parts.BatchEditPart;
import eu.geclipse.batch.ui.internal.parts.ComputingElementEditPart;
import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BoxEditPart
extends BatchEditPart {
    public static Rectangle nodes;
    public static Rectangle queues;
    private int[] firstArea = new int[2];
    private Dimension[] firstDimension = new Dimension[2];
    private boolean firstTime = false;
    private boolean[] firstTimeArea = new boolean[2];
    private int areaQueues = 0;
    private int areaNodes = 0;

    protected Figure createFigure() {
        BoxFigure box = new BoxFigure();
        return box;
    }

    @Override
    public void refreshVisuals() {
        IBoxFigure ceFigure = (IBoxFigure)this.getFigure();
        Box model = (Box)this.getModel();
        ceFigure.setName(model.getName());
        try {
            queues = new Rectangle(model.getLocation(), model.getSize());
            if (model.getIsNodes()) {
                Dimension firstNodes = new Dimension(model.getSize());
                this.areaNodes = firstNodes.getArea();
                if (!this.firstTimeArea[1]) {
                    this.firstArea[1] = this.areaNodes;
                    this.firstTimeArea[1] = true;
                    this.firstDimension[1] = model.getSize();
                }
                if (model.getLocation() != null && model.getLocation() != null) {
                    nodes = new Rectangle(model.getLocation(), model.getSize());
                }
            }
            if (!model.getIsNodes()) {
                Dimension firstQueues = new Dimension(model.getSize());
                this.areaQueues = firstQueues.getArea();
                if (!this.firstTimeArea[0]) {
                    this.firstArea[0] = this.areaQueues;
                    this.firstTimeArea[0] = true;
                    this.firstDimension[0] = model.getSize();
                }
                if (!nodes.intersects(queues) && !ComputingElementEditPart.CE.intersects(queues)) {
                    super.refreshVisuals();
                }
            } else if (!queues.intersects(ComputingElementEditPart.CE)) {
                super.refreshVisuals();
            }
            if (this.areaQueues < this.firstArea[0]) {
                this.resizeAble(this.firstDimension[0], model);
            }
            if (this.areaNodes < this.firstArea[1]) {
                this.resizeAble(this.firstDimension[1], model);
            }
        }
        catch (Exception exception) {}
        if (!this.firstTime) {
            super.refreshVisuals();
        }
        this.firstTime = true;
    }

    private void resizeAble(Dimension initial, Box model) {
        Rectangle rect = new Rectangle(model.getLocation(), initial);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)rect);
    }

    @Override
    public void activate() {
        if (!this.isActive()) {
            super.activate();
        }
    }

    protected List<BatchResource> getModelChildren() {
        return ((Box)this.getModel()).getChildren();
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        try {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new BatchLayoutEditPolicy());
        }
        catch (Exception exception) {}
    }

    private BatchResource getCastedModel() {
        return (BatchResource)this.getModel();
    }

    public Box getMod() {
        return (Box)this.getModel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().equals("ComputingElement.fqdn") || ev.getPropertyName().equals("ComputingElement.type") || ev.getPropertyName().equals("ComputingElement.num_wn") || ev.getPropertyName().equals("ComputingElement.num_queue") || ev.getPropertyName().equals("ComputingElement.num_jobs")) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    BoxEditPart.this.refreshVisuals();
                }
            });
        } else {
            super.propertyChange(ev);
        }
    }

    protected static class BatchLayoutEditPolicy
    extends FlowLayoutEditPolicy {
        protected BatchLayoutEditPolicy() {
        }

        protected Command createAddCommand(EditPart child, EditPart after) {
            return null;
        }

        protected Command getCreateCommand(CreateRequest request) {
            return null;
        }

        protected Command createMoveChildCommand(EditPart child, EditPart after) {
            return null;
        }
    }
}

