/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.parts;

import eu.geclipse.batch.ui.internal.model.BatchDiagram;
import eu.geclipse.batch.ui.internal.model.BatchResource;
import eu.geclipse.batch.ui.internal.model.BatchSetConstraintCommand;
import eu.geclipse.batch.ui.internal.model.ModelElement;
import eu.geclipse.batch.ui.internal.parts.BatchEditPart;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    protected Display display;

    private BatchDiagram getCastedModel() {
        return (BatchDiagram)this.getModel();
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
            this.display = this.getRoot().getViewer().getControl().getDisplay();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new BatchXYLayoutEditPolicy());
    }

    protected IFigure createFigure() {
        FreeformLayer fig = new FreeformLayer();
        fig.setBorder((Border)new MarginBorder(3));
        fig.setLayoutManager((LayoutManager)new FreeformLayout());
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        connLayer.setConnectionRouter((ConnectionRouter)new ShortestPathConnectionRouter((IFigure)fig));
        return fig;
    }

    protected List<BatchResource> getModelChildren() {
        return this.getCastedModel().getChildren();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("BatchDiagram.ChildAdded".equals(prop) || "BatchDiagram.ChildrenAdded".equals(prop) || "BatchDiagram.ChildRemoved".equals(prop)) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    DiagramEditPart.this.refreshChildren();
                }
            });
        }
    }

    protected static class BatchXYLayoutEditPolicy
    extends XYLayoutEditPolicy {
        protected BatchXYLayoutEditPolicy() {
        }

        protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
            Command command = null;
            command = child instanceof BatchEditPart && constraint instanceof Rectangle ? new BatchSetConstraintCommand((BatchResource)child.getModel(), request, (Rectangle)constraint) : super.createChangeConstraintCommand(request, child, constraint);
            return command;
        }

        protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
            return null;
        }

        protected Command getCreateCommand(CreateRequest request) {
            return null;
        }
    }
}

