/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.properties;

import eu.geclipse.batch.BatchConnectionInfo;
import eu.geclipse.batch.ui.properties.Messages;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.properties.AbstractProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IProperty;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchPropertySource
extends AbstractPropertySource<BatchConnectionInfo> {
    private static List<IProperty<BatchConnectionInfo>> staticProperties;

    BatchPropertySource(BatchConnectionInfo connectionInfo) {
        super((Object)connectionInfo);
    }

    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return BatchPropertySource.class;
    }

    protected List<IProperty<BatchConnectionInfo>> getStaticProperties() {
        if (staticProperties == null) {
            staticProperties = BatchPropertySource.createProperties();
        }
        return staticProperties;
    }

    private static List<IProperty<BatchConnectionInfo>> createProperties() {
        ArrayList<IProperty<BatchConnectionInfo>> propertiesList = new ArrayList<IProperty<BatchConnectionInfo>>(1);
        propertiesList.add(BatchPropertySource.createHostName());
        propertiesList.add(BatchPropertySource.createAccountName());
        propertiesList.add(BatchPropertySource.createBatchType());
        propertiesList.add(BatchPropertySource.createUpdateInterval());
        return propertiesList;
    }

    private static IProperty<BatchConnectionInfo> createHostName() {
        return new AbstractProperty<BatchConnectionInfo>(Messages.getString("BatchPropertySource.propertyHostName"), null, false){

            public Object getValue(BatchConnectionInfo source) {
                if (source.getBatchType() == null) {
                    try {
                        source.load();
                    }
                    catch (ProblemException problemException) {}
                }
                return source.getBatchName();
            }
        };
    }

    private static IProperty<BatchConnectionInfo> createAccountName() {
        return new AbstractProperty<BatchConnectionInfo>(Messages.getString("BatchPropertySource.propertyAccountName"), null, false){

            public Object getValue(BatchConnectionInfo source) {
                if (source.getBatchType() == null) {
                    try {
                        source.load();
                    }
                    catch (ProblemException problemException) {}
                }
                return source.getAccount();
            }
        };
    }

    private static IProperty<BatchConnectionInfo> createBatchType() {
        return new AbstractProperty<BatchConnectionInfo>(Messages.getString("BatchPropertySource.propertyBatchType"), null, false){

            public Object getValue(BatchConnectionInfo source) {
                if (source.getBatchType() == null) {
                    try {
                        source.load();
                    }
                    catch (ProblemException problemException) {}
                }
                return source.getBatchType();
            }
        };
    }

    private static IProperty<BatchConnectionInfo> createUpdateInterval() {
        return new AbstractProperty<BatchConnectionInfo>(Messages.getString("BatchPropertySource.propertyUpdateInterval"), null, false){

            public Object getValue(BatchConnectionInfo source) {
                if (source.getBatchType() == null) {
                    try {
                        source.load();
                    }
                    catch (ProblemException problemException) {}
                }
                return Integer.toString(source.getUpdateInterval());
            }
        };
    }
}

