/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.properties;

import eu.geclipse.batch.BatchQueueDescription;
import eu.geclipse.batch.ui.properties.Messages;
import eu.geclipse.ui.properties.AbstractProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IProperty;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchQueueDescriptionPropertySource
extends AbstractPropertySource<BatchQueueDescription> {
    private static List<IProperty<BatchQueueDescription>> staticProperties;

    public BatchQueueDescriptionPropertySource(BatchQueueDescription queueDescription) {
        super((Object)queueDescription);
    }

    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return BatchQueueDescriptionPropertySource.class;
    }

    protected List<IProperty<BatchQueueDescription>> getStaticProperties() {
        if (staticProperties == null) {
            staticProperties = BatchQueueDescriptionPropertySource.createProperties();
        }
        return staticProperties;
    }

    private static List<IProperty<BatchQueueDescription>> createProperties() {
        ArrayList<IProperty<BatchQueueDescription>> propertiesList = new ArrayList<IProperty<BatchQueueDescription>>(1);
        propertiesList.add(BatchQueueDescriptionPropertySource.createAllowedVOs());
        propertiesList.add(BatchQueueDescriptionPropertySource.createMaxWallTime());
        propertiesList.add(BatchQueueDescriptionPropertySource.createMaxCPUTime());
        propertiesList.add(BatchQueueDescriptionPropertySource.createQueueStatus());
        propertiesList.add(BatchQueueDescriptionPropertySource.createQueueType());
        propertiesList.add(BatchQueueDescriptionPropertySource.createQueueName());
        return propertiesList;
    }

    private static IProperty<BatchQueueDescription> createQueueName() {
        return new AbstractProperty<BatchQueueDescription>(Messages.getString("BatchQueueDescriptionPropertySource.propertyQueueName"), null, false){

            public Object getValue(BatchQueueDescription source) {
                if (source.getQueueName() == null) {
                    source.load(source.getResource().getFullPath().toString());
                }
                return source.getQueueName();
            }
        };
    }

    private static IProperty<BatchQueueDescription> createQueueType() {
        return new AbstractProperty<BatchQueueDescription>(Messages.getString("BatchQueueDescriptionPropertySource.propertyQueueType"), null, false){

            public Object getValue(BatchQueueDescription source) {
                if (source.getQueueType() == null) {
                    source.load(source.getResource().getFullPath().toString());
                }
                return source.getQueueType();
            }
        };
    }

    private static IProperty<BatchQueueDescription> createQueueStatus() {
        return new AbstractProperty<BatchQueueDescription>(Messages.getString("BatchQueueDescriptionPropertySource.propertyQueueStatus"), null, false){

            public Object getValue(BatchQueueDescription source) {
                if (source.getQueueStatus() == null) {
                    source.load(source.getResource().getFullPath().toString());
                }
                return source.getQueueStatus();
            }
        };
    }

    private static IProperty<BatchQueueDescription> createMaxCPUTime() {
        return new AbstractProperty<BatchQueueDescription>(Messages.getString("BatchQueueDescriptionPropertySource.propertyQueueCPUTime"), null, false){

            public Object getValue(BatchQueueDescription source) {
                if (source.getQueueMaxCPUTime() == null) {
                    source.load(source.getResource().getFullPath().toString());
                }
                return new Double(source.getQueueMaxCPUTimeValue());
            }
        };
    }

    private static IProperty<BatchQueueDescription> createMaxWallTime() {
        return new AbstractProperty<BatchQueueDescription>(Messages.getString("BatchQueueDescriptionPropertySource.propertyQueueWallTime"), null, false){

            public Object getValue(BatchQueueDescription source) {
                if (source.getQueueMaxWallTime() == null) {
                    source.load(source.getResource().getFullPath().toString());
                }
                return new Double(source.getQueueMaxCPUTimeValue());
            }
        };
    }

    private static IProperty<BatchQueueDescription> createAllowedVOs() {
        return new AbstractProperty<BatchQueueDescription>(Messages.getString("BatchQueueDescriptionPropertySource.propertyQueueVOs"), null, false){

            public Object getValue(BatchQueueDescription source) {
                if (source.getAllowedVirtualOrganizations().size() == 0) {
                    source.load(source.getResource().getFullPath().toString());
                }
                return source.getAllowedVirtualOrganizations();
            }
        };
    }
}

