/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.views;

import eu.geclipse.batch.IBatchJobInfo;
import eu.geclipse.batch.ui.dialogs.BatchJobInfoDialog;
import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.BatchJobManager;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.internal.model.ComputingElement;
import eu.geclipse.batch.ui.internal.model.Queue;
import eu.geclipse.batch.ui.internal.model.WorkerNode;
import eu.geclipse.batch.ui.internal.parts.BatchTreeEditPart;
import eu.geclipse.batch.ui.internal.parts.ComputingElementEditPart;
import eu.geclipse.batch.ui.internal.parts.ConnectionEditPart;
import eu.geclipse.batch.ui.internal.parts.DiagramEditPart;
import eu.geclipse.batch.ui.internal.parts.QueueEditPart;
import eu.geclipse.batch.ui.internal.parts.WorkerNodeEditPart;
import eu.geclipse.batch.ui.wizards.MoveJobWizard;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.comparators.TableColumnComparator;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.listeners.TableColumnListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchJobView
extends ViewPart
implements IContentChangeListener {
    protected Table jobTable;
    protected TableViewer jobList;
    protected BatchJobManager jobManager;
    private Action deleteAction;
    private Action moveAction;
    private Action refreshAction;
    private Action reRunAction;
    private Action holdAction;
    private Action releaseAction;

    public void createPartControl(Composite parent) {
        this.jobTable = new Table(parent, 65538);
        this.jobTable.setHeaderVisible(true);
        this.jobTable.setLinesVisible(true);
        this.jobList = new TableViewer(this.jobTable);
        this.jobList.setLabelProvider((IBaseLabelProvider)new JobLabelProvider());
        this.jobList.setContentProvider((IContentProvider)new JobContentProvider());
        TableColumnListener columnListener = new TableColumnListener(this.jobList);
        TableColumn idColumn = new TableColumn(this.jobTable, 0);
        idColumn.setText(Messages.getString("BatchJobView.JobId"));
        idColumn.setWidth(150);
        idColumn.setAlignment(16384);
        idColumn.addSelectionListener((SelectionListener)columnListener);
        TableColumn nameColumn = new TableColumn(this.jobTable, 0x1000000);
        nameColumn.setText(Messages.getString("BatchJobView.JobName"));
        nameColumn.setWidth(75);
        nameColumn.setAlignment(0x1000000);
        nameColumn.addSelectionListener((SelectionListener)columnListener);
        TableColumn queueColumn = new TableColumn(this.jobTable, 0x1000000);
        queueColumn.setText(Messages.getString("BatchJobView.Queue"));
        queueColumn.setWidth(150);
        queueColumn.setAlignment(0x1000000);
        queueColumn.addSelectionListener((SelectionListener)columnListener);
        TableColumn userColumn = new TableColumn(this.jobTable, 0x1000000);
        userColumn.setText(Messages.getString("BatchJobView.UserAccount"));
        userColumn.setWidth(150);
        userColumn.setAlignment(0x1000000);
        userColumn.addSelectionListener((SelectionListener)columnListener);
        TableColumn timeColumn = new TableColumn(this.jobTable, 0x1000000);
        timeColumn.setText(Messages.getString("BatchJobView.Time"));
        timeColumn.setWidth(75);
        timeColumn.setAlignment(0x1000000);
        timeColumn.addSelectionListener((SelectionListener)columnListener);
        TableColumn statusColumn = new TableColumn(this.jobTable, 0x1000000);
        statusColumn.setText(Messages.getString("BatchJobView.Status"));
        statusColumn.setWidth(75);
        statusColumn.setAlignment(0x1000000);
        statusColumn.addSelectionListener((SelectionListener)columnListener);
        this.jobTable.setSortColumn(idColumn);
        this.jobTable.setSortDirection(128);
        this.jobList.setComparator((ViewerComparator)new TableColumnComparator(idColumn));
        this.jobList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                BatchJobView.this.showSelectedJobInfo();
            }
        });
        this.jobList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BatchJobView.this.updateActions();
            }
        });
        this.jobTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    BatchJobView.this.removeSelectedJobs();
                }
            }
        });
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (selection instanceof StructuredSelection) {
                    StructuredSelection ss = (StructuredSelection)selection;
                    List sList = ss.toList();
                    for (Object obj : sList) {
                        if (obj instanceof QueueEditPart) {
                            QueueEditPart qEdit = (QueueEditPart)obj;
                            Queue q = (Queue)qEdit.getModel();
                            if (BatchJobView.this.jobManager == null) {
                                BatchJobView.this.jobManager = q.getJobManager();
                                BatchJobView.this.jobManager.addContentChangeListener(BatchJobView.this);
                            }
                            BatchJobView.this.jobList.setInput((Object)q);
                            continue;
                        }
                        if (obj instanceof ComputingElementEditPart) {
                            ComputingElementEditPart ceEdit = (ComputingElementEditPart)obj;
                            ComputingElement ce = (ComputingElement)ceEdit.getModel();
                            if (BatchJobView.this.jobManager == null) {
                                BatchJobView.this.jobManager = ce.getJobManager();
                                BatchJobView.this.jobManager.addContentChangeListener(BatchJobView.this);
                            }
                            BatchJobView.this.jobList.setInput((Object)ce);
                            continue;
                        }
                        if (obj instanceof WorkerNodeEditPart) {
                            WorkerNodeEditPart wnEdit = (WorkerNodeEditPart)obj;
                            WorkerNode wn = (WorkerNode)wnEdit.getModel();
                            if (BatchJobView.this.jobManager == null) {
                                BatchJobView.this.jobManager = wn.getJobManager();
                                BatchJobView.this.jobManager.addContentChangeListener(BatchJobView.this);
                            }
                            BatchJobView.this.jobList.setInput((Object)wn);
                            continue;
                        }
                        if (obj instanceof DiagramEditPart || obj instanceof ConnectionEditPart) {
                            if (BatchJobView.this.jobManager != null) {
                                BatchJobView.this.jobManager.removeContentChangeListener(BatchJobView.this);
                                BatchJobView.this.jobManager = null;
                            }
                            BatchJobView.this.jobList.setInput(obj);
                            continue;
                        }
                        if (!(obj instanceof BatchTreeEditPart)) continue;
                        BatchTreeEditPart treeEdit = (BatchTreeEditPart)obj;
                        Object obj2 = treeEdit.getModel();
                        if (obj2 instanceof ComputingElement) {
                            ComputingElement ce = (ComputingElement)obj2;
                            if (BatchJobView.this.jobManager == null) {
                                BatchJobView.this.jobManager = ce.getJobManager();
                                BatchJobView.this.jobManager.addContentChangeListener(BatchJobView.this);
                            }
                            BatchJobView.this.jobList.setInput((Object)ce);
                            continue;
                        }
                        if (obj2 instanceof Queue) {
                            Queue q = (Queue)obj2;
                            if (BatchJobView.this.jobManager == null) {
                                BatchJobView.this.jobManager = q.getJobManager();
                                BatchJobView.this.jobManager.addContentChangeListener(BatchJobView.this);
                            }
                            BatchJobView.this.jobList.setInput((Object)q);
                            continue;
                        }
                        if (!(obj2 instanceof WorkerNode)) continue;
                        WorkerNode wn = (WorkerNode)obj2;
                        if (BatchJobView.this.jobManager == null) {
                            BatchJobView.this.jobManager = wn.getJobManager();
                            BatchJobView.this.jobManager.addContentChangeListener(BatchJobView.this);
                        }
                        BatchJobView.this.jobList.setInput((Object)wn);
                    }
                }
            }
        });
        this.createActions();
        this.createToolbar();
        this.createContextMenu();
    }

    public void dispose() {
        if (this.jobManager != null) {
            this.jobManager.removeContentChangeListener(this);
            this.jobManager = null;
        }
    }

    public void contentChanged(IContentChangeNotifier source) {
        this.getSite().getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                BatchJobView.this.jobList.refresh();
                BatchJobView.this.updateActions();
            }
        });
    }

    public void setFocus() {
        this.jobTable.setFocus();
    }

    public IBatchJobInfo getSelectedJob() {
        IBatchJobInfo resultJob = null;
        IStructuredSelection selection = (IStructuredSelection)this.jobList.getSelection();
        Object o = selection.getFirstElement();
        if (o instanceof IBatchJobInfo) {
            resultJob = (IBatchJobInfo)o;
        }
        return resultJob;
    }

    public List<IBatchJobInfo> getSelectedJobs() {
        IStructuredSelection selection = (IStructuredSelection)this.jobList.getSelection();
        List selectionList = selection.toList();
        ArrayList<IBatchJobInfo> result = new ArrayList<IBatchJobInfo>();
        for (Object element : selectionList) {
            if (!(element instanceof IBatchJobInfo)) continue;
            IBatchJobInfo token = (IBatchJobInfo)element;
            result.add(token);
        }
        return result;
    }

    protected void removeSelectedJobs() {
        List<IBatchJobInfo> jobs = this.getSelectedJobs();
        if (!jobs.isEmpty()) {
            boolean confirm;
            boolean bl = confirm = !MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)Messages.getString("BatchJobView.confirm_delete_title"), (String)Messages.getString("BatchJobView.confirm_delete_message"));
            if (!confirm) {
                for (IBatchJobInfo job : jobs) {
                    try {
                        if (this.jobManager == null) continue;
                        this.jobManager.deleteJob(job);
                        this.jobList.refresh();
                    }
                    catch (ProblemException excp) {
                        ProblemDialog.openProblem((Shell)this.getSite().getShell(), (String)Messages.getString("BatchJobView.error_delete_title"), (String)Messages.getString("BatchJobView.error_delete_message"), (Throwable)excp);
                    }
                }
                this.updateActions();
            }
        }
    }

    protected void holdSelectedJobs() {
        List<IBatchJobInfo> jobs = this.getSelectedJobs();
        if (!jobs.isEmpty()) {
            for (IBatchJobInfo job : jobs) {
                try {
                    if (this.jobManager != null) {
                        this.jobManager.holdJob(job);
                        this.jobList.refresh();
                    }
                }
                catch (ProblemException excp) {
                    ProblemDialog.openProblem((Shell)this.getSite().getShell(), (String)Messages.getString("BatchJobView.error_hold_title"), (String)Messages.getString("BatchJobView.error_hold_message"), (Throwable)excp);
                }
                this.updateActions();
            }
        }
    }

    protected void releaseSelectedJobs() {
        List<IBatchJobInfo> jobs = this.getSelectedJobs();
        if (!jobs.isEmpty()) {
            for (IBatchJobInfo job : jobs) {
                try {
                    if (this.jobManager != null) {
                        this.jobManager.releaseJob(job);
                        this.jobList.refresh();
                    }
                }
                catch (ProblemException excp) {
                    ProblemDialog.openProblem((Shell)this.getSite().getShell(), (String)Messages.getString("BatchJobView.error_release_title"), (String)Messages.getString("BatchJobView.error_release_message"), (Throwable)excp);
                }
                this.updateActions();
            }
        }
    }

    protected void moveSelectedJobs() {
        List<IBatchJobInfo> jobs = this.getSelectedJobs();
        if (!jobs.isEmpty() && this.jobManager != null) {
            MoveJobWizard wizard = new MoveJobWizard(this.jobManager, jobs);
            wizard.init(this.getSite().getWorkbenchWindow().getWorkbench(), null);
            WizardDialog dialog = new WizardDialog(this.getSite().getShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
        }
    }

    protected void showSelectedJobInfo() {
        IBatchJobInfo job = this.getSelectedJob();
        if (job != null) {
            BatchJobInfoDialog infoDialog = new BatchJobInfoDialog(job, this.getSite().getShell());
            infoDialog.open();
        }
    }

    protected void reRunJobs() {
        List<IBatchJobInfo> jobs = this.getSelectedJobs();
        if (!jobs.isEmpty()) {
            for (IBatchJobInfo job : jobs) {
                try {
                    if (this.jobManager != null) {
                        this.jobManager.reRunJob(job);
                    }
                }
                catch (ProblemException excp) {
                    ProblemDialog.openProblem((Shell)this.getSite().getShell(), (String)Messages.getString("BatchJobView.error_rerun_title"), (String)Messages.getString("BatchJobView.error_rerun_message"), (Throwable)excp);
                }
                this.updateActions();
            }
        }
    }

    protected void updateActions() {
        List<IBatchJobInfo> jobs = this.getSelectedJobs();
        boolean selected = jobs.size() > 0;
        boolean deletable = true;
        boolean movable = true;
        boolean holdable = true;
        boolean releasable = true;
        boolean reRunnable = true;
        for (IBatchJobInfo job : jobs) {
            if (!job.isDeletable()) {
                deletable = false;
            }
            if (!job.isMovable()) {
                movable = false;
            }
            if (!job.isHoldable()) {
                holdable = false;
            }
            if (!job.isReleasable()) {
                releasable = false;
            }
            if (job.isReRunnable()) continue;
            reRunnable = false;
        }
        this.deleteAction.setEnabled(selected && deletable);
        this.moveAction.setEnabled(selected && movable);
        this.holdAction.setEnabled(selected && holdable);
        this.releaseAction.setEnabled(selected && releasable);
        this.reRunAction.setEnabled(selected && reRunnable);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        if (this.deleteAction.isEnabled()) {
            mgr.add((IAction)this.deleteAction);
        }
        if (this.moveAction.isEnabled()) {
            mgr.add((IAction)this.moveAction);
        }
        if (this.holdAction.isEnabled()) {
            mgr.add((IAction)this.holdAction);
        }
        if (this.releaseAction.isEnabled()) {
            mgr.add((IAction)this.releaseAction);
        }
        if (this.reRunAction.isEnabled()) {
            mgr.add((IAction)this.reRunAction);
        }
        if (this.refreshAction.isEnabled()) {
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)this.refreshAction);
        }
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    private void createActions() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ImageRegistry imgReg = Activator.getDefault().getImageRegistry();
        ImageDescriptor deleteImage = sharedImages.getImageDescriptor("IMG_TOOL_DELETE");
        Image image = imgReg.get("refresh");
        ImageDescriptor refreshImage = ImageDescriptor.createFromImage((Image)image);
        image = imgReg.get("moveJob");
        ImageDescriptor moveImage = ImageDescriptor.createFromImage((Image)image);
        image = imgReg.get("holdJob");
        ImageDescriptor holdImage = ImageDescriptor.createFromImage((Image)image);
        image = imgReg.get("releaseJob");
        ImageDescriptor releaseImage = ImageDescriptor.createFromImage((Image)image);
        image = imgReg.get("busyArrow2Icon");
        ImageDescriptor reRunImage = ImageDescriptor.createFromImage((Image)image);
        this.refreshAction = new Action(){

            public void run() {
                BatchJobView.this.jobList.refresh();
            }
        };
        this.refreshAction.setText(Messages.getString("BatchJobView.refresh_text"));
        this.refreshAction.setToolTipText(Messages.getString("BatchJobView.refresh_tooltip"));
        this.refreshAction.setImageDescriptor(refreshImage);
        this.deleteAction = new Action(){

            public void run() {
                BatchJobView.this.removeSelectedJobs();
            }
        };
        this.deleteAction.setText(Messages.getString("BatchJobView.delete_text"));
        this.deleteAction.setToolTipText(Messages.getString("BatchJobView.delete_tooltip"));
        this.deleteAction.setImageDescriptor(deleteImage);
        this.moveAction = new Action(){

            public void run() {
                BatchJobView.this.moveSelectedJobs();
            }
        };
        this.moveAction.setText(Messages.getString("BatchJobView.move_text"));
        this.moveAction.setToolTipText(Messages.getString("BatchJobView.move_tooltip"));
        this.moveAction.setImageDescriptor(moveImage);
        this.holdAction = new Action(){

            public void run() {
                BatchJobView.this.holdSelectedJobs();
            }
        };
        this.holdAction.setText(Messages.getString("BatchJobView.hold_text"));
        this.holdAction.setToolTipText(Messages.getString("BatchJobView.hold_tooltip"));
        this.holdAction.setImageDescriptor(holdImage);
        this.releaseAction = new Action(){

            public void run() {
                BatchJobView.this.releaseSelectedJobs();
            }
        };
        this.releaseAction.setText(Messages.getString("BatchJobView.release_text"));
        this.releaseAction.setToolTipText(Messages.getString("BatchJobView.release_tooltip"));
        this.releaseAction.setImageDescriptor(releaseImage);
        this.reRunAction = new Action(){

            public void run() {
                BatchJobView.this.reRunJobs();
            }
        };
        this.reRunAction.setText(Messages.getString("BatchJobView.reRun_text"));
        this.reRunAction.setToolTipText(Messages.getString("BatchJobView.reRun_tooltip"));
        this.reRunAction.setImageDescriptor(reRunImage);
        this.updateActions();
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.deleteAction);
        mgr.add((IAction)this.moveAction);
        mgr.add((IAction)this.holdAction);
        mgr.add((IAction)this.releaseAction);
        mgr.add((IAction)this.reRunAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.refreshAction);
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                BatchJobView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = manager.createContextMenu((Control)this.jobTable);
        this.jobTable.setMenu(menu);
        this.getSite().registerContextMenu(manager, this.getSite().getSelectionProvider());
    }

    class JobContentProvider
    implements IStructuredContentProvider {
        JobContentProvider() {
        }

        public Object[] getElements(Object input) {
            Object[] resultArray = null;
            if (input instanceof Queue) {
                Queue q = (Queue)input;
                List<IBatchJobInfo> jobs = q.getJobManager().getJobs(q.getQueneName());
                IBatchJobInfo[] jobArray = new IBatchJobInfo[jobs.size()];
                resultArray = jobs.toArray(jobArray);
            } else if (input instanceof ComputingElement) {
                ComputingElement ce = (ComputingElement)input;
                List<IBatchJobInfo> jobs = ce.getJobManager().getJobs();
                IBatchJobInfo[] jobArray = new IBatchJobInfo[jobs.size()];
                resultArray = jobs.toArray(jobArray);
            } else if (input instanceof WorkerNode) {
                WorkerNode wn = (WorkerNode)input;
                List<String> jobIds = wn.getJobIds();
                List<IBatchJobInfo> jobs = wn.getJobManager().getJobs(jobIds);
                IBatchJobInfo[] jobArray = new IBatchJobInfo[jobs.size()];
                resultArray = jobs.toArray(jobArray);
            } else if (input instanceof DiagramEditPart || input instanceof ConnectionEditPart) {
                IBatchJobInfo[] jobArray = new IBatchJobInfo[]{};
                resultArray = jobArray;
            }
            return resultArray;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    class JobLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider {
        private Font boldFont;

        public JobLabelProvider() {
            Font font = JFaceResources.getDefaultFont();
            Device device = font.getDevice();
            FontData[] fontData = font.getFontData();
            int i = 0;
            while (i < fontData.length) {
                int style = fontData[i].getStyle();
                fontData[i].setStyle(style | 1);
                ++i;
            }
            this.boldFont = new Font(device, fontData);
        }

        public void dispose() {
            super.dispose();
            this.boldFont.dispose();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String columnText = element.toString();
            if (element instanceof IBatchJobInfo) {
                IBatchJobInfo job = (IBatchJobInfo)element;
                switch (columnIndex) {
                    case 0: {
                        columnText = job.getJobId();
                        break;
                    }
                    case 1: {
                        columnText = job.getJobName();
                        break;
                    }
                    case 2: {
                        columnText = job.getQueueName();
                        break;
                    }
                    case 3: {
                        columnText = job.getUserAccount();
                        break;
                    }
                    case 4: {
                        columnText = job.getTimeUse();
                        break;
                    }
                    case 5: {
                        columnText = job.getStatus().toString();
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            return columnText;
        }

        public Font getFont(Object element, int columnIndex) {
            IBatchJobInfo job;
            Font resultFont = null;
            if (element instanceof IBatchJobInfo && (job = (IBatchJobInfo)element).getStatus() == IBatchJobInfo.JobState.R) {
                resultFont = this.boldFont;
            }
            return resultFont;
        }
    }
}

