/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.wizards;

import eu.geclipse.batch.IBatchService;
import eu.geclipse.batch.IQueueInfo;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.wizards.AddQueueWizardOptionalPage;
import eu.geclipse.batch.ui.wizards.AddQueueWizardRequiredPage;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class AddQueueWizard
extends Wizard
implements INewWizard {
    private IBatchService batchWrapper;
    private AddQueueWizardRequiredPage requiredPage;
    private AddQueueWizardOptionalPage optionalPage;
    private IWizardPage currentPage;

    public AddQueueWizard(IBatchService batchWrapper) {
        this.setNeedsProgressMonitor(true);
        this.batchWrapper = batchWrapper;
    }

    public boolean performFinish() {
        if (this.getContainer().getCurrentPage() == this.requiredPage) {
            this.createQueue();
        } else if (this.getContainer().getCurrentPage() == this.optionalPage) {
            this.createAdvQueue();
        }
        return true;
    }

    public boolean canFinish() {
        boolean result = false;
        this.currentPage = this.getContainer().getCurrentPage();
        if (this.currentPage.isPageComplete()) {
            result = super.canFinish();
        }
        return result;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.requiredPage = new AddQueueWizardRequiredPage();
        this.optionalPage = new AddQueueWizardOptionalPage();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.requiredPage);
        this.addPage((IWizardPage)this.optionalPage);
    }

    public String getWindowTitle() {
        return Messages.getString("AddQueueWizard.Title");
    }

    public void createQueue() {
        String str = this.requiredPage.typeCombo.getText();
        IQueueInfo.QueueType type = str.equals(Messages.getString("AddQueueRequiredPage.Type_Execution")) ? IQueueInfo.QueueType.execution : IQueueInfo.QueueType.route;
        try {
            this.batchWrapper.createQueue(this.requiredPage.nameText.getText(), type, this.requiredPage.enabledButton.getSelection(), (double)this.requiredPage.getTimeCPU(), (double)this.requiredPage.getTimeWall(), this.requiredPage.getVONames());
        }
        catch (ProblemException excp) {
            ProblemDialog.openProblem((Shell)this.getShell(), (String)Messages.getString("AddQueueWizard.error_manipulate_title"), (String)Messages.getString("AddQueueWizard.error_manipulate_message"), (Throwable)excp);
        }
    }

    public void createAdvQueue() {
        String str = this.requiredPage.typeCombo.getText();
        IQueueInfo.QueueType type = str.equals(Messages.getString("AddQueueRequiredPage.Type_Execution")) ? IQueueInfo.QueueType.execution : IQueueInfo.QueueType.route;
        try {
            this.batchWrapper.createQueue(this.requiredPage.nameText.getText(), this.optionalPage.getPriority(), type, this.requiredPage.enabledButton.getSelection(), true, this.optionalPage.getMaxRun(), (double)this.requiredPage.getTimeCPU(), (double)this.requiredPage.getTimeWall(), this.optionalPage.getMaxQueue(), this.optionalPage.getAssignedResources(), this.requiredPage.getVONames());
        }
        catch (ProblemException excp) {
            ProblemDialog.openProblem((Shell)this.getShell(), (String)Messages.getString("AddQueueWizard.error_manipulate_title"), (String)Messages.getString("AddQueueWizard.error_manipulate_message"), (Throwable)excp);
        }
    }
}

