/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.wizards;

import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IGridSiteConfig;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class BatchLocationWizardPage
extends WizardNewFileCreationPage {
    private static final String DEFAULT_EXTENSION = ".batch";
    private IStructuredSelection iniSelection;

    public BatchLocationWizardPage(IStructuredSelection selection) {
        super("newBatchServiceLocationPage", selection);
        this.setTitle(Messages.getString("BatchLocationWizardPage.WindowTitle"));
        this.setDescription(Messages.getString("BatchLocationWizardPage.Description"));
        this.iniSelection = selection;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName(String.valueOf(Messages.getString("BatchLocationWizardPage.DefaultFileName")) + DEFAULT_EXTENSION);
        this.setPageComplete(this.validatePage());
    }

    protected IFile createFile() {
        return this.createNewFile();
    }

    private boolean validateFilename() {
        boolean ret = false;
        if (this.getFileName() != null && this.getFileName().endsWith(DEFAULT_EXTENSION)) {
            ret = true;
        } else {
            this.setErrorMessage(String.valueOf(Messages.getString("BatchLocationWizardPage.Error.FileName")) + DEFAULT_EXTENSION);
        }
        return ret;
    }

    protected boolean validatePage() {
        return super.validatePage() && this.validateFilename();
    }

    protected void initialPopulateContainerNameField() {
        Object obj = this.iniSelection.getFirstElement();
        if (obj instanceof IGridContainer) {
            IPath ePath;
            IPath cPath;
            IGridContainer descriptions;
            IGridElement element = (IGridElement)obj;
            IGridProject project = element.getProject();
            if (project != null && (descriptions = project.getProjectFolder(IGridSiteConfig.class)) != null && !(cPath = descriptions.getPath()).isPrefixOf(ePath = element.getPath())) {
                element = descriptions;
            }
            super.setContainerFullPath(element.getPath());
        } else {
            super.initialPopulateContainerNameField();
        }
    }
}

