/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.wizards;

import eu.geclipse.batch.BatchQueueDescription;
import eu.geclipse.batch.Extensions;
import eu.geclipse.batch.IBatchService;
import eu.geclipse.batch.IGridBatchQueueDescription;
import eu.geclipse.batch.ui.BatchServiceManager;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.internal.providers.BatchServiceTreeContentProvider;
import eu.geclipse.batch.ui.internal.providers.BatchServiceTreeLabelProvider;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchServiceSelectionWizardPage
extends WizardPage {
    protected List<IGridBatchQueueDescription> queueDescList;
    protected CheckboxTreeViewer treeViewer;
    private Composite mainComp;
    private int servicesCount = BatchServiceManager.getManager().getServiceCount();

    protected BatchServiceSelectionWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString("BatchServiceSelectionDialog.title"));
        this.setDescription(Messages.getString("BatchServiceSelectionDialog.Descr"));
    }

    public void createControl(Composite parent) {
        this.mainComp = new Composite(parent, 0);
        this.mainComp.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 1;
        gd.widthHint = 300;
        this.treeViewer = new CheckboxTreeViewer(this.mainComp);
        this.treeViewer.setContentProvider((IContentProvider)new BatchServiceTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new BatchServiceTreeLabelProvider());
        if (this.servicesCount > 0) {
            this.treeViewer.setInput(this.initialViewerInput());
        }
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof String) {
                    if (event.getChecked()) {
                        BatchServiceSelectionWizardPage.this.treeViewer.setSubtreeChecked(element, true);
                    } else {
                        BatchServiceSelectionWizardPage.this.treeViewer.setSubtreeChecked(element, false);
                    }
                }
                BatchServiceSelectionWizardPage.this.updateUI();
            }
        });
        this.treeViewer.getControl().setLayoutData((Object)gd);
        this.treeViewer.expandAll();
        this.setControl((Control)this.mainComp);
    }

    private List<String> initialViewerInput() {
        List registeredServices = Extensions.getRegisteredBatchServiceNames();
        return registeredServices;
    }

    public void setInitialData(List<IGridBatchQueueDescription> list) {
        this.queueDescList = list;
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.isServiceSelectionValid();
    }

    private boolean isServiceSelectionValid() {
        boolean ret = false;
        if (this.treeViewer.getCheckedElements().length != 0) {
            ret = true;
        }
        return ret;
    }

    protected void updateUI() {
        this.setPageComplete(this.isServiceSelectionValid());
    }

    public boolean finish() {
        boolean result = true;
        if (this.isServiceSelectionValid()) {
            final Object[] checkedElements = this.treeViewer.getCheckedElements();
            IWizardContainer container = this.getContainer();
            try {
                container.run(true, true, new IRunnableWithProgress(){

                    protected void testCanceled(IProgressMonitor monitor) {
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IBatchService batchWrapper = null;
                        BatchQueueDescription batchQueue = null;
                        SubMonitor betterMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)checkedElements.length);
                        Object[] objectArray = checkedElements;
                        int n = checkedElements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object element = objectArray[n2];
                            this.testCanceled((IProgressMonitor)betterMonitor);
                            if (element instanceof IBatchService) {
                                betterMonitor.setTaskName(String.format(Messages.getString("BatchServiceSelectionDialog.task.Service"), ((IBatchService)element).getName()));
                                batchWrapper = (IBatchService)element;
                                this.testCanceled((IProgressMonitor)betterMonitor);
                                for (IGridBatchQueueDescription queueDescription : BatchServiceSelectionWizardPage.this.queueDescList) {
                                    batchQueue = (BatchQueueDescription)queueDescription;
                                    batchQueue.load(queueDescription.getResource().getFullPath().toString());
                                    try {
                                        betterMonitor.setTaskName(String.format(Messages.getString("BatchServiceSelectionDialog.task.Configuration"), queueDescription.getResource().getName()));
                                        batchWrapper.createQueue(batchQueue.getRoot());
                                        this.testCanceled((IProgressMonitor)betterMonitor);
                                    }
                                    catch (ProblemException e) {
                                        ProblemDialog.openProblem((Shell)BatchServiceSelectionWizardPage.this.getShell(), (String)Messages.getString("AddQueueWizard.error_manipulate_title"), (String)Messages.getString("AddQueueWizard.error_manipulate_message"), (Throwable)e);
                                    }
                                }
                            }
                            ++n2;
                        }
                        betterMonitor.worked(1);
                    }
                });
            }
            catch (InvocationTargetException itExc) {
                ProblemDialog.openProblem((Shell)this.getShell(), (String)Messages.getString("BatchServiceSelectionDialog.QueueConfigurationFailed"), (String)Messages.getString("BatchServiceSelectionDialog.QueueConfigurationFailed"), (Throwable)itExc.getCause());
                result = false;
            }
            catch (InterruptedException intExc) {
                ProblemDialog.openProblem((Shell)this.getShell(), (String)Messages.getString("BatchServiceSelectionDialog.QueueConfigurationInterupted"), (String)Messages.getString("BatchServiceSelectionDialog.QueueConfigurationInterupted"), (Throwable)intExc);
                result = false;
            }
        }
        return result;
    }
}

