/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.wizards;

import eu.geclipse.batch.IBatchJobInfo;
import eu.geclipse.batch.ui.internal.BatchJobManager;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.wizards.MoveJobWizardPage;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveJobWizard
extends Wizard
implements INewWizard {
    private BatchJobManager jobManager;
    private List<IBatchJobInfo> jobs;
    private MoveJobWizardPage page;
    private IWizardPage currentPage;
    private IStructuredSelection selection;

    public MoveJobWizard(BatchJobManager manager, List<IBatchJobInfo> jobs) {
        this.setNeedsProgressMonitor(true);
        this.jobManager = manager;
        this.jobs = jobs;
    }

    public boolean performFinish() {
        this.moveJob();
        return true;
    }

    public boolean canFinish() {
        boolean result = false;
        this.currentPage = this.getContainer().getCurrentPage();
        if (this.currentPage.isPageComplete()) {
            result = super.canFinish();
        }
        return result;
    }

    public void init(IWorkbench workbench, IStructuredSelection sel) {
        this.selection = sel;
        this.page = new MoveJobWizardPage();
    }

    public IGridProject getGridProject() {
        IGridProject result = null;
        if (this.selection != null) {
            IGridElement selected = (IGridElement)this.selection.getFirstElement();
            result = selected.getProject();
        }
        return result;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public String getWindowTitle() {
        return Messages.getString("MoveJobWizard.Title");
    }

    public void moveJob() {
        String ceName = this.page.getComputingElementName();
        String qName = this.page.getQueueName();
        if (ceName.length() == 0) {
            ceName = null;
        }
        if (qName.length() == 0) {
            qName = null;
        }
        for (IBatchJobInfo batchJob : this.jobs) {
            try {
                this.jobManager.moveJob(batchJob, qName, ceName);
            }
            catch (ProblemException excp) {
                ProblemDialog.openProblem((Shell)this.getShell(), (String)Messages.getString("MoveJobWizard.error_manipulate_title"), (String)Messages.getString("MoveJobWizard.error_manipulate_message"), (Throwable)excp);
            }
        }
    }
}

