/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.wizards;

import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IGridSiteConfig;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class QueueLocationWizard
extends WizardNewFileCreationPage {
    private static final String DEFAULT_EXTENSION = ".qdl";
    private IStructuredSelection iniSelection;

    public QueueLocationWizard(IStructuredSelection selection) {
        super(Messages.getString("NewQueueWizard.FirstPage_Name"), selection);
        this.setTitle(Messages.getString("NewQueueWizard.FirstPage_Title"));
        this.setDescription(Messages.getString("NewQueueWizard.FirstPage_Description"));
        this.iniSelection = selection;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName(String.valueOf(Messages.getString("NewQueueWizard.Default_New_Filename")) + DEFAULT_EXTENSION);
        this.setPageComplete(this.validatePage());
    }

    protected IFile createFile() {
        return this.createNewFile();
    }

    private boolean validateFilename() {
        boolean ret = false;
        if (this.getFileName() != null && this.getFileName().endsWith(DEFAULT_EXTENSION)) {
            ret = true;
        } else {
            this.setErrorMessage(String.valueOf(Messages.getString("NewQueueWizard.Default_New_Filename")) + DEFAULT_EXTENSION);
        }
        return ret;
    }

    protected boolean validatePage() {
        return super.validatePage() && this.validateFilename();
    }

    protected void initialPopulateContainerNameField() {
        Object obj = this.iniSelection.getFirstElement();
        if (obj instanceof IGridContainer) {
            IPath ePath;
            IPath cPath;
            IGridContainer descriptions;
            IGridElement element = (IGridElement)obj;
            IGridProject project = element.getProject();
            if (project != null && (descriptions = project.getProjectFolder(IGridSiteConfig.class)) != null && !(cPath = descriptions.getPath()).isPrefixOf(ePath = element.getPath())) {
                element = descriptions;
            }
            super.setContainerFullPath(element.getPath());
        } else {
            super.initialPopulateContainerNameField();
        }
    }
}

