/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch;

import eu.geclipse.batch.IBatchJobInfo;
import eu.geclipse.batch.IBatchService;
import eu.geclipse.core.reporting.ProblemException;

public class BatchJobInfo
implements IBatchJobInfo {
    private String jobId;
    private String jobName;
    private String userAccount;
    private String timeUse;
    private IBatchJobInfo.JobState status;
    private String queueName;
    private IBatchService batchWrapper;

    public BatchJobInfo(String jobId, String jobName, String userAccount, String timeUse, IBatchJobInfo.JobState status, String queueName, IBatchService batchWrapper) {
        this.jobId = jobId;
        this.jobName = jobName;
        this.userAccount = userAccount;
        this.timeUse = timeUse;
        this.status = status;
        this.queueName = queueName;
        this.batchWrapper = batchWrapper;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public IBatchJobInfo.JobState getStatus() {
        return this.status;
    }

    public void setStatus(IBatchJobInfo.JobState status) {
        this.status = status;
    }

    public String getTimeUse() {
        return this.timeUse;
    }

    public void setTimeUse(String timeUse) {
        this.timeUse = timeUse;
    }

    public String getUserAccount() {
        return this.userAccount;
    }

    public void setUserAccount(String userAccount) {
        this.userAccount = userAccount;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public boolean isDeletable() {
        return this.batchWrapper != null;
    }

    public boolean isMovable() {
        return this.batchWrapper != null && (IBatchJobInfo.JobState.Q == this.status || IBatchJobInfo.JobState.H == this.status);
    }

    public boolean isHoldable() {
        return this.batchWrapper != null && IBatchJobInfo.JobState.Q == this.status;
    }

    public boolean isReleasable() {
        return this.batchWrapper != null && IBatchJobInfo.JobState.H == this.status;
    }

    public boolean isReRunnable() {
        return this.batchWrapper != null && IBatchJobInfo.JobState.R == this.status;
    }

    public void deleteJob() throws ProblemException {
        if (this.isDeletable()) {
            this.batchWrapper.delJob(this.jobId);
        }
    }

    public void moveJob(String destQueue, String destServer) throws ProblemException {
        if (this.isMovable() && (destQueue != null || destServer != null)) {
            this.batchWrapper.moveJob(this.jobId, destQueue, destServer);
        }
    }

    public void holdJob() throws ProblemException {
        if (this.isHoldable()) {
            this.batchWrapper.holdJob(this.jobId);
        }
    }

    public void releaseJob() throws ProblemException {
        if (this.isReleasable()) {
            this.batchWrapper.releaseJob(this.jobId);
        }
    }

    public void reRunJob() throws ProblemException {
        if (this.isReRunnable()) {
            this.batchWrapper.reRunJob(this.jobId);
        }
    }

    public String getServiceTypeName() {
        String type = null;
        if (this.batchWrapper != null) {
            type = this.batchWrapper.getDescription().getServiceTypeName();
        }
        return type;
    }
}

