/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch;

import eu.geclipse.batch.IGridBatchQueueDescription;
import eu.geclipse.batch.internal.Activator;
import eu.geclipse.batch.model.qdl.AllowedVirtualOrganizationsType;
import eu.geclipse.batch.model.qdl.DocumentRoot;
import eu.geclipse.batch.model.qdl.QdlFactory;
import eu.geclipse.batch.model.qdl.QdlPackage;
import eu.geclipse.batch.model.qdl.QueueStatusEnumeration;
import eu.geclipse.batch.model.qdl.QueueType;
import eu.geclipse.batch.model.qdl.QueueTypeEnumeration;
import eu.geclipse.batch.model.qdl.RangeValueType;
import eu.geclipse.batch.model.qdl.util.QdlResourceFactoryImpl;
import eu.geclipse.core.model.impl.ResourceGridContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchQueueDescription
extends ResourceGridContainer
implements IGridBatchQueueDescription {
    protected DocumentRoot documentRoot = null;
    protected QueueType queueType = null;
    protected AllowedVirtualOrganizationsType allowedVOs = null;
    private Resource resourceT = null;

    public BatchQueueDescription(IFile file) {
        super((IResource)file);
        this.createRoot();
    }

    @Override
    public Collection<String> getAllowedVirtualOrganizations() {
        EList result = new ArrayList();
        if (this.allowedVOs != null) {
            result = this.allowedVOs.getVOName();
        }
        return result;
    }

    @Override
    public String getQueueName() {
        return this.queueType.getQueueName();
    }

    @Override
    public String getQueueStatus() {
        String result = null;
        result = this.queueType.getQueueStatus() == QueueStatusEnumeration.ENABLED ? "ENABLED" : "DISABLED";
        return result;
    }

    @Override
    public String getQueueType() {
        String result = null;
        result = this.queueType.getQueueType() == QueueTypeEnumeration.EXECUTION ? "EXECUTION" : "ROUTE";
        return result;
    }

    public RangeValueType getQueueMaxCPUTime() {
        return this.queueType.getCPUTimeLimit();
    }

    public RangeValueType getQueueMaxWallTime() {
        return this.queueType.getWallTimeLimit();
    }

    public double getQueueMaxCPUTimeValue() {
        double result = -1.0;
        if (this.queueType.getCPUTimeLimit() != null) {
            result = this.queueType.getCPUTimeLimit().getUpperBoundedRange().getValue();
        }
        return result;
    }

    public double getQueueMaxWallTimeValue() {
        double result = -1.0;
        if (this.queueType.getWallTimeLimit() != null) {
            result = this.queueType.getWallTimeLimit().getUpperBoundedRange().getValue();
        }
        return result;
    }

    public void enableQueue(boolean status) {
        if (status) {
            this.queueType.setQueueStatus(QueueStatusEnumeration.ENABLED);
        } else {
            this.queueType.setQueueStatus(QueueStatusEnumeration.DISABLED);
        }
    }

    public void startQueue(boolean value) {
        this.queueType.setQueueStarted(value);
    }

    public void queueType(QueueTypeEnumeration enumeration) {
        this.queueType.setQueueType(enumeration);
    }

    public void setAllowedVirtualOrganizations(Collection<String> collection) {
        this.allowedVOs = QdlFactory.eINSTANCE.createAllowedVirtualOrganizationsType();
        this.allowedVOs.getVOName().addAll(collection);
        this.queueType.setAllowedVirtualOrganizations(this.allowedVOs);
    }

    public void setQueueName(String queueName) {
        this.queueType.setQueueName(queueName);
    }

    public void setRoot(DocumentRoot root) {
        this.documentRoot = root;
        if (root.getQueue() != null) {
            this.queueType = root.getQueue();
        }
    }

    public DocumentRoot getRoot() {
        return this.documentRoot;
    }

    public void createRoot() {
        this.documentRoot = QdlFactory.eINSTANCE.createDocumentRoot();
        this.queueType = QdlFactory.eINSTANCE.createQueueType();
        this.documentRoot.setQueue(this.queueType);
    }

    public void loadModel(IFile file) {
        String filePath = file.getFullPath().toString();
        URI uri = URI.createPlatformResourceURI((String)filePath, (boolean)false);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resourceA = resourceSet.createResource(uri);
        XMLMapImpl xmlmap = new XMLMapImpl();
        xmlmap.setNoNamespacePackage((EPackage)QdlPackage.eINSTANCE);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XML_MAP", xmlmap);
        options.put("ENCODING", "UTF-8");
        try {
            resourceA.load(options);
            this.documentRoot = (DocumentRoot)resourceA.getContents().get(0);
        }
        catch (IOException ioEx) {
            Activator.logException(ioEx);
        }
    }

    public void save(IFile qdlFile) {
        this.writeToFile(qdlFile);
    }

    public boolean writeToFile(IFile qdlFile) {
        boolean ret = false;
        String filePath = qdlFile.getFullPath().toString();
        URI fileURI = URI.createPlatformResourceURI((String)filePath, (boolean)false);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource.Factory.Registry factoryRegistry = resourceSet.getResourceFactoryRegistry();
        Map map = factoryRegistry.getExtensionToFactoryMap();
        map.put("qdl", new QdlResourceFactoryImpl());
        this.resourceT = resourceSet.createResource(fileURI);
        if (this.documentRoot != null) {
            this.resourceT.getContents().add((Object)this.documentRoot);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        try {
            this.resourceT.save(options);
        }
        catch (IOException ioEx) {
            Activator.logException(ioEx);
        }
        return ret;
    }

    public void load(String path) {
        String filePath = path;
        URI uri = URI.createPlatformResourceURI((String)filePath, (boolean)false);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resourceA = resourceSet.createResource(uri);
        XMLMapImpl xmlmap = new XMLMapImpl();
        xmlmap.setNoNamespacePackage((EPackage)QdlPackage.eINSTANCE);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XML_MAP", xmlmap);
        options.put("ENCODING", "UTF-8");
        try {
            resourceA.load(options);
            this.documentRoot = (DocumentRoot)resourceA.getContents().get(0);
            this.queueType = this.documentRoot.getQueue();
            this.allowedVOs = this.queueType.getAllowedVirtualOrganizations();
        }
        catch (IOException ioEx) {
            Activator.logException(ioEx);
        }
    }
}

