/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.internal;

import eu.geclipse.batch.IWorkerNodeInfo;
import eu.geclipse.batch.internal.Messages;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerNodeInfo
implements IWorkerNodeInfo {
    private String wnFQN;
    private IWorkerNodeInfo.WorkerNodeState state;
    private int np;
    private String properties;
    private String type;
    private String status;
    private List<String> jobs;

    public WorkerNodeInfo(String wnFQN, IWorkerNodeInfo.WorkerNodeState state, int np, String properties, String type, String status, List<String> jobs) {
        this.wnFQN = wnFQN;
        this.state = state;
        this.np = np;
        this.properties = properties;
        this.type = type;
        this.status = status;
        this.jobs = jobs;
    }

    @Override
    public int getNp() {
        return this.np;
    }

    @Override
    public void setNp(int np) {
        this.np = np;
    }

    @Override
    public String getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(String properties) {
        this.properties = properties;
    }

    @Override
    public IWorkerNodeInfo.WorkerNodeState getState() {
        return this.state;
    }

    @Override
    public String getStateAsString() {
        String str = null;
        switch (this.state) {
            case free: {
                str = "free";
                break;
            }
            case down: {
                str = "down";
                break;
            }
            case offline: {
                str = "offline";
                break;
            }
            case job_exclusive: {
                str = "job-exclusive";
                break;
            }
            case unknown: {
                str = "unknown";
                break;
            }
            default: {
                str = "";
            }
        }
        return str;
    }

    @Override
    public void setState(IWorkerNodeInfo.WorkerNodeState state) {
        this.state = state;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getWnFQN() {
        return this.wnFQN;
    }

    public static IWorkerNodeInfo.WorkerNodeState getStateFromString(String state) {
        IWorkerNodeInfo.WorkerNodeState retState = null;
        if (state.compareTo("free") == 0) {
            retState = IWorkerNodeInfo.WorkerNodeState.free;
        } else if (state.compareTo("down") == 0) {
            retState = IWorkerNodeInfo.WorkerNodeState.down;
        } else if (state.compareTo("offline") == 0) {
            retState = IWorkerNodeInfo.WorkerNodeState.offline;
        } else if (state.compareTo("job-exclusive") == 0) {
            retState = IWorkerNodeInfo.WorkerNodeState.job_exclusive;
        } else if (state.compareTo("busy") == 0) {
            retState = IWorkerNodeInfo.WorkerNodeState.busy;
        } else if (state.compareTo("unknown") == 0) {
            retState = IWorkerNodeInfo.WorkerNodeState.unknown;
        }
        return retState;
    }

    @Override
    public String getKernelVersion() {
        int endIndex;
        int beginIndex;
        String kernel = null;
        kernel = this.status != null ? (-1 != (beginIndex = this.status.indexOf(this.wnFQN) + this.wnFQN.length() + 1) ? (-1 != (endIndex = this.status.indexOf(32, beginIndex)) ? this.status.substring(beginIndex, endIndex) : Messages.getString("WorkerNodeInfo.Unknown")) : Messages.getString("WorkerNodeInfo.Unknown")) : Messages.getString("WorkerNodeInfo.Unknown");
        return kernel;
    }

    @Override
    public String getTotalMem() {
        int endIndex;
        int beginIndex;
        String mem = null;
        String id = "physmem=";
        mem = this.status != null ? (-1 != (beginIndex = this.status.indexOf(id) + id.length()) ? (-1 != (endIndex = this.status.indexOf(44, beginIndex)) ? this.status.substring(beginIndex, endIndex) : Messages.getString("WorkerNodeInfo.Unknown")) : Messages.getString("WorkerNodeInfo.Unknown")) : Messages.getString("WorkerNodeInfo.Unknown");
        return mem;
    }

    @Override
    public List<String> getJobs() {
        return this.jobs;
    }
}

