/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.lsf;

import eu.geclipse.batch.AbstractBatchService;
import eu.geclipse.batch.IBatchJobInfo;
import eu.geclipse.batch.IBatchJobManager;
import eu.geclipse.batch.IBatchServiceDescription;
import eu.geclipse.batch.IQueueInfo;
import eu.geclipse.batch.IWorkerNodeInfo;
import eu.geclipse.batch.model.qdl.DocumentRoot;
import eu.geclipse.core.reporting.ProblemException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LSFBatchService
extends AbstractBatchService {
    private String pbsCmdPath = null;
    private String qCmdPath = null;
    private String qmgrCmdPath = null;
    private List<IBatchJobInfo> tmpJobs = new ArrayList<IBatchJobInfo>();

    public LSFBatchService(IBatchServiceDescription description, String name) {
        super(description, name);
    }

    @Override
    public void createQueue(String queueName, IQueueInfo.QueueType type, boolean enabled, double timeCPU, double timeWall, List<String> vos) throws ProblemException {
    }

    @Override
    public void createQueue(String queueName, int priority, IQueueInfo.QueueType type, boolean enabled, boolean started, int runMax, double timeCPU, double timeWall, int queMax, int assignedResources, List<String> vos) throws ProblemException {
    }

    @Override
    public void createQueue(DocumentRoot documentRoot) throws ProblemException {
    }

    @Override
    public void delJob(String jobId) throws ProblemException {
        if (jobId != null) {
            this.connection.execCommand(String.valueOf(this.qCmdPath) + "bkill " + jobId);
        }
    }

    @Override
    public void delQueue(String queueId) throws ProblemException {
    }

    @Override
    public void disableQueue(String queueId) throws ProblemException {
        if (queueId != null) {
            this.connection.execCommand(String.valueOf(this.qCmdPath) + "badmin qclose " + queueId);
        }
    }

    @Override
    public void disableQueues(String[] queueIds) throws ProblemException {
    }

    @Override
    public void disableWN(String nodeId) throws ProblemException {
        if (nodeId != null) {
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + "lsadmin limshutdown " + nodeId);
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + "lsadmin resshutdown " + nodeId);
        }
    }

    @Override
    public void enableQueue(String queueId) throws ProblemException {
        if (queueId != null) {
            this.connection.execCommand(String.valueOf(this.qCmdPath) + "badmin qopen " + queueId);
        }
    }

    @Override
    public void enableQueues(String[] queueIds) throws ProblemException {
    }

    @Override
    public void enableWN(String nodeId) throws ProblemException {
        if (nodeId != null) {
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + "lsadmin limstartup " + nodeId);
            this.connection.execCommand(String.valueOf(this.qmgrCmdPath) + "lsadmin resstartup " + nodeId);
        }
    }

    @Override
    public void getJobs(IBatchJobManager manager) throws ProblemException {
    }

    @Override
    public List<IQueueInfo> getQueues() throws ProblemException {
        return null;
    }

    @Override
    public List<IWorkerNodeInfo> getWorkerNodes() throws ProblemException {
        return null;
    }

    @Override
    public void holdJob(String jobId) throws ProblemException {
        if (jobId != null) {
            String cmd = "qstop " + jobId;
            this.connection.execCommand(String.valueOf(this.qCmdPath) + cmd);
        }
    }

    @Override
    public void holdJobs(String[] jobIds) throws ProblemException {
    }

    @Override
    public void moveJob(String jobId, String destQueue, String destServer) throws ProblemException {
        if (jobId != null && destQueue != null) {
            this.connection.execCommand(String.valueOf(this.qCmdPath) + "bswitch " + destQueue + " " + jobId);
        }
    }

    @Override
    public void moveJobs(String[] jobIds, String destQueue, String destServer) throws ProblemException {
    }

    @Override
    public void releaseJob(String jobId) throws ProblemException {
        if (jobId != null) {
            String cmd = "bresume " + jobId;
            this.connection.execCommand(String.valueOf(this.qCmdPath) + cmd);
        }
    }

    @Override
    public void releaseJobs(String[] jobIds) throws ProblemException {
    }

    @Override
    public void setMaxWallTime(String queueName, String timeWall) throws ProblemException {
    }

    @Override
    public void startQueue(String queueId) throws ProblemException {
        if (queueId != null) {
            this.connection.execCommand(String.valueOf(this.qCmdPath) + "badmin qact " + queueId);
        }
    }

    @Override
    public void startQueues(String[] queueIds) throws ProblemException {
    }

    @Override
    public void stopQueue(String queueId) throws ProblemException {
        if (queueId != null) {
            this.connection.execCommand(String.valueOf(this.qCmdPath) + "badmin qinact " + queueId);
        }
    }

    @Override
    public void stopQueues(String[] queueIds) throws ProblemException {
    }

    @Override
    public void reRunJob(String jobId) throws ProblemException {
    }

    @Override
    public void reRunJobs(String[] jobIds) throws ProblemException {
    }
}

