/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.filesystem;

import eu.geclipse.core.filesystem.TransferInformation;
import eu.geclipse.core.filesystem.internal.Activator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferRepository {
    private static TransferRepository singleton;

    public static TransferRepository getTransferRepository() {
        if (singleton == null) {
            singleton = new TransferRepository();
        }
        return singleton;
    }

    public void save(TransferInformation op) {
        try {
            TransferRepositoryWriter.saveOperation(op, this.getRepoFile());
        }
        catch (ParserConfigurationException e) {
            Activator.logException(e);
        }
        catch (SAXException e) {
            Activator.logException(e);
        }
        catch (IOException e) {
            Activator.logException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            Activator.logException(e);
        }
        catch (TransformerException e) {
            Activator.logException(e);
        }
    }

    public void delete(Integer transferId) {
        try {
            TransferRepositoryWriter.delete(this.getRepoFile(), transferId);
        }
        catch (ParserConfigurationException e) {
            Activator.logException(e);
        }
        catch (SAXException e) {
            Activator.logException(e);
        }
        catch (IOException e) {
            Activator.logException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            Activator.logException(e);
        }
        catch (TransformerException e) {
            Activator.logException(e);
        }
    }

    public List<TransferInformation> getOperations() {
        List<TransferInformation> operations = new ArrayList<TransferInformation>();
        try {
            File repoFile = this.getRepoFile();
            if (repoFile != null) {
                operations = TransferRepositoryParser.getOperations(repoFile);
            }
        }
        catch (ParserConfigurationException e) {
            Activator.logException(e);
        }
        catch (SAXException e) {
            Activator.logException(e);
        }
        catch (IOException e) {
            Activator.logException(e);
        }
        catch (CoreException e) {
            Activator.logException(e);
        }
        catch (URISyntaxException e) {
            Activator.logException(e);
        }
        return operations;
    }

    private File getRepoFile() {
        IPath path = null;
        File file = null;
        if (Activator.getDefault() != null && !(file = (path = Activator.getDefault().getStateLocation()).append("transferRepository.xml").toFile()).exists()) {
            try {
                file.createNewFile();
                FileOutputStream stream = new FileOutputStream(file);
                String contents = "<root>\n</root>";
                stream.write(contents.getBytes());
                stream.close();
            }
            catch (IOException e) {
                Activator.logException(e);
            }
        }
        return file;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransferRepositoryParser {
        private TransferRepositoryParser() {
        }

        public static List<TransferInformation> getOperations(File file) throws ParserConfigurationException, SAXException, IOException, CoreException, URISyntaxException {
            ArrayList<TransferInformation> result = new ArrayList<TransferInformation>();
            DocumentBuilderFactory factoryDOM = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factoryDOM.newDocumentBuilder();
            Document document = builder.parse(file);
            NodeList resultsXML = document.getElementsByTagName("transfer");
            int i = 0;
            while (i < resultsXML.getLength()) {
                Element singleResult = (Element)resultsXML.item(i);
                int id = Integer.valueOf(((Element)singleResult.getElementsByTagName("id").item(0)).getTextContent());
                String data = ((Element)singleResult.getElementsByTagName("data").item(0)).getTextContent();
                String sourceURI = ((Element)singleResult.getElementsByTagName("source").item(0)).getTextContent();
                String destinationURI = ((Element)singleResult.getElementsByTagName("destination").item(0)).getTextContent();
                long lenght = Long.valueOf(((Element)singleResult.getElementsByTagName("size").item(0)).getTextContent());
                IFileStore source = EFS.getStore((URI)new URI(sourceURI));
                IFileStore destination = EFS.getStore((URI)new URI(destinationURI));
                result.add(new TransferInformation(id, source, destination, data, lenght));
                ++i;
            }
            return result;
        }
    }

    private static class TransferRepositoryWriter {
        private TransferRepositoryWriter() {
        }

        public static void saveOperation(TransferInformation op, File file) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
            DocumentBuilderFactory factoryDOM = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factoryDOM.newDocumentBuilder();
            Document document = builder.parse(file);
            Node nodeToDelete = null;
            NodeList resultsList = document.getElementsByTagName("transfer");
            int i = 0;
            while (i < resultsList.getLength()) {
                String idString = ((Element)resultsList.item(i)).getElementsByTagName("id").item(0).getTextContent();
                DocumentBuilderFactory factoryDOM2 = DocumentBuilderFactory.newInstance();
                factoryDOM2.newDocumentBuilder();
                if (Integer.valueOf(idString).equals(op.getId())) {
                    nodeToDelete = resultsList.item(i);
                }
                ++i;
            }
            Element newTransfer = document.createElement("transfer");
            Element transferIdElement = document.createElement("id");
            transferIdElement.setTextContent(op.getId().toString());
            Element sourceElement = document.createElement("source");
            sourceElement.setTextContent(op.getSource().toURI().toString());
            Element destinationElement = document.createElement("destination");
            destinationElement.setTextContent(op.getDestination().toURI().toString());
            Element dataElement = document.createElement("data");
            dataElement.setTextContent(op.getData());
            Element sizeElement = document.createElement("size");
            sizeElement.setTextContent(String.valueOf(op.getSize()));
            newTransfer.appendChild(transferIdElement);
            newTransfer.appendChild(sourceElement);
            newTransfer.appendChild(destinationElement);
            newTransfer.appendChild(dataElement);
            newTransfer.appendChild(sizeElement);
            if (nodeToDelete != null) {
                document.getFirstChild().replaceChild(newTransfer, nodeToDelete);
            } else {
                document.getFirstChild().appendChild(newTransfer);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result1 = new StreamResult(file);
            transformer.transform(source, result1);
        }

        public static void delete(File file, Integer transferId) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
            DocumentBuilderFactory factoryDOM = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factoryDOM.newDocumentBuilder();
            Document document = builder.parse(file);
            Node nodeToDelete = null;
            NodeList resultsList = document.getElementsByTagName("transfer");
            int i = 0;
            while (i < resultsList.getLength()) {
                Integer id = Integer.valueOf(((Element)resultsList.item(i)).getElementsByTagName("id").item(0).getTextContent());
                if (id.compareTo(transferId) == 0) {
                    nodeToDelete = resultsList.item(i);
                }
                ++i;
            }
            if (nodeToDelete != null) {
                document.getFirstChild().removeChild(nodeToDelete);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(document);
                StreamResult result1 = new StreamResult(file);
                transformer.transform(source, result1);
            }
        }
    }
}

