/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.filesystem.internal.filesystem;

import eu.geclipse.core.filesystem.internal.filesystem.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class CachedInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 0x100000;
    private InputStream slave;
    private int bufferSize;
    private ByteBuffer buffer;

    public CachedInputStream(InputStream slave, int cacheSize) {
        this.slave = slave;
        this.bufferSize = cacheSize;
    }

    public int available() throws IOException {
        int result = 0;
        if (this.buffer != null) {
            result = this.buffer.remaining();
        }
        return result;
    }

    public void cache(IProgressMonitor monitor) throws IOException {
        SubMonitor sMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.getString("CachedInputStream.caching_progress"), (int)(this.bufferSize / 0x100000));
        sMonitor.subTask(Messages.getString("CachedInputStream.allocating_progress"));
        this.buffer = ByteBuffer.allocate(this.bufferSize);
        int totalBytesRead = 0;
        int currentBlockRead = 0;
        try {
            int bytesRead = 0;
            byte[] readBuffer = new byte[0x100000];
            while (!sMonitor.isCanceled() && (bytesRead = this.slave.read(readBuffer)) >= 0) {
                this.buffer.put(readBuffer, 0, bytesRead);
                totalBytesRead += bytesRead;
                if ((currentBlockRead += bytesRead) < 0x100000) continue;
                int steps = currentBlockRead / 0x100000;
                currentBlockRead %= 0x100000;
                double fraction = 100.0 / (double)this.bufferSize * (double)totalBytesRead;
                sMonitor.worked(steps);
                sMonitor.subTask(String.format(Messages.getString("CachedInputStream.progress_format"), totalBytesRead / 1024, this.bufferSize / 1024, fraction));
            }
            double fraction = 100.0 / (double)this.bufferSize * (double)totalBytesRead;
            sMonitor.subTask(String.format(Messages.getString("CachedInputStream.progress_format"), totalBytesRead / 1024, this.bufferSize / 1024, fraction));
        }
        finally {
            this.slave.close();
            this.buffer.rewind();
            sMonitor.done();
        }
    }

    public void close() throws IOException {
        if (this.buffer != null) {
            this.buffer.rewind();
        }
    }

    public void discard() {
        this.buffer = null;
    }

    public synchronized void mark(int readlimit) {
        if (this.buffer != null) {
            this.buffer.mark();
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        int result = -1;
        if (this.buffer != null && this.buffer.hasRemaining()) {
            result = this.buffer.get();
        }
        return result;
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        int remaining;
        int result = -1;
        if (this.buffer != null && (remaining = this.buffer.remaining()) > 0) {
            result = Math.min(remaining, length);
            this.buffer.get(b, offset, result);
        }
        return result;
    }

    public synchronized void reset() throws IOException {
        if (this.buffer != null) {
            this.buffer.reset();
        }
    }

    public long skip(long n) throws IOException {
        int remaining;
        int result = 0;
        if (this.buffer != null && (remaining = this.buffer.remaining()) > 0) {
            result = Math.min(remaining, (int)n);
            int position = this.buffer.position();
            this.buffer.position(position + result);
        }
        return result;
    }
}

