/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.filesystem.internal.filesystem;

import eu.geclipse.core.filesystem.GEclipseFileSystem;
import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.filesystem.internal.filesystem.CachedInputStream;
import eu.geclipse.core.filesystem.internal.filesystem.FileStoreRegistry;
import eu.geclipse.core.filesystem.internal.filesystem.Messages;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IProtectable;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.util.MasterMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class GEclipseFileStore
extends FileStore {
    public static final int FETCH_CHILDREN_ACTIVE_POLICY = 1;
    public static final int FETCH_INFO_ACTIVE_POLICY = 2;
    public static final int MOVE_COPY_ACTIVE_POLICY = 4;
    private GEclipseFileSystem fileSystem;
    private GEclipseFileStore parent;
    private IFileStore slave;
    private IFileInfo fileInfo;
    private int active;
    private IProgressMonitor externalMonitor;
    private CachedInputStream ciStream;
    private IFileInfo[] cachedInfos;

    protected GEclipseFileStore(GEclipseFileSystem fileSystem, IFileStore slave) {
        Assert.isNotNull((Object)((Object)fileSystem));
        Assert.isNotNull((Object)slave);
        this.fileSystem = fileSystem;
        IFileStore slaveParent = slave.getParent();
        if (slaveParent != null) {
            FileStoreRegistry registry = FileStoreRegistry.getInstance();
            this.parent = registry.getStore(slaveParent);
        } else {
            this.parent = null;
        }
        this.slave = slave;
        this.fileInfo = new FileInfo(this.getNameWithoutConnect(slave));
        this.clearActive(3);
        this.setActive(4);
    }

    private GEclipseFileStore(GEclipseFileStore parent, IFileStore slave, String name) {
        Assert.isNotNull((Object)((Object)parent));
        Assert.isNotNull((Object)slave);
        this.fileSystem = (GEclipseFileSystem)parent.getFileSystem();
        this.parent = parent;
        this.slave = slave;
        this.fileInfo = new FileInfo(name);
        this.clearActive(1);
        this.setActive(6);
    }

    private GEclipseFileStore(GEclipseFileStore parent, IFileStore slave, IFileInfo info) {
        Assert.isNotNull((Object)((Object)parent));
        Assert.isNotNull((Object)slave);
        this.fileSystem = (GEclipseFileSystem)parent.getFileSystem();
        this.parent = parent;
        this.slave = slave;
        this.fileInfo = info;
        this.clearActive(3);
        this.setActive(4);
    }

    public void setActive(int policy) {
        this.active |= policy;
    }

    public void cacheInputStream(IGridConnectionElement cElement, IProgressMonitor monitor) throws CoreException {
        SubMonitor sMonitor = SubMonitor.convert((IProgressMonitor)this.monitor(monitor), (String)Messages.getString("GEclipseFileStore.caching_progress"), (int)10);
        try {
            this.setActive(2);
            IFileInfo info = this.fetchInfo(0, (IProgressMonitor)sMonitor.newChild(1));
            if (!info.exists()) {
                throw new ProblemException("eu.geclipse.core.problem.io.fileNotFound", "eu.geclipse.core.filesystem");
            }
            InputStream siStream = this.openInputStream(0, (IProgressMonitor)sMonitor.newChild(1));
            cElement.getResource().refreshLocal(0, monitor);
            this.ciStream = new CachedInputStream(siStream, (int)info.getLength());
            try {
                this.ciStream.cache((IProgressMonitor)sMonitor.newChild(8));
            }
            catch (IOException ioExc) {
                throw new ProblemException("eu.geclipse.core.problem.io.unspecified", String.format(Messages.getString("GEclipseFileStore.caching_error"), this.getName()), (Throwable)ioExc, "eu.geclipse.core.filesystem");
            }
        }
        finally {
            sMonitor.done();
        }
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        IFileInfo[] infos = FileStore.EMPTY_FILE_INFO_ARRAY;
        String[] result = FileStore.EMPTY_STRING_ARRAY;
        if (this.isActive(1)) {
            this.clearActive(1);
            infos = this.getSlave().childInfos(options, this.monitor(monitor));
            this.setCachedInfos(infos);
            ArrayList<String> names = new ArrayList<String>(infos.length);
            IFileInfo[] iFileInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                IFileInfo info = iFileInfoArray[n2];
                names.add(info.getName());
                ++n2;
            }
            result = names.toArray(new String[names.size()]);
        }
        return result;
    }

    public void copy(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        if (this.isActive(4)) {
            this.getSlave().copy(this.slave(destination), options, this.monitor(monitor));
        }
    }

    private void setCachedInfos(IFileInfo[] infos) {
        IFileInfo info;
        int n;
        int n2;
        IFileInfo[] iFileInfoArray;
        FileStoreRegistry registry;
        if (this.cachedInfos != null) {
            registry = FileStoreRegistry.getInstance();
            iFileInfoArray = this.cachedInfos;
            n2 = this.cachedInfos.length;
            n = 0;
            while (n < n2) {
                info = iFileInfoArray[n];
                IFileStore child = this.getSlave().getChild(info.getName().trim());
                registry.removeStore(child);
                ++n;
            }
        }
        this.cachedInfos = infos;
        registry = FileStoreRegistry.getInstance();
        iFileInfoArray = this.cachedInfos;
        n2 = this.cachedInfos.length;
        n = 0;
        while (n < n2) {
            info = iFileInfoArray[n];
            registry.putStore(new GEclipseFileStore(this, this.getSlave().getChild(info.getName()), info));
            ++n;
        }
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        this.getSlave().delete(options, this.monitor(monitor));
        this.removeCachedStoreWithChildren(this);
        if (this.parent != null) {
            this.parent.setActive(1);
        }
    }

    private void removeCachedStoreWithChildren(GEclipseFileStore fileStore) {
        FileStoreRegistry registry = FileStoreRegistry.getInstance();
        registry.removeStore((IFileStore)this);
        if (this.cachedInfos != null) {
            IFileInfo[] iFileInfoArray = this.cachedInfos;
            int n = this.cachedInfos.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child;
                IFileInfo childInfo = iFileInfoArray[n2];
                if (childInfo.getName() != null && childInfo.getName().length() > 0 && (child = this.getSlave().getChild(childInfo.getName())) != null) {
                    registry.removeStore(child);
                }
                ++n2;
            }
        }
    }

    public void discardCachedInputStream() {
        if (this.ciStream != null) {
            this.ciStream.discard();
            this.ciStream = null;
        }
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        if (this.isActive(1)) {
            this.clearActive(1);
            this.setCachedInfos(this.getSlave().childInfos(options, monitor));
        }
        if (this.cachedInfos == null) {
            this.cachedInfos = FileStore.EMPTY_FILE_INFO_ARRAY;
        }
        return this.cachedInfos;
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        if (this.isActive(2)) {
            this.clearActive(2);
            this.fileInfo = this.getSlave().fetchInfo(options, this.monitor(monitor));
        }
        if (this.fileInfo == null) {
            this.fileInfo = new FileInfo();
        }
        return this.fileInfo;
    }

    public IFileStore getChild(String name) {
        FileStoreRegistry registry;
        GEclipseFileStore result = null;
        IFileStore child = this.getSlave().getChild(name.trim());
        if (child != null && (result = (registry = FileStoreRegistry.getInstance()).getStore(child)) == null) {
            result = new GEclipseFileStore(this, child, name);
            registry.putStore(result);
        }
        return result;
    }

    public IFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public String getName() {
        return this.getSlave().getName();
    }

    public IFileStore getParent() {
        return this.parent;
    }

    public IFileStore getSlave() {
        return this.slave;
    }

    public boolean isLocal() {
        String scheme = this.toGEclipseURI().getSlaveScheme();
        IFileSystem localFileSystem = EFS.getLocalFileSystem();
        String localScheme = localFileSystem.getScheme();
        return scheme.equals(localScheme);
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        GEclipseFileStore result = this;
        if (!this.fetchInfo().exists()) {
            IFileStore dir = this.getSlave().mkdir(options, this.monitor(monitor));
            FileStoreRegistry registry = FileStoreRegistry.getInstance();
            result = new GEclipseFileStore(this, dir, dir.getName());
            registry.putStore(result);
        }
        return result;
    }

    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        if (this.isActive(4)) {
            this.getSlave().move(this.slave(destination), options, this.monitor(monitor));
        }
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        return this.ciStream != null ? this.ciStream : this.getSlave().openInputStream(options, this.monitor(monitor));
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        URI oldUri = this.getSlave().toURI();
        OutputStream outputStream = this.getSlave().openOutputStream(options, this.monitor(monitor));
        URI currentUri = this.getSlave().toURI();
        if (!currentUri.equals(oldUri)) {
            FileStoreRegistry registry = FileStoreRegistry.getInstance();
            registry.removeStore(new GEclipseURI(oldUri));
            registry.putStore(this);
        }
        this.setActive(2);
        return outputStream;
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        this.getSlave().putInfo(info, options, this.monitor(monitor));
    }

    public void setExternalMonitor(IProgressMonitor monitor) {
        this.externalMonitor = monitor;
    }

    public GEclipseURI toGEclipseURI() {
        return new GEclipseURI(this.getSlave().toURI());
    }

    public URI toURI() {
        return this.toGEclipseURI().toMasterURI();
    }

    private boolean isActive(int policy) {
        return (this.active & policy) != 0;
    }

    public void clearActive(int policy) {
        this.active &= ~policy;
    }

    private IProgressMonitor monitor(IProgressMonitor monitor) {
        return new MasterMonitor(monitor, this.externalMonitor);
    }

    private IFileStore slave(IFileStore store) {
        IFileStore result = store;
        while (result != null && result instanceof GEclipseFileStore) {
            result = ((GEclipseFileStore)result).getSlave();
        }
        return result;
    }

    private String getNameWithoutConnect(IFileStore slaveStore) {
        String name = null;
        String path = slaveStore.toURI().getPath();
        if (path != null) {
            name = new Path(path).lastSegment();
        }
        if (name == null || name.length() == 0) {
            name = Messages.getString("GEclipseFileStore.filenameUnknown");
        }
        return name;
    }

    public Object getAdapter(Class adapter) {
        Object result = null;
        if (adapter == IProtectable.class && this.slave != null && this.slave instanceof IProtectable) {
            result = this.slave;
        }
        if (result == null) {
            result = adapter.isAssignableFrom(((Object)((Object)this)).getClass()) ? this : (adapter.isAssignableFrom(this.slave.getClass()) ? this.slave : this.slave.getAdapter(adapter));
        }
        if (result == null) {
            result = super.getAdapter(adapter);
        }
        return result;
    }
}

