/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.jobs;

import eu.geclipse.core.ExtensionManager;
import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.jobs.GridJobID;
import eu.geclipse.core.jobs.GridJobStatus;
import eu.geclipse.core.jobs.Messages;
import eu.geclipse.core.jobs.internal.Activator;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridElementManager;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.IGridJobID;
import eu.geclipse.core.model.IGridJobService;
import eu.geclipse.core.model.IGridJobStatus;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.ResourceGridContainer;
import eu.geclipse.core.model.impl.ResourceGridElement;
import eu.geclipse.core.reporting.ProblemException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridJob
extends ResourceGridContainer
implements IGridJob {
    public static final String FOLDERNAME_INPUT_FILES = Messages.getString("GridJob.FolderInputFiles");
    public static final String FOLDERNAME_OUTPUT_FILES = Messages.getString("GridJob.FolderOutputFiles");
    static String JOBFILE_EXTENSION = ".job";
    private static final String FOLDER_PROPERTIES_QUALIFIER = "eu.geclipse.core.jobs.GridJob";
    private static final String FOLDER_PROPERTY_JOBID_CLASS = "JobID.class";
    private static final String JOBID_FILENAME = ".jobID";
    private static final String JOBINFO_FILENAME = ".jobInfo";
    private static final String JOBINFO_JOBDESCRIPTION_XMLNODENAME = "JobDescriptionFileName";
    private static final String JOBINFO_JOBNAME = "JobName";
    private static final String JOBINFO_SUBMISSIONTIME_XMLNODENAME = "SubmissionTime";
    private static final String JOBINFO_XMLNODENAME = "JobInfo";
    private static final String JOBSTATUS_FILENAME = ".jobStatus";
    private static final String XML_CHARSET = "ISO-8859-1";
    private IGridJobDescription jobDescription = null;
    private IFile jobDescriptionFile = null;
    private GridJobID jobID = null;
    private IFile jobIdFile = null;
    private IFile jobInfoFile = null;
    private String jobName;
    private IGridJobService jobService;
    private GridJobStatus jobStatus = null;
    private IFile jobStatusFile = null;
    private Date submissionTime;

    public GridJob(IFolder jobFolder) {
        super((IResource)jobFolder);
        this.jobStatusFile = jobFolder.getFile(JOBSTATUS_FILENAME);
        this.jobIdFile = jobFolder.getFile(JOBID_FILENAME);
        this.jobInfoFile = jobFolder.getFile(JOBINFO_FILENAME);
        this.jobName = this.getName();
        this.readJobID();
        this.setJobFolderProperties(jobFolder);
        this.readJobInfo(jobFolder);
        this.readChildren();
        if (this.jobDescriptionFile != null) {
            this.readJobDescription();
            try {
                this.addElement((IGridElement)this.jobDescription);
            }
            catch (ProblemException e) {
                Activator.logException(e, String.valueOf(Messages.getString("GridJob.errLoadJobDescription")) + jobFolder.getName());
            }
        }
    }

    public static boolean canCreate(IFolder folder) {
        IFile infoFile = folder.getFile(JOBINFO_FILENAME);
        return "job".equalsIgnoreCase(folder.getFileExtension()) ? infoFile.exists() : false;
    }

    public static GridJob createJobStructure(IFolder jobFolder, GridJobID id, IGridJobService jobService, IGridJobDescription description, String uniqueJobName) throws ProblemException {
        GridJob job = new GridJob(jobFolder);
        job.create(jobFolder, id, jobService, description, uniqueJobName);
        return job;
    }

    public static String getJobIdClass(IFolder jobFolder) {
        String jobIdClass = null;
        try {
            Object property = jobFolder.getSessionProperty(new QualifiedName(FOLDER_PROPERTIES_QUALIFIER, FOLDER_PROPERTY_JOBID_CLASS));
            if (property instanceof String) {
                jobIdClass = (String)property;
            }
        }
        catch (CoreException exception) {
            Activator.logException(exception, String.format("Cannot get property for job folder " + jobFolder.getName(), new Object[0]));
        }
        return jobIdClass;
    }

    private void addStagingFolder(IFolder jobFolder, String folderName) {
        IFolder folder = jobFolder.getFolder(folderName);
        if (folder.exists()) {
            try {
                this.createModelElement((IResource)folder);
            }
            catch (ProblemException exception) {
                Activator.logException(exception, String.format(Messages.getString("GridJob.errAddFolder"), folderName));
            }
        }
    }

    public void cancel() {
    }

    public boolean canContain(IGridElement element) {
        return element instanceof IGridJobDescription || element instanceof ResourceGridElement || element instanceof ResourceGridContainer || element instanceof IGridJob;
    }

    public void create(IFolder jobFolder, IGridJobID id, IGridJobService jobSrvce, IGridJobDescription description, String uniqueJobName) throws ProblemException {
        this.submissionTime = Calendar.getInstance().getTime();
        this.jobStatusFile = jobFolder.getFile(JOBSTATUS_FILENAME);
        this.jobIdFile = jobFolder.getFile(JOBID_FILENAME);
        this.jobInfoFile = jobFolder.getFile(JOBINFO_FILENAME);
        this.jobID = (GridJobID)id;
        this.jobService = jobSrvce;
        this.jobDescription = description;
        this.jobStatus = new GridJobStatus(Messages.getString("GridJob.jobStatusSubmitted"), 1);
        this.jobID.setJob(this);
        this.jobName = uniqueJobName;
        this.writeJobDescription(description, jobFolder);
        this.writeJobID(id, jobFolder);
        this.writeJobStatus(this.jobStatusFile);
        this.writeJobInfo(description, jobFolder);
        this.createStagingFolders(jobFolder);
    }

    private void createFileLink(IFolder localFolder, String localFilename, URI uri) {
        IFile file = localFolder.getFile(localFilename);
        if (!file.exists()) {
            GEclipseURI geclURI = new GEclipseURI(uri);
            try {
                file.createLink(geclURI.toMasterURI(), 16, null);
            }
            catch (CoreException exception) {
                Activator.logException(exception, String.valueOf(Messages.getString("GridJob.errCreateLink")) + uri.toString());
            }
        }
    }

    private IGridJobService createJobService(IGridJobID jobId) {
        IGridJobService service = null;
        IGridElementCreator creator = GridModel.getCreatorRegistry().getCreator((Object)jobId, IGridJobService.class);
        if (creator != null) {
            try {
                IVirtualOrganization vo = this.getProject().getVO();
                service = (IGridJobService)creator.create((IGridContainer)vo);
            }
            catch (ProblemException exception) {
                Activator.logException(exception, Messages.getString("GridJob.createJobServiceFailederr"));
            }
        }
        return service;
    }

    private IGridElement createModelElement(IResource resource) throws ProblemException {
        IGridElement element = null;
        IGridElementCreator creator = this.findCreator(resource);
        if (creator != null) {
            element = this.create(creator);
        }
        return element;
    }

    private IFolder createStagingFilesFolder(IFolder jobFolder, String folderName, Map<String, URI> filesMap) throws CoreException {
        IFolder folder = jobFolder.getFolder(folderName);
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        for (String filename : filesMap.keySet()) {
            URI uri = filesMap.get(filename);
            String scheme = uri.getScheme();
            if (scheme == null || scheme.length() <= 0) continue;
            this.createFileLink(folder, filename, uri);
        }
        return folder;
    }

    private void createStagingFolders(IFolder jobFolder) {
        IGridJobService service = this.getJobService();
        try {
            Map inputFilesMap = service.getInputFiles(this.getID(), this.getJobDescription(), this.getProject().getVO());
            if (inputFilesMap != null && inputFilesMap.size() > 0) {
                this.createStagingFilesFolder(jobFolder, FOLDERNAME_INPUT_FILES, inputFilesMap);
            }
        }
        catch (CoreException exception) {
            Activator.logException(exception);
        }
        try {
            Map outputFilesMap = service.getOutputFiles(this.getID(), this.getJobDescription(), this.getProject().getVO());
            if (outputFilesMap != null && outputFilesMap.size() > 0) {
                this.createStagingFilesFolder(jobFolder, FOLDERNAME_OUTPUT_FILES, outputFilesMap);
            }
        }
        catch (CoreException exception) {
            Activator.logException(exception);
        }
    }

    private Document createXmlDocument(IFile xmlFile) {
        Document xmlDocument = null;
        if (xmlFile.exists()) {
            try {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                InputStream inputStream = xmlFile.getContents(true);
                xmlDocument = documentBuilder.parse(inputStream);
                inputStream.close();
            }
            catch (CoreException e) {
                this.logXmlError(2, Messages.getString("GliteJob.jobfile_contents"), e);
            }
            catch (SAXException e) {
                this.logXmlError(2, Messages.getString("GliteJob.jobfile_parse_xml"), e);
            }
            catch (IOException e) {
                this.logXmlError(2, Messages.getString("GliteJob.jobfile_contents"), e);
            }
            catch (ParserConfigurationException e) {
                this.logXmlError(2, Messages.getString("GliteJob.jobfile_parse_xml"), e);
            }
        }
        return xmlDocument;
    }

    public void deleteJob(IProgressMonitor monitor) throws ProblemException {
        try {
            IGridJobService service = this.getJobService();
            if (service != null) {
                service.deleteJob(this.getID(), this.getProject().getVO(), monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected IStatus fetchChildren(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public String getHostName() {
        return null;
    }

    public IGridJobID getID() {
        if (this.jobID == null && this.jobIdFile.exists()) {
            this.readJobID();
        }
        return this.jobID;
    }

    public List<URI> getInputStagers() throws ProblemException {
        return this.getStagers(FOLDERNAME_INPUT_FILES);
    }

    public IGridJobDescription getJobDescription() {
        if (this.jobDescription == null && this.jobDescriptionFile != null) {
            IGridElement element = this.findChild(this.jobDescriptionFile.getName());
            if (element instanceof IGridJobDescription) {
                this.jobDescription = (IGridJobDescription)element;
            } else if (this.jobDescriptionFile.exists()) {
                this.readJobDescription();
            }
        }
        return this.jobDescription;
    }

    public String getJobName() {
        return this.jobName;
    }

    public IGridJobService getJobService() {
        if (this.jobService == null) {
            this.jobService = this.createJobService(this.jobID);
        }
        return this.jobService;
    }

    public IGridJobStatus getJobStatus() {
        if (this.jobStatus == null && this.jobStatusFile.exists()) {
            this.readJobStatus();
        }
        return this.jobStatus != null ? this.jobStatus : GridJobStatus.UNKNOWN_STATUS;
    }

    public IGridElementManager getManager() {
        return GridModel.getJobManager();
    }

    public List<URI> getOutputStagers() throws ProblemException {
        return this.getStagers(FOLDERNAME_OUTPUT_FILES);
    }

    private List<URI> getStagers(String stagersFolderName) throws ProblemException {
        ArrayList<URI> results = new ArrayList<URI>();
        IGridElement element = this.findChild(stagersFolderName);
        try {
            if (element instanceof IGridContainer) {
                IGridElement[] childrenElements;
                IGridContainer folder = (IGridContainer)element;
                IGridElement[] iGridElementArray = childrenElements = folder.getChildren(null);
                int n = childrenElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridElement gridElement = iGridElementArray[n2];
                    if (gridElement instanceof IGridConnectionElement) {
                        IGridConnectionElement connectionElement = (IGridConnectionElement)gridElement;
                        results.add(connectionElement.getURI());
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException exception) {
            if (exception instanceof ProblemException) {
                throw (ProblemException)((Object)exception);
            }
            throw new ProblemException("eu.geclipse.core.jobs.problem.getStagersFailed", (Throwable)exception, "eu.geclipse.core.jobs");
        }
        return results;
    }

    public Date getSubmissionTime() {
        return this.submissionTime;
    }

    public URI getURI() {
        return null;
    }

    private DateFormat getXmlDateFormatter() {
        DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, new Locale("Locale.US"));
        if (formatter == null) {
            formatter = DateFormat.getDateTimeInstance(2, 2);
        }
        formatter.setLenient(true);
        return formatter;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isLazy() {
        return false;
    }

    public boolean isLocal() {
        return true;
    }

    public boolean isVirtual() {
        return false;
    }

    private void logXmlError(int severity, String errorString, Throwable exception) {
        IResource resource = this.getResource();
        StringBuilder messageStringBuilder = new StringBuilder(errorString == null ? "null" : errorString);
        if (resource != null && resource.getFullPath() != null) {
            messageStringBuilder.append(" File: ");
            messageStringBuilder.append(resource.getFullPath());
        }
        Activator.logStatus((IStatus)new Status(severity, "eu.geclipse.core.jobs", 0, messageStringBuilder.toString(), exception));
    }

    private void readChildren() {
        IFolder jobFolder = (IFolder)this.getResource();
        try {
            IResource[] iResourceArray = jobFolder.members(true);
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                if (child instanceof IFolder) {
                    this.createModelElement(child);
                }
                ++n2;
            }
        }
        catch (CoreException exception) {
            Activator.logException(exception, "Cannot read children jobs.");
        }
    }

    private void readJobDescription() {
        try {
            IGridElementCreator elementCreator = GridModel.getCreatorRegistry().getCreator((Object)this.jobDescriptionFile, IGridJobDescription.class);
            if (elementCreator != null) {
                IGridElement description = elementCreator.create((IGridContainer)this);
                this.jobDescription = (IGridJobDescription)description;
            }
        }
        catch (Exception e) {
            Activator.logException(e);
        }
    }

    private void readJobID() {
        Document document = this.createXmlDocument(this.jobIdFile);
        if (document == null) {
            this.jobID = new GridJobID();
            this.jobID.setJob(this);
        } else {
            Element rootElement = document.getDocumentElement();
            "JobID".equals(rootElement.getNodeName());
            String className = rootElement.getAttribute("class");
            if (className != null && !className.equals("")) {
                ExtensionManager manager = new ExtensionManager();
                List list = manager.getConfigurationElements("eu.geclipse.core.jobs.jobID", "JobID");
                for (IConfigurationElement element : list) {
                    String attr = element.getAttribute("class");
                    if (!className.equals(attr)) continue;
                    try {
                        this.jobID = (GridJobID)element.createExecutableExtension("class");
                        this.jobID.setXMLNode(rootElement);
                        this.jobID.setJob(this);
                    }
                    catch (CoreException coreException) {}
                }
            }
            if (this.jobID == null) {
                this.jobID = new GridJobID(rootElement);
                this.jobID.setJob(this);
            }
        }
    }

    private void readJobInfo(IFolder jobFolder) {
        Element rootElement;
        Document document = this.createXmlDocument(this.jobInfoFile);
        if (document != null && JOBINFO_XMLNODENAME.equals((rootElement = document.getDocumentElement()).getNodeName())) {
            NodeList childNodes = rootElement.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                block13: {
                    Node node = childNodes.item(i);
                    if (JOBINFO_JOBDESCRIPTION_XMLNODENAME.equals(node.getNodeName())) {
                        String filename = node.getTextContent();
                        if (filename != null) {
                            filename = filename.trim();
                        }
                        this.jobDescriptionFile = jobFolder.getFile(filename);
                    } else if (JOBINFO_SUBMISSIONTIME_XMLNODENAME.equals(node.getNodeName())) {
                        try {
                            String textContent = node.getTextContent();
                            if (textContent == null || textContent.length() <= 0) break block13;
                            try {
                                this.submissionTime = this.getXmlDateFormatter().parse(textContent);
                            }
                            catch (ParseException parseException) {
                                this.submissionTime = DateFormat.getDateTimeInstance(3, 3, new Locale("Locale.US")).parse(textContent);
                            }
                        }
                        catch (DOMException dOMException) {
                        }
                        catch (ParseException parseException) {}
                    } else if (JOBINFO_JOBNAME.equals(node.getNodeName())) {
                        this.jobName = node.getTextContent();
                    }
                }
                ++i;
            }
        }
    }

    private void readJobStatus() {
        Document document = this.createXmlDocument(this.jobStatusFile);
        if (document == null) {
            this.jobStatus = new GridJobStatus();
        } else {
            Element rootElement = document.getDocumentElement();
            GridJobStatus.XML_ROOT.equals(rootElement.getNodeName());
            String className = rootElement.getAttribute("class");
            if (className != null && !className.equals("")) {
                ExtensionManager manager = new ExtensionManager();
                List list = manager.getConfigurationElements("eu.geclipse.core.jobs.jobStatus", "JobStatus");
                for (IConfigurationElement element : list) {
                    String attr = element.getAttribute("class");
                    if (!className.equals(attr)) continue;
                    try {
                        this.jobStatus = (GridJobStatus)element.createExecutableExtension("class");
                        this.jobStatus.setXMLNode(rootElement);
                    }
                    catch (CoreException e) {
                        Activator.logException(e);
                        this.jobStatus = null;
                    }
                }
            }
            if (this.jobStatus == null) {
                try {
                    this.jobStatus = new GridJobStatus(rootElement);
                }
                catch (ProblemException problemException) {}
            }
        }
    }

    private void setJobFolderProperties(IFolder jobFolder) {
        try {
            jobFolder.setSessionProperty(new QualifiedName(FOLDER_PROPERTIES_QUALIFIER, FOLDER_PROPERTY_JOBID_CLASS), (Object)this.jobID.getClass().getName());
        }
        catch (CoreException exception) {
            Activator.logException(exception, String.format("Cannot set property for job folder " + jobFolder.getName(), new Object[0]));
        }
    }

    private void testCancelled(IProgressMonitor progressMonitor) {
        if (progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public IGridJobStatus updateJobStatus(IProgressMonitor progressMonitor, boolean fullStatus) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor);
        IGridJobStatus newJobStatus = null;
        try {
            this.testCancelled((IProgressMonitor)subMonitor);
            IGridJobService service = this.getJobService();
            if (service != null && this.jobID.getJobID() != "Unknown") {
                IGridProject project = this.getProject();
                if (project != null) {
                    newJobStatus = service.getJobStatus((IGridJobID)this.jobID, project.getVO(), fullStatus, (IProgressMonitor)subMonitor);
                }
                this.testCancelled((IProgressMonitor)subMonitor);
            }
            if (newJobStatus != null && newJobStatus instanceof GridJobStatus && !subMonitor.isCanceled()) {
                this.jobStatus = (GridJobStatus)newJobStatus;
                this.writeJobStatus(this.jobStatusFile);
            }
        }
        catch (ProblemException e) {
            Activator.logException(e);
        }
        return this.jobStatus;
    }

    private void writeJobDescription(IGridJobDescription description, IFolder jobFolder) throws ProblemException {
        IResource jsdlResource = description.getResource();
        this.jobDescriptionFile = jobFolder.getFile(jsdlResource.getName());
        try {
            jsdlResource.copy(this.jobDescriptionFile.getFullPath(), true, null);
        }
        catch (CoreException exception) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", "Problem while creating job description file", (Throwable)exception, "eu.geclipse.core.jobs");
        }
    }

    private void writeJobID(IGridJobID id, IFolder jobFolder) throws ProblemException {
        IFile file = jobFolder.getFile(JOBID_FILENAME);
        if (!(id instanceof GridJobID)) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementSaveFailed", "GridJobID was expected instead of " + id.getClass(), "eu.geclipse.core.jobs");
        }
        String xml = ((GridJobID)id).getXML();
        try {
            byte[] byteArray = xml.getBytes(XML_CHARSET);
            ByteArrayInputStream baos = new ByteArrayInputStream(byteArray);
            file.create((InputStream)baos, true, null);
        }
        catch (CoreException cExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", "Problem while creating job ID file " + file.getName(), (Throwable)cExc, "eu.geclipse.core.jobs");
        }
        catch (UnsupportedEncodingException e) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", "Problem while creating job ID file ", (Throwable)e, "eu.geclipse.core.jobs");
        }
    }

    private void writeJobInfo(IGridJobDescription description, IFolder jobFolder) throws ProblemException {
        IFile file = jobFolder.getFile(JOBINFO_FILENAME);
        IFile descFile = null;
        if (description.getResource() instanceof IFolder) {
            IFolder sourceDescriptionFolder = (IFolder)description.getResource();
            descFile = sourceDescriptionFolder.getFile(sourceDescriptionFolder.getName());
        } else {
            descFile = (IFile)description.getResource();
        }
        String xml = "<JobInfo><JobDescriptionFileName class=\"" + description.getClass().getName() + "\">" + descFile.getName() + "</" + JOBINFO_JOBDESCRIPTION_XMLNODENAME + ">" + "<" + JOBINFO_SUBMISSIONTIME_XMLNODENAME + ">" + (this.submissionTime != null ? this.getXmlDateFormatter().format(this.submissionTime) : "") + "</" + JOBINFO_SUBMISSIONTIME_XMLNODENAME + ">" + "<" + JOBINFO_JOBNAME + ">" + this.jobName + "</" + JOBINFO_JOBNAME + ">" + "</" + JOBINFO_XMLNODENAME + ">";
        try {
            byte[] byteArray = xml.getBytes(XML_CHARSET);
            ByteArrayInputStream baos = new ByteArrayInputStream(byteArray);
            file.create((InputStream)baos, true, null);
        }
        catch (CoreException cExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", "Problem while creating job information file " + file.getName(), (Throwable)cExc, "eu.geclipse.core.jobs");
        }
        catch (UnsupportedEncodingException e) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", "Problem while creating job information file ", (Throwable)e, "eu.geclipse.core.jobs");
        }
    }

    private void writeJobStatus(IFile _jobStatusFile) throws ProblemException {
        String xml = this.jobStatus.getXML();
        try {
            byte[] byteArray = xml.getBytes(XML_CHARSET);
            ByteArrayInputStream baos = new ByteArrayInputStream(byteArray);
            if (_jobStatusFile.exists()) {
                _jobStatusFile.setContents((InputStream)baos, true, true, null);
            } else if (_jobStatusFile.getParent().exists()) {
                _jobStatusFile.create((InputStream)baos, true, null);
            }
        }
        catch (CoreException cExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", "Problem while writing job status file " + _jobStatusFile.getName(), (Throwable)cExc, "eu.geclipse.core.jobs");
        }
        catch (UnsupportedEncodingException e) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", "Problem while creating job status file ", (Throwable)e, "eu.geclipse.core.jobs");
        }
    }
}

